/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.tools.ij;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import javax.sql.DataSource;
import org.apache.derby.iapi.tools.i18n.LocalizedOutput;
import org.apache.derby.iapi.tools.i18n.LocalizedResource;
import org.apache.derby.impl.tools.ij.ijException;
import org.apache.derby.tools.JDBCDisplayUtil;

public final class util
implements PrivilegedAction<String> {
    private static final Class[] STRING_P = new Class[]{"".getClass()};
    private static final Class[] INT_P = new Class[]{Integer.TYPE};
    private String key;
    private static final String[][] protocolDrivers = new String[][]{{"jdbc:derby:net:", "com.ibm.db2.jcc.DB2Driver"}, {"jdbc:derby://", "org.apache.derby.jdbc.ClientDriver"}, {"jdbc:derby:", "org.apache.derby.jdbc.EmbeddedDriver"}};

    private util() {
    }

    public static String getArg(String string, String[] stringArray) {
        int n;
        if (stringArray == null) {
            return null;
        }
        for (n = 0; n < stringArray.length && !string.equals(stringArray[n]); ++n) {
        }
        if (n >= stringArray.length - 1) {
            return null;
        }
        return stringArray[n + 1];
    }

    public static boolean getPropertyArg(String[] stringArray) throws IOException {
        InputStream inputStream;
        String string = util.getArg("-p", stringArray);
        if (string != null) {
            inputStream = new FileInputStream(string);
            inputStream = new BufferedInputStream(inputStream);
        } else {
            string = util.getArg("-pr", stringArray);
            if (string != null) {
                inputStream = util.getResourceAsStream(string);
                if (inputStream == null) {
                    throw ijException.resourceNotFound();
                }
            } else {
                return false;
            }
        }
        Properties properties = System.getProperties();
        util.loadWithTrimmedValues(inputStream, properties);
        return true;
    }

    static String qualifyResourceName(String string, boolean bl) {
        if ((string = string.trim()).startsWith("/")) {
            return string;
        }
        String string2 = util.getSystemProperty("ij.defaultResourcePackage").trim();
        if (string2 == null) {
            return null;
        }
        string = string2.endsWith("/") ? string2 + string : string2 + "/" + string;
        if (bl && !string.startsWith("/")) {
            return null;
        }
        return string;
    }

    static InputStream getResourceAsStream(String string) {
        final Class<util> clazz = util.class;
        final String string2 = util.qualifyResourceName(string, true);
        if (string2 == null) {
            return null;
        }
        InputStream inputStream = AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

            @Override
            public InputStream run() {
                InputStream inputStream = clazz.getResourceAsStream(string2);
                return inputStream;
            }
        });
        if (inputStream != null) {
            inputStream = new BufferedInputStream(inputStream, 2048);
        }
        return inputStream;
    }

    public static String getFileArg(String[] stringArray) throws IOException {
        boolean bl = false;
        if (stringArray == null) {
            return null;
        }
        String string = util.getArg("-f", stringArray);
        if (string != null) {
            return string;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-f") || stringArray[i].equals("-fr") || stringArray[i].equals("-p") || stringArray[i].equals("-pr")) {
                ++i;
                continue;
            }
            return stringArray[i];
        }
        return null;
    }

    public static String getInputResourceNameArg(String[] stringArray) {
        return util.getArg("-fr", stringArray);
    }

    public static boolean invalidArgs(String[] stringArray) {
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!bl2 && (stringArray[i].equals("-f") || stringArray[i].equals("-fr"))) {
                bl2 = true;
                if (++i < stringArray.length) continue;
                return true;
            }
            if (stringArray[i].equals("-p") || stringArray[i].equals("-pr")) {
                if (++i < stringArray.length) continue;
                return true;
            }
            if (stringArray[i].equals("--help")) {
                return true;
            }
            if (!bl2) {
                bl2 = true;
                continue;
            }
            return true;
        }
        return false;
    }

    static void Usage(LocalizedOutput localizedOutput) {
        localizedOutput.println(LocalizedResource.getMessage("IJ_UsageJavaComCloudToolsIjPPropeInput", new Object[0]));
        localizedOutput.flush();
    }

    public static void setupDataSource(Object object, String string, boolean bl) throws Exception {
        Method[] methodArray = object.getClass().getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            String string2 = method.getName();
            if (!string2.startsWith("set") || string2.length() <= "set".length() || string2.equals("setCreateDatabase") && !bl) continue;
            String string3 = string2.substring("set".length());
            string3 = "ij.dataSource." + string3.substring(0, 1).toLowerCase(Locale.ENGLISH) + string3.substring(1);
            String string4 = util.getSystemProperty(string3);
            if (string2.equals("setDatabaseName") && !bl) {
                string4 = string;
            }
            if (string4 == null) continue;
            try {
                method.invoke(object, string4);
                continue;
            }
            catch (Throwable throwable) {
                method.invoke(object, Integer.valueOf(string4));
            }
        }
    }

    public static Connection getDataSourceConnection(String string, String string2, String string3, String string4, boolean bl) throws SQLException {
        try {
            Class<?> clazz = Class.forName(string);
            if (!DataSource.class.isAssignableFrom(clazz)) {
                throw new ijException(LocalizedResource.getMessage("TL_notInstanceOf", string, DataSource.class.getName()));
            }
            DataSource dataSource = (DataSource)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            util.setupDataSource(dataSource, string4, bl);
            return string2 == null ? dataSource.getConnection() : dataSource.getConnection(string2, string3);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getTargetException() instanceof SQLException) {
                throw (SQLException)invocationTargetException.getTargetException();
            }
            invocationTargetException.printStackTrace(System.out);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
        return null;
    }

    public static Connection startJBMS(String string, String string2, Properties properties) throws SQLException, ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        String string3;
        Connection connection = null;
        String string4 = util.getSystemProperty("driver");
        if (string4 == null) {
            string4 = util.getSystemProperty("ij.driver");
        }
        if (string4 == null || string4.length() == 0) {
            string4 = string;
        }
        if (string4 != null) {
            util.loadDriver(string4);
        }
        if ((string3 = util.getSystemProperty("ij.protocol")) != null) {
            util.loadDriverIfKnown(string3);
        }
        String string5 = util.getSystemProperty("ij.user");
        String string6 = util.getSystemProperty("ij.password");
        String string7 = util.getSystemProperty("database");
        if (string7 == null) {
            string7 = util.getSystemProperty("ij.database");
        }
        if (string7 == null || string7.length() == 0) {
            string7 = string2;
        }
        if (string7 != null) {
            if (string7.startsWith("jdbc:")) {
                util.loadDriverIfKnown(string7);
            }
            if (!string7.startsWith("jdbc:") && string3 != null) {
                string7 = string3 + string7;
            }
            properties = util.updateConnInfo(string5, string6, properties);
            String string8 = util.getSystemProperty("driver");
            if (string8 == null) {
                string8 = "org.apache.derby.jdbc.EmbeddedDriver";
            }
            util.loadDriver(string8);
            connection = DriverManager.getConnection(string7, properties);
            return connection;
        }
        String string9 = util.getSystemProperty("ij.dataSource");
        if (string9 == null) {
            return null;
        }
        connection = util.getDataSourceConnection(string9, string5, string6, null, true);
        return connection;
    }

    public static Properties updateConnInfo(String string, String string2, Properties properties) {
        String string3 = util.getSystemProperty("ij.retrieveMessagesFromServerOnGetMessage");
        boolean bl = false;
        if (util.isJCCFramework()) {
            bl = true;
        }
        if (string3 != null) {
            bl = !string3.equals("false");
        }
        if (properties == null) {
            properties = new Properties();
        }
        if (bl) {
            properties.put("retrieveMessagesFromServerOnGetMessage", "true");
        }
        if (string != null) {
            properties.put("user", string);
        }
        if (string2 != null) {
            properties.put("password", string2);
        }
        return properties;
    }

    public static Connection startJBMS() throws SQLException, ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        return util.startJBMS(null, null);
    }

    public static Connection startJBMS(String string, String string2) throws SQLException, ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        return util.startJBMS(string, string2, null);
    }

    public static void DisplayVector(LocalizedOutput localizedOutput, Vector vector) {
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            localizedOutput.println(vector.elementAt(i));
        }
    }

    public static void DisplayMulti(LocalizedOutput localizedOutput, PreparedStatement preparedStatement, ResultSet resultSet, Connection connection) throws SQLException, ijException {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        bl3 = resultSet.next();
        while (!bl && bl3) {
            if (!bl2) {
                bl2 = true;
                if (connection.getAutoCommit()) {
                    localizedOutput.println(LocalizedResource.getMessage("IJ_IjWarniAutocMayCloseUsingResulSet", new Object[0]));
                    bl = true;
                }
            }
            for (int i = 1; i <= n; ++i) {
                int n2 = resultSetMetaData.getColumnType(i);
                if (n2 == 3) {
                    preparedStatement.setObject(i, resultSet.getObject(i), n2, resultSetMetaData.getScale(i));
                    continue;
                }
                preparedStatement.setObject(i, resultSet.getObject(i), n2);
            }
            bl3 = resultSet.next();
            if (!bl3 || connection.getAutoCommit()) {
                resultSet.close();
            }
            preparedStatement.execute();
            JDBCDisplayUtil.DisplayResults(localizedOutput, (Statement)preparedStatement, connection);
            preparedStatement.clearParameters();
        }
        if (!bl2) {
            resultSet.close();
            throw ijException.noUsingResults();
        }
    }

    static final String getSystemProperty(String string) {
        try {
            if (string.startsWith("ij.") || string.startsWith("derby.")) {
                util util2 = new util();
                util2.key = string;
                return AccessController.doPrivileged(util2);
            }
            return System.getProperty(string);
        }
        catch (SecurityException securityException) {
            return null;
        }
    }

    @Override
    public final String run() {
        return System.getProperty(this.key);
    }

    private static void loadWithTrimmedValues(InputStream inputStream, Properties properties) throws IOException {
        Properties properties2 = new Properties();
        properties2.load(inputStream);
        Enumeration<?> enumeration = properties2.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties2.getProperty(string);
            string2 = string2.trim();
            properties.put(string, string2);
        }
    }

    public static void loadDriverIfKnown(String string) throws ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        for (int i = 0; i < protocolDrivers.length; ++i) {
            if (!string.startsWith(protocolDrivers[i][0])) continue;
            util.loadDriver(protocolDrivers[i][1]);
            break;
        }
    }

    static void loadDriver(String string) throws ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Class<?> clazz = Class.forName(string);
        if (!Driver.class.isAssignableFrom(clazz)) {
            throw new ijException(LocalizedResource.getMessage("TL_notInstanceOf", string, Driver.class.getName()));
        }
        clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    private static boolean isJCCFramework() {
        String string = util.getSystemProperty("framework");
        return string != null && (string.toUpperCase(Locale.ENGLISH).equals("DERBYNET") || string.toUpperCase(Locale.ENGLISH).indexOf("JCC") != -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSelectedSchema(Connection connection) throws SQLException {
        String string = null;
        if (connection == null) {
            return null;
        }
        try (Statement statement = connection.createStatement();){
            if (!statement.execute("VALUES CURRENT SCHEMA")) {
                String string2 = null;
                return string2;
            }
            ResultSet resultSet = statement.getResultSet();
            if (resultSet == null || !resultSet.next()) {
                String string3 = null;
                return string3;
            }
            string = resultSet.getString(1);
        }
        return string;
    }
}

