/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.derbynet;

import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.util.Properties;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import junit.framework.Assert;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.J2EEDataSource;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ClientSideSystemPropertiesTest
extends BaseJDBCTestCase {
    public void testConnection() throws Exception {
        Connection conn = this.openDefaultConnection();
        conn.setAutoCommit(false);
        this.checkTraceFileIsPresent();
        conn.rollback();
        conn.close();
    }

    public void testClientDataSourceConnection() throws Exception {
        Connection conn = JDBCDataSource.getDataSource().getConnection();
        conn.setAutoCommit(false);
        this.checkTraceFileIsPresent();
        conn.rollback();
        conn.close();
    }

    public void testClientCPDataSourceConnection() throws Exception {
        PooledConnection pconn = J2EEDataSource.getConnectionPoolDataSource().getPooledConnection();
        Connection conn = pconn.getConnection();
        conn.setAutoCommit(false);
        this.checkTraceFileIsPresent();
        conn.rollback();
        conn.close();
        pconn.close();
    }

    public void testClientXADataSourceConnection() throws Exception {
        XAConnection xaconn = J2EEDataSource.getXADataSource().getXAConnection();
        Connection conn = xaconn.getConnection();
        conn.setAutoCommit(false);
        this.checkTraceFileIsPresent();
        conn.close();
        xaconn.close();
    }

    private void checkTraceFileIsPresent() {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                int fileCounter;
                File dir = new File(ClientSideSystemPropertiesTest.getSystemProperty("derby.client.traceDirectory"));
                File[] list = dir.listFiles();
                for (fileCounter = 0; fileCounter < list.length; ++fileCounter) {
                    File tempFile = list[fileCounter];
                }
                Assert.assertTrue((fileCounter > 0 ? 1 : 0) != 0);
                return null;
            }
        });
    }

    protected void setUp() throws Exception {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                File dir = new File(ClientSideSystemPropertiesTest.getSystemProperty("derby.client.traceDirectory"));
                if (!dir.exists()) {
                    Assert.assertTrue((dir.mkdir() || dir.mkdirs() ? 1 : 0) != 0);
                } else {
                    File[] list = dir.listFiles();
                    for (int fileCounter = 0; fileCounter < list.length; ++fileCounter) {
                        File tempFile = list[fileCounter];
                        Assert.assertTrue((boolean)tempFile.delete());
                    }
                }
                return null;
            }
        });
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        ClientSideSystemPropertiesTest.removeDirectory(ClientSideSystemPropertiesTest.getSystemProperty("derby.client.traceDirectory"));
    }

    public ClientSideSystemPropertiesTest(String name) {
        super(name);
    }

    public static Test suite() {
        Properties traceRelatedProperties = new Properties();
        traceRelatedProperties.setProperty("derby.client.traceLevel", "64");
        traceRelatedProperties.setProperty("derby.client.traceDirectory", "TraceDir");
        Test suite = TestConfiguration.clientServerSuite(ClientSideSystemPropertiesTest.class);
        return new SystemPropertyTestSetup(suite, traceRelatedProperties);
    }
}

