/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.derbynet;

import java.nio.ByteBuffer;
import java.util.Arrays;
import junit.framework.Test;
import org.apache.derby.impl.drda.Utf8CcsidManager;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.TestConfiguration;

public class Utf8CcsidManagerTest
extends BaseTestCase {
    private Utf8CcsidManager ccsidManager = new Utf8CcsidManager();

    public Utf8CcsidManagerTest(String name) {
        super(name);
    }

    public void testConvertFromJavaString() throws Exception {
        String ucs2String = new String(new String("\u4f60\u597d\u4e16\u754c").getBytes("UTF-16"), "UTF-16");
        byte[] utf8Bytes = new String("\u4f60\u597d\u4e16\u754c").getBytes("UTF-8");
        byte[] utf8Converted = this.ccsidManager.convertFromJavaString(ucs2String);
        Utf8CcsidManagerTest.assertTrue((String)"UTF-8 conversion isn't equal to bytes", (boolean)Arrays.equals(utf8Bytes, utf8Converted));
        ByteBuffer buffer = ByteBuffer.allocate(utf8Bytes.length);
        this.ccsidManager.convertFromJavaString(ucs2String, buffer);
        if (buffer.hasArray()) {
            utf8Converted = buffer.array();
            Utf8CcsidManagerTest.assertTrue((String)"UTF-8 conversion isn't equal to bytes (with buffer)", (boolean)Arrays.equals(utf8Bytes, utf8Converted));
        } else {
            Utf8CcsidManagerTest.fail((String)"Could not convert from UCS2 to UTF-8 using a buffer");
        }
    }

    public void testConvertToJavaString() throws Exception {
        byte[] utf8Bytes = new String("\u4f60\u597d\u4e16\u754c").getBytes("UTF-8");
        String ucs2String = new String(new String("\u4f60\u597d\u4e16\u754c").getBytes("UTF-16"), "UTF-16");
        String offsetUcs2String = new String(new String("\u597d\u4e16").getBytes("UTF-16"), "UTF-16");
        String convertedString = this.ccsidManager.convertToJavaString(utf8Bytes);
        Utf8CcsidManagerTest.assertEquals((String)ucs2String, (String)convertedString);
        String convertedOffset = this.ccsidManager.convertToJavaString(utf8Bytes, 3, 6);
        Utf8CcsidManagerTest.assertEquals((String)offsetUcs2String, (String)convertedOffset);
    }

    public static Test suite() {
        return TestConfiguration.clientServerSuite(Utf8CcsidManagerTest.class);
    }
}

