/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.junit;

import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.DerbyVersion;

public class DerbyVersionTest
extends BaseTestCase {
    private static final DerbyVersion _10_2 = new DerbyVersion(10, 2, 0, 0);
    private static final DerbyVersion _10_2_2_0 = new DerbyVersion(10, 2, 2, 2);
    private static final DerbyVersion _10_3 = new DerbyVersion(10, 3, 0, 0);
    private static final DerbyVersion _10_4 = new DerbyVersion(10, 4, 0, 0);
    private static final DerbyVersion _10_5 = new DerbyVersion(10, 5, 0, 0);
    private static final DerbyVersion _10_5_1_1 = new DerbyVersion(10, 5, 1, 1);
    private static final DerbyVersion _10_5_2_0 = new DerbyVersion(10, 5, 2, 0);
    private static final DerbyVersion _10_5_3_0 = new DerbyVersion(10, 5, 3, 0);
    private static final DerbyVersion _10_6 = new DerbyVersion(10, 6, 0, 0);
    private static final DerbyVersion _10_7 = new DerbyVersion(10, 7, 0, 0);
    private static final DerbyVersion _10_8 = new DerbyVersion(10, 8, 0, 0);
    private static final DerbyVersion _10_8_1_2 = new DerbyVersion(10, 8, 1, 2);
    private static final DerbyVersion _10_9 = new DerbyVersion(10, 9, 0, 0);
    private static final DerbyVersion _11_0 = new DerbyVersion(11, 0, 0, 0);
    private static final DerbyVersion _11_9 = new DerbyVersion(11, 9, 9, 9);

    public DerbyVersionTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new BaseTestSuite(DerbyVersionTest.class, "DerbyVersionTest tests");
    }

    public void testLessThan() {
        DerbyVersionTest.assertTrue((boolean)_10_2.lessThan(_10_2_2_0));
        DerbyVersionTest.assertTrue((boolean)_10_2.lessThan(_10_3));
        DerbyVersionTest.assertTrue((boolean)_10_5.lessThan(_10_5_1_1));
        DerbyVersionTest.assertTrue((boolean)_10_5_1_1.lessThan(_10_5_2_0));
        DerbyVersionTest.assertTrue((boolean)_10_5_2_0.lessThan(_10_5_3_0));
        DerbyVersionTest.assertTrue((boolean)_10_8_1_2.lessThan(_11_0));
        DerbyVersionTest.assertTrue((boolean)_10_8_1_2.lessThan(_11_9));
        DerbyVersionTest.assertFalse((boolean)_10_5.lessThan(_10_4));
        DerbyVersionTest.assertFalse((boolean)_10_5.lessThan(_10_5));
        DerbyVersionTest.assertFalse((boolean)_11_0.lessThan(_10_8));
        DerbyVersionTest.assertFalse((boolean)_11_9.lessThan(_10_7));
    }

    public void testAtLeast() {
        DerbyVersionTest.assertTrue((boolean)_10_4.atLeast(_10_4));
        DerbyVersionTest.assertTrue((boolean)_10_4.atLeast(_10_3));
        DerbyVersionTest.assertTrue((boolean)_10_5_2_0.atLeast(_10_5_1_1));
        DerbyVersionTest.assertFalse((boolean)_10_2.atLeast(_10_4));
        DerbyVersionTest.assertFalse((boolean)_10_2.atLeast(_11_0));
        DerbyVersionTest.assertFalse((boolean)_10_5_1_1.atLeast(_10_5_3_0));
    }

    public void testGreaterThan() {
        DerbyVersionTest.assertTrue((boolean)_10_5_3_0.greaterThan(_10_5_2_0));
        DerbyVersionTest.assertTrue((boolean)_10_5_3_0.greaterThan(_10_5_1_1));
        DerbyVersionTest.assertTrue((boolean)_10_5_3_0.greaterThan(_10_2));
        DerbyVersionTest.assertFalse((boolean)_10_2.greaterThan(_10_3));
        DerbyVersionTest.assertFalse((boolean)_10_8.greaterThan(_11_0));
    }

    public void testAtMost() {
        DerbyVersionTest.assertTrue((boolean)_10_4.atMost(_10_5));
        DerbyVersionTest.assertTrue((boolean)_10_8.atMost(_11_9));
        DerbyVersionTest.assertFalse((boolean)_10_7.atMost(_10_2));
        DerbyVersionTest.assertFalse((boolean)_11_0.atMost(_10_5_3_0));
    }

    public void testAtMajorMinor() {
        DerbyVersionTest.assertTrue((boolean)_10_4.atMajorMinor(10, 4));
        DerbyVersionTest.assertFalse((boolean)_10_2.atMajorMinor(10, 1));
        DerbyVersionTest.assertFalse((boolean)_10_2.atMajorMinor(10, 3));
        DerbyVersionTest.assertFalse((boolean)_10_2.atMajorMinor(11, 2));
    }

    public void testAtMajorMinorOf() {
        DerbyVersionTest.assertTrue((boolean)_10_5.atMajorMinorOf(_10_5_1_1));
        DerbyVersionTest.assertTrue((boolean)_10_5.atMajorMinorOf(_10_5_2_0));
        DerbyVersionTest.assertTrue((boolean)_10_5.atMajorMinorOf(_10_5_3_0));
        DerbyVersionTest.assertTrue((boolean)_10_5_3_0.atMajorMinorOf(_10_5_3_0));
        DerbyVersionTest.assertTrue((boolean)_10_5_3_0.atMajorMinorOf(_10_5_1_1));
        DerbyVersionTest.assertFalse((boolean)_10_5_2_0.atMajorMinorOf(_10_3));
        DerbyVersionTest.assertFalse((boolean)_10_5_2_0.atMajorMinorOf(_11_9));
        DerbyVersionTest.assertFalse((boolean)_10_5_2_0.atMajorMinorOf(_10_2));
        DerbyVersionTest.assertFalse((boolean)_10_5_2_0.atMajorMinorOf(_10_2_2_0));
    }

    public void testGetMajor() {
        DerbyVersionTest.assertEquals((int)10, (int)_10_5_1_1.getMajor());
        DerbyVersionTest.assertEquals((int)10, (int)_10_8.getMajor());
        DerbyVersionTest.assertEquals((int)11, (int)_11_9.getMajor());
    }

    public void testGetMinor() {
        DerbyVersionTest.assertEquals((int)5, (int)_10_5_1_1.getMinor());
        DerbyVersionTest.assertEquals((int)8, (int)_10_8.getMinor());
        DerbyVersionTest.assertEquals((int)9, (int)_11_9.getMinor());
    }

    public void testGetFixpack() {
        DerbyVersionTest.assertEquals((int)1, (int)_10_5_1_1.getFixpack());
        DerbyVersionTest.assertEquals((int)0, (int)_10_8.getFixpack());
        DerbyVersionTest.assertEquals((int)9, (int)_11_9.getFixpack());
    }

    public void testGetPoint() {
        DerbyVersionTest.assertEquals((int)1, (int)_10_5_1_1.getPoint());
        DerbyVersionTest.assertEquals((int)0, (int)_10_8.getPoint());
        DerbyVersionTest.assertEquals((int)9, (int)_11_9.getPoint());
    }

    public void testCreateGet() {
        DerbyVersion v = new DerbyVersion(1, 2, 3, 4);
        DerbyVersionTest.assertEquals((int)1, (int)v.getMajor());
        DerbyVersionTest.assertEquals((int)2, (int)v.getMinor());
        DerbyVersionTest.assertEquals((int)3, (int)v.getFixpack());
        DerbyVersionTest.assertEquals((int)4, (int)v.getPoint());
    }

    public void testCompareTo() {
        DerbyVersionTest.assertTrue((_10_5_1_1.compareTo(_10_2) > 0 ? 1 : 0) != 0);
        DerbyVersionTest.assertTrue((_10_5_1_1.compareTo(_10_8) < 0 ? 1 : 0) != 0);
        DerbyVersionTest.assertTrue((_11_0.compareTo(_11_9) < 0 ? 1 : 0) != 0);
        DerbyVersionTest.assertEquals((int)0, (int)_11_0.compareTo(_11_0));
        DerbyVersionTest.assertEquals((int)0, (int)_10_2.compareTo(_10_2));
    }

    public void testEquals() {
        DerbyVersionTest.assertTrue((boolean)_10_6.equals(_10_6));
        DerbyVersionTest.assertFalse((boolean)_10_2.equals((Object)this));
        DerbyVersionTest.assertFalse((boolean)_10_2.equals(null));
        DerbyVersionTest.assertFalse((boolean)_11_0.equals(_10_8));
        DerbyVersionTest.assertFalse((boolean)_10_5_2_0.equals(_10_5_3_0));
    }

    public void testParseString() {
        DerbyVersion dv = DerbyVersion.parseVersionString("10.9.0.0 alpha - (1180861M)");
        DerbyVersionTest.assertTrue((boolean)dv.equals(_10_9));
        DerbyVersionTest.assertEquals((int)0, (int)dv.compareTo(_10_9));
        dv = DerbyVersion.parseVersionString("10.8.1.2");
        DerbyVersionTest.assertTrue((boolean)dv.equals(_10_8_1_2));
        DerbyVersionTest.assertEquals((int)0, (int)dv.compareTo(_10_8_1_2));
        dv = DerbyVersion.parseVersionString("   10.8.1.2   ");
        DerbyVersionTest.assertTrue((boolean)dv.equals(_10_8_1_2));
        DerbyVersionTest.assertEquals((int)0, (int)dv.compareTo(_10_8_1_2));
        try {
            dv = DerbyVersion.parseVersionString("10.8.1");
            DerbyVersionTest.fail((String)"should have failed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            dv = DerbyVersion.parseVersionString("10.8.1.");
            DerbyVersionTest.fail((String)"should have failed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            dv = DerbyVersion.parseVersionString("10.8.1.two");
            DerbyVersionTest.fail((String)"should have failed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

