/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Properties;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.sql.execute.RowChanger;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.NumberDataValue;
import org.apache.derby.impl.sql.execute.AutoincrementCounter;
import org.apache.derby.impl.sql.execute.DMLWriteResultSet;
import org.apache.derby.impl.sql.execute.InternalTriggerExecutionContext;
import org.apache.derby.impl.sql.execute.TemporaryRowHolderImpl;
import org.apache.derby.impl.sql.execute.ValueRow;
import org.apache.derby.shared.common.sanity.SanityManager;

public abstract class DMLWriteGeneratedColumnsResultSet
extends DMLWriteResultSet {
    protected DataValueDescriptor[] aiCache;
    protected String identitySequenceUUIDString;
    protected NoPutResultSet sourceResultSet;
    protected ResultSet autoGeneratedKeysResultSet;
    protected TemporaryRowHolderImpl autoGeneratedKeysRowsHolder;
    protected int[] autoGeneratedKeysColumnIndexes;
    protected boolean autoincrementGenerated;
    protected long identityVal;
    protected boolean setIdentity;

    DMLWriteGeneratedColumnsResultSet(Activation activation) throws StandardException {
        this(activation, activation.getConstantAction());
    }

    DMLWriteGeneratedColumnsResultSet(Activation activation, ConstantAction constantAction) throws StandardException {
        super(activation, constantAction);
    }

    public NumberDataValue getSetAutoincrementValue(int columnPosition, long increment) throws StandardException {
        SanityManager.NOTREACHED();
        return null;
    }

    public void saveAIcacheInformation(String schemaName, String tableName, String[] columnNames) throws StandardException {
        if (this.aiCache != null) {
            HashMap<String, Long> aiHashtable = new HashMap<String, Long>();
            int numColumns = this.aiCache.length;
            for (int i = 0; i < numColumns; ++i) {
                if (this.aiCache[i] == null) continue;
                aiHashtable.put(AutoincrementCounter.makeIdentity(schemaName, tableName, columnNames[i]), this.aiCache[i].getLong());
            }
            InternalTriggerExecutionContext itec = (InternalTriggerExecutionContext)this.lcc.getTriggerExecutionContext();
            if (itec == null) {
                this.lcc.copyHashtableToAIHT(aiHashtable);
            } else {
                itec.copyHashtableToAIHT(aiHashtable);
            }
        }
        this.autoGeneratedKeysResultSet = this.activation.getAutoGeneratedKeysResultsetMode() ? this.autoGeneratedKeysRowsHolder.getResultSet() : null;
    }

    protected void verifyAutoGeneratedRScolumnsList(UUID targetUUID) throws StandardException {
        if (this.activation.getAutoGeneratedKeysResultsetMode()) {
            int[] agi = this.activation.getAutoGeneratedKeysColumnIndexes();
            if (agi != null) {
                this.verifyAutoGeneratedColumnsIndexes(agi, targetUUID);
            } else {
                String[] agc = this.activation.getAutoGeneratedKeysColumnNames();
                if (agc != null) {
                    this.verifyAutoGeneratedColumnsNames(agc, targetUUID);
                }
            }
        }
    }

    private void verifyAutoGeneratedColumnsIndexes(int[] columnIndexes, UUID targetUUID) throws StandardException {
        int size = columnIndexes.length;
        TableDescriptor tabDesc = this.lcc.getDataDictionary().getTableDescriptor(targetUUID);
        for (int i = 0; i < size; ++i) {
            ColumnDescriptor cd = tabDesc.getColumnDescriptor(columnIndexes[i]);
            if (this.verifyAutoGenColumn(cd)) continue;
            throw StandardException.newException("X0X0E.S", columnIndexes[i], tabDesc.getName());
        }
    }

    private void verifyAutoGeneratedColumnsNames(String[] columnNames, UUID targetUUID) throws StandardException {
        int size = columnNames.length;
        int[] columnPositions = new int[size];
        TableDescriptor tabDesc = this.lcc.getDataDictionary().getTableDescriptor(targetUUID);
        for (int i = 0; i < size; ++i) {
            if (columnNames[i] == null) {
                throw StandardException.newException("X0X0F.S", columnNames[i], tabDesc.getName());
            }
            ColumnDescriptor cd = tabDesc.getColumnDescriptor(columnNames[i]);
            if (!this.verifyAutoGenColumn(cd)) {
                throw StandardException.newException("X0X0F.S", columnNames[i], tabDesc.getName());
            }
            columnPositions[i] = cd.getPosition();
        }
        this.activation.setAutoGeneratedKeysResultsetInfo(columnPositions, null);
    }

    private boolean verifyAutoGenColumn(ColumnDescriptor cd) {
        return cd != null && cd.isAutoincrement();
    }

    protected void firstExecuteSpecialHandlingAutoGen(boolean firstExecute, RowChanger rowChanger, UUID targetUUID) throws StandardException {
        if (firstExecute && this.activation.getAutoGeneratedKeysResultsetMode()) {
            Properties properties = new Properties();
            this.autoGeneratedKeysColumnIndexes = this.activation.getAutoGeneratedKeysColumnIndexes();
            rowChanger.getHeapConglomerateController().getInternalTablePropertySet(properties);
            this.autoGeneratedKeysColumnIndexes = this.autoGeneratedKeysColumnIndexes != null ? this.uniqueColumnPositionArray(this.autoGeneratedKeysColumnIndexes, targetUUID) : this.generatedColumnPositionsArray(targetUUID);
            ResultDescription rd = this.lcc.getLanguageFactory().getResultDescription(this.resultDescription, this.autoGeneratedKeysColumnIndexes);
            this.autoGeneratedKeysRowsHolder = new TemporaryRowHolderImpl(this.activation, properties, rd);
        }
    }

    private int[] generatedColumnPositionsArray(UUID targetUUID) throws StandardException {
        TableDescriptor tabDesb = this.lcc.getDataDictionary().getTableDescriptor(targetUUID);
        int size = tabDesb.getMaxColumnID();
        int[] generatedColumnPositionsArray = new int[size];
        Arrays.fill(generatedColumnPositionsArray, -1);
        int generatedColumnNumbers = 0;
        for (int i = 0; i < size; ++i) {
            ColumnDescriptor cd = tabDesb.getColumnDescriptor(i + 1);
            if (cd.isAutoincrement()) {
                ++generatedColumnNumbers;
                generatedColumnPositionsArray[i] = i + 1;
                continue;
            }
            if (cd.getDefaultValue() == null && cd.getDefaultInfo() == null) continue;
            ++generatedColumnNumbers;
            generatedColumnPositionsArray[i] = i + 1;
        }
        int[] returnGeneratedColumnPositionsArray = new int[generatedColumnNumbers];
        int j = 0;
        for (int i = 0; i < size; ++i) {
            if (generatedColumnPositionsArray[i] == -1) continue;
            returnGeneratedColumnPositionsArray[j++] = generatedColumnPositionsArray[i];
        }
        return returnGeneratedColumnPositionsArray;
    }

    private int[] uniqueColumnPositionArray(int[] columnIndexes, UUID targetUUID) throws StandardException {
        int size = columnIndexes.length;
        TableDescriptor tabDesc = this.lcc.getDataDictionary().getTableDescriptor(targetUUID);
        int[] uniqueColumnIndexes = new int[tabDesc.getMaxColumnID()];
        int uniqueColumnNumbers = 0;
        for (int i = 0; i < size; ++i) {
            if (uniqueColumnIndexes[columnIndexes[i] - 1] != 0) continue;
            ++uniqueColumnNumbers;
            uniqueColumnIndexes[columnIndexes[i] - 1] = columnIndexes[i];
        }
        int[] returnUniqueColumnIndexes = new int[uniqueColumnNumbers];
        int j = 0;
        for (int i = 0; i < uniqueColumnIndexes.length; ++i) {
            if (uniqueColumnIndexes[i] == 0) continue;
            returnUniqueColumnIndexes[j++] = uniqueColumnIndexes[i];
        }
        return returnUniqueColumnIndexes;
    }

    protected ExecRow getCompactRow(ExecRow inputRow, int[] columnIndexes) throws StandardException {
        int numInputCols = inputRow.nColumns();
        if (columnIndexes == null) {
            ValueRow outRow = new ValueRow(numInputCols);
            DataValueDescriptor[] src = inputRow.getRowArray();
            DataValueDescriptor[] dst = outRow.getRowArray();
            System.arraycopy(src, 0, dst, 0, src.length);
            return outRow;
        }
        int numOutputCols = columnIndexes.length;
        ValueRow outRow = new ValueRow(numOutputCols);
        for (int i = 0; i < numOutputCols; ++i) {
            outRow.setColumn(i + 1, inputRow.getColumn(columnIndexes[i]));
        }
        return outRow;
    }

    @Override
    public ResultSet getAutoGeneratedKeysResultset() {
        return this.autoGeneratedKeysResultSet;
    }
}

