/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.impl.store.raw.data.AllocPage;
import org.apache.derby.impl.store.raw.data.AllocPageOperation;
import org.apache.derby.impl.store.raw.data.AllocationActions;
import org.apache.derby.impl.store.raw.data.BasePage;
import org.apache.derby.impl.store.raw.data.ChainAllocPageOperation;
import org.apache.derby.impl.store.raw.data.CompressSpacePageOperation;
import org.apache.derby.impl.store.raw.data.CompressSpacePageOperation10_2;

public class LoggableAllocActions
implements AllocationActions {
    @Override
    public void actionAllocatePage(RawTransaction t, BasePage allocPage, long pageNumber, int doStatus, int undoStatus) throws StandardException {
        AllocPageOperation lop = new AllocPageOperation((AllocPage)allocPage, pageNumber, doStatus, undoStatus);
        allocPage.preDirty();
        t.logAndDo(lop);
    }

    @Override
    public void actionChainAllocPage(RawTransaction t, BasePage allocPage, long pageNumber, long pageOffset) throws StandardException {
        ChainAllocPageOperation lop = new ChainAllocPageOperation((AllocPage)allocPage, pageNumber, pageOffset);
        allocPage.preDirty();
        t.logAndDo(lop);
    }

    @Override
    public void actionCompressSpaceOperation(RawTransaction t, BasePage allocPage, int new_highest_page, int num_pages_truncated) throws StandardException {
        CompressSpacePageOperation lop = null;
        lop = t.getLogFactory().checkVersion(10, 3, null) ? new CompressSpacePageOperation((AllocPage)allocPage, new_highest_page, num_pages_truncated) : new CompressSpacePageOperation10_2((AllocPage)allocPage, new_highest_page, num_pages_truncated);
        allocPage.preDirty();
        t.logAndDo(lop);
    }
}

