/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.vti;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import org.apache.derby.iapi.services.io.ArrayUtil;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.vti.ForwardingVTI;
import org.apache.derby.vti.RestrictedVTI;
import org.apache.derby.vti.Restriction;

public class ForeignTableVTI
extends ForwardingVTI
implements RestrictedVTI {
    private static HashMap<String, Connection> _connections = new HashMap();
    private String _foreignSchemaName;
    private String _foreignTableName;
    private String _connectionURL;
    private Connection _foreignConnection;
    private String[] _columnNames;
    private Restriction _restriction;
    private int[] _columnNumberMap;
    private PreparedStatement _foreignPreparedStatement;

    public ForeignTableVTI(String foreignSchemaName, String foreignTableName, Connection foreignConnection) {
        this._foreignSchemaName = foreignSchemaName;
        this._foreignTableName = foreignTableName;
        this._foreignConnection = foreignConnection;
    }

    protected ForeignTableVTI(String foreignSchemaName, String foreignTableName, String connectionURL) {
        this._foreignSchemaName = foreignSchemaName;
        this._foreignTableName = foreignTableName;
        this._connectionURL = connectionURL;
    }

    public static ForeignTableVTI readForeignTable(String foreignSchemaName, String foreignTableName, String connectionURL) {
        return new ForeignTableVTI(foreignSchemaName, foreignTableName, connectionURL);
    }

    public static void dropConnection(String connectionURL) {
        _connections.remove(connectionURL);
    }

    public static int countConnections() {
        return _connections.size();
    }

    @Override
    public void close() throws SQLException {
        if (!this.isClosed()) {
            this._foreignSchemaName = null;
            this._foreignTableName = null;
            this._connectionURL = null;
            this._columnNames = null;
            this._restriction = null;
            this._columnNumberMap = null;
            if (this.getWrappedResultSet() != null) {
                this.getWrappedResultSet().close();
            }
            if (this._foreignPreparedStatement != null) {
                this._foreignPreparedStatement.close();
            }
            this.wrapResultSet(null);
            this._foreignPreparedStatement = null;
            this._foreignConnection = null;
        }
    }

    @Override
    public boolean next() throws SQLException {
        if (!this.isClosed() && this.getWrappedResultSet() == null) {
            this._foreignPreparedStatement = ForeignTableVTI.prepareStatement(ForeignTableVTI.getForeignConnection(this._connectionURL, this._foreignConnection), this.makeQuery());
            this.wrapResultSet(this._foreignPreparedStatement.executeQuery());
        }
        return this.getWrappedResultSet().next();
    }

    @Override
    public boolean isClosed() {
        return this._connectionURL == null && this._foreignConnection == null;
    }

    @Override
    public void initScan(String[] columnNames, Restriction restriction) throws SQLException {
        this._columnNames = ArrayUtil.copy(columnNames);
        this._restriction = restriction;
        int columnCount = this._columnNames.length;
        this._columnNumberMap = new int[columnCount];
        int foreignColumnID = 1;
        for (int i = 0; i < columnCount; ++i) {
            if (this._columnNames[i] == null) continue;
            this._columnNumberMap[i] = foreignColumnID++;
        }
    }

    private static Connection getForeignConnection(String connectionURL, Connection foreignConnection) throws SQLException {
        if (foreignConnection != null) {
            return foreignConnection;
        }
        Connection conn = _connections.get(connectionURL);
        if (conn == null && (conn = DriverManager.getConnection(connectionURL)) != null) {
            _connections.put(connectionURL, conn);
        }
        return conn;
    }

    private String makeQuery() {
        String clause;
        StringBuilder buffer = new StringBuilder();
        buffer.append("select ");
        int possibleCount = this._columnNames.length;
        int actualCount = 0;
        for (int i = 0; i < possibleCount; ++i) {
            String rawName = this._columnNames[i];
            if (rawName == null) continue;
            if (actualCount > 0) {
                buffer.append(", ");
            }
            ++actualCount;
            buffer.append(ForeignTableVTI.delimitedID(rawName));
        }
        buffer.append("\nfrom ");
        buffer.append(ForeignTableVTI.delimitedID(this._foreignSchemaName));
        buffer.append('.');
        buffer.append(ForeignTableVTI.delimitedID(this._foreignTableName));
        if (this._restriction != null && (clause = this._restriction.toSQL()) != null && (clause = clause.trim()).length() != 0) {
            buffer.append("\nwhere " + clause);
        }
        return buffer.toString();
    }

    private static String delimitedID(String text) {
        return IdUtil.normalToDelimited(text);
    }

    private static PreparedStatement prepareStatement(Connection conn, String text) throws SQLException {
        return conn.prepareStatement(text);
    }

    @Override
    protected int mapColumnNumber(int derbyNumber) {
        return this._columnNumberMap[derbyNumber - 1];
    }
}

