/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derby.tools.ij;

public class ConcurrentImplicitCreateSchema {
    boolean passed = true;

    public static void main(String[] args) {
        new ConcurrentImplicitCreateSchema().go(args);
    }

    void go(String[] args) {
        System.out.println("Test ConcurrentImplicitCreateSchema starting");
        try {
            int i;
            ij.getPropertyArg((String[])args);
            Connection conn = ij.startJBMS();
            conn.setAutoCommit(true);
            Statement s = conn.createStatement();
            boolean NSCHEMAS = true;
            for (int i2 = 0; i2 < 1; ++i2) {
                try {
                    s.execute("drop schema testschema" + i2 + " restrict");
                    continue;
                }
                catch (SQLException e) {
                    if (e.getSQLState().equals("42Y07")) continue;
                    throw e;
                }
            }
            int NTHREADS = 100;
            Thread[] threads = new Thread[100];
            for (i = 0; i < 100; ++i) {
                threads[i] = new Thread(new CreateTable(i, i % 1, this));
            }
            for (i = 0; i < 100; ++i) {
                threads[i].start();
            }
            for (i = 0; i < 100; ++i) {
                threads[i].join();
            }
            conn.close();
            System.out.println("Closed connection");
        }
        catch (Throwable e) {
            System.out.println("exception thrown:");
            this.failed(e);
        }
        System.out.print("Test ConcurrentImplicitCreateSchema ");
        if (this.passed) {
            System.out.println("PASSED");
        } else {
            System.out.println("FAILED");
        }
    }

    void failed(Throwable e) {
        if (e instanceof SQLException) {
            this.printSQLError((SQLException)e);
        } else {
            e.printStackTrace();
        }
        this.passed = false;
    }

    void printSQLError(SQLException e) {
        while (e != null) {
            System.out.println(e.toString());
            e.printStackTrace();
            e = e.getNextException();
        }
    }

    class CreateTable
    implements Runnable {
        private int myId;
        private int schemaId;
        private Connection conn = null;
        private ConcurrentImplicitCreateSchema test;

        CreateTable(int id, int schemaId, ConcurrentImplicitCreateSchema test) throws SQLException, IllegalAccessException, ClassNotFoundException, InstantiationException, NoSuchMethodException, InvocationTargetException {
            this.myId = id;
            this.schemaId = schemaId;
            this.test = test;
            this.conn = ij.startJBMS();
            this.conn.setAutoCommit(false);
        }

        @Override
        public void run() {
            try {
                Statement s = this.conn.createStatement();
                s.execute("create table testschema" + this.schemaId + ".testtab" + this.myId + "(num int, addr varchar(40))");
                s.execute("drop table testschema" + this.schemaId + ".testtab" + this.myId);
            }
            catch (SQLException e) {
                this.test.failed(e);
            }
            try {
                this.conn.commit();
                this.conn.close();
            }
            catch (SQLException e) {
                this.test.failed(e);
            }
        }
    }
}

