/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derby.tools.ij;
import org.apache.derbyTesting.functionTests.tests.lang.WISCInsert;

public class wisconsin {
    public static void main(String[] args) throws Throwable {
        ij.getPropertyArg((String[])args);
        Connection conn = ij.startJBMS();
        conn.setAutoCommit(false);
        conn.setTransactionIsolation(8);
        wisconsin.createTables(conn, true);
        String resource = "org/apache/derbyTesting/functionTests/tests/lang/wisc_setup.sql";
        URL sql = wisconsin.getTestResource(resource);
        InputStream sqlIn = wisconsin.openTestResource(sql);
        if (sqlIn == null) {
            throw new Exception("SQL Resource missing:" + resource);
        }
        BufferedInputStream inStream = new BufferedInputStream(sqlIn, 2048);
        ij.runScript((Connection)conn, (InputStream)inStream, (String)"US-ASCII", (OutputStream)System.out, (String)null);
        conn.commit();
    }

    public static void createTables(Connection conn, boolean compress) throws SQLException {
        wisconsin.createTables(conn, compress, 10000);
    }

    public static void createTables(Connection conn, boolean compress, int numRows) throws SQLException {
        Statement stmt = conn.createStatement();
        stmt.execute("create table TENKTUP1 ( unique1 int not null, unique2 int not null, two int, four int, ten int, twenty int, onePercent int, tenPercent int, twentyPercent int, fiftyPercent int, unique3 int, evenOnePercent int, oddOnePercent int, stringu1 char(52) not null, stringu2 char(52) not null, string4 char(52) )");
        WISCInsert wi = new WISCInsert();
        wi.doWISCInsert(numRows, "TENKTUP1", conn);
        stmt.execute("create unique index TK1UNIQUE1 on TENKTUP1(unique1)");
        stmt.execute("create unique index TK1UNIQUE2 on TENKTUP1(unique2)");
        stmt.execute("create index TK1TWO on TENKTUP1(two)");
        stmt.execute("create index TK1FOUR on TENKTUP1(four)");
        stmt.execute("create index TK1TEN on TENKTUP1(ten)");
        stmt.execute("create index TK1TWENTY on TENKTUP1(twenty)");
        stmt.execute("create index TK1ONEPERCENT on TENKTUP1(onePercent)");
        stmt.execute("create index TK1TWENTYPERCENT on TENKTUP1(twentyPercent)");
        stmt.execute("create index TK1EVENONEPERCENT on TENKTUP1(evenOnePercent)");
        stmt.execute("create index TK1ODDONEPERCENT on TENKTUP1(oddOnePercent)");
        stmt.execute("create unique index TK1STRINGU1 on TENKTUP1(stringu1)");
        stmt.execute("create unique index TK1STRINGU2 on TENKTUP1(stringu2)");
        stmt.execute("create index TK1STRING4 on TENKTUP1(string4)");
        stmt.execute("create table TENKTUP2 (unique1 int not null, unique2 int not null, two int, four int, ten int, twenty int, onePercent int, tenPercent int, twentyPercent int, fiftyPercent int, unique3 int, evenOnePercent int, oddOnePercent int, stringu1 char(52), stringu2 char(52), string4 char(52) )");
        wi = new WISCInsert();
        wi.doWISCInsert(numRows, "TENKTUP2", conn);
        stmt.execute("create unique index TK2UNIQUE1 on TENKTUP2(unique1)");
        stmt.execute("create unique index TK2UNIQUE2 on TENKTUP2(unique2)");
        stmt.execute("create table ONEKTUP ( unique1 int not null, unique2 int not null, two int, four int, ten int, twenty int, onePercent int, tenPercent int, twentyPercent int, fiftyPercent int, unique3 int, evenOnePercent int, oddOnePercent int, stringu1 char(52), stringu2 char(52), string4 char(52) )");
        wi = new WISCInsert();
        wi.doWISCInsert(1000, "ONEKTUP", conn);
        stmt.execute("create unique index ONEKUNIQUE1 on ONEKTUP(unique1)");
        stmt.execute("create unique index ONEKUNIQUE2 on ONEKTUP(unique2)");
        stmt.execute("create table BPRIME (\t unique1 int, unique2 int, two int, four int, ten int, twenty int, onePercent int, tenPercent int, twentyPercent int, fiftyPercent int, unique3 int, evenOnePercent int, oddOnePercent int, stringu1 char(52), stringu2 char(52), string4 char(52))");
        stmt.execute("insert into BPRIME select * from TENKTUP2 where TENKTUP2.unique2 < 1000");
        conn.commit();
        if (!compress) {
            return;
        }
        PreparedStatement ps2 = conn.prepareStatement("call SYSCS_UTIL.SYSCS_COMPRESS_TABLE(?, ?, ?)");
        ps2.setString(1, "APP");
        ps2.setString(2, "BPRIME");
        ps2.setInt(3, 0);
        ps2.executeUpdate();
        conn.commit();
        ps2.setString(1, "APP");
        ps2.setString(2, "TENKTUP1");
        ps2.setInt(3, 0);
        ps2.executeUpdate();
        conn.commit();
        ps2.setString(1, "APP");
        ps2.setString(2, "TENKTUP2");
        ps2.setInt(3, 0);
        ps2.executeUpdate();
        conn.commit();
        ps2.setString(1, "APP");
        ps2.setString(2, "ONEKTUP");
        ps2.setInt(3, 0);
        ps2.executeUpdate();
        conn.commit();
    }

    protected static InputStream openTestResource(final URL url) throws PrivilegedActionException {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

            @Override
            public InputStream run() throws IOException {
                return url.openStream();
            }
        });
    }

    protected static URL getTestResource(final String name) {
        return AccessController.doPrivileged(new PrivilegedAction<URL>(){

            @Override
            public URL run() {
                return this.getClass().getClassLoader().getResource(name);
            }
        });
    }
}

