/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.net;

import org.apache.derby.client.ClientPooledConnection;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.ClientStatement;
import org.apache.derby.client.am.LogWriter;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.net.NetConnection;
import org.apache.derby.client.net.NetXACallInfo;
import org.apache.derby.client.net.NetXAResource;
import org.apache.derby.jdbc.BasicClientDataSource40;
import org.apache.derby.jdbc.ClientDriver;

public class NetXAConnection {
    private NetConnection netCon;

    public NetXAConnection(LogWriter logWriter, String user, String password, BasicClientDataSource40 dataSource, int rmId, boolean isXAConn, ClientPooledConnection cpc) throws SqlException {
        this.netCon = this.createNetConnection(logWriter, user, password, dataSource, rmId, isXAConn, cpc);
        this.checkPlatformVersion();
    }

    public void setCorrelatorToken(byte[] crttoken) {
        this.netCon.crrtkn_ = crttoken;
    }

    void setNetXAResource(NetXAResource xares) {
        this.netCon.xares_ = xares;
    }

    private void writeLocalXACommit_() throws SqlException {
        this.netCon.netAgent_.netConnectionRequest_.writeLocalXACommit(this.netCon);
    }

    private void readLocalXACommit_() throws SqlException {
        this.netCon.netAgent_.netConnectionReply_.readLocalXACommit(this.netCon);
    }

    private void writeLocalXARollback_() throws SqlException {
        this.netCon.netAgent_.netConnectionRequest_.writeLocalXARollback(this.netCon);
    }

    private void readLocalXARollback_() throws SqlException {
        this.netCon.netAgent_.netConnectionReply_.readLocalXARollback(this.netCon);
    }

    void writeTransactionStart(ClientStatement statement) throws SqlException {
        if (!this.netCon.isXAConnection()) {
            return;
        }
        int xaState = this.netCon.getXAState();
        this.netCon.xares_.exceptionsOnXA = null;
    }

    void writeCommit() throws SqlException {
        int xaState = this.netCon.getXAState();
        if (xaState == 0) {
            this.netCon.xares_.callInfoArray_[this.netCon.xares_.conn_.currXACallInfoOffset_].xid_ = NetXAResource.nullXid;
            this.writeLocalXACommit_();
        }
    }

    void readCommit() throws SqlException {
        int xaState = this.netCon.getXAState();
        NetXACallInfo callInfo = this.netCon.xares_.callInfoArray_[this.netCon.currXACallInfoOffset_];
        callInfo.xaRetVal_ = 0;
        if (xaState == 0) {
            this.readLocalXACommit_();
        }
        if (callInfo.xaRetVal_ != 0) {
            callInfo.xaFunction_ = 1;
            this.netCon.xares_.xaRetValErrorAccumSQL(callInfo, 0);
            callInfo.xaRetVal_ = 0;
            throw this.netCon.xares_.exceptionsOnXA;
        }
    }

    void writeRollback() throws SqlException {
        NetXAResource cfr_ignored_0 = this.netCon.xares_;
        this.netCon.xares_.callInfoArray_[this.netCon.xares_.conn_.currXACallInfoOffset_].xid_ = NetXAResource.nullXid;
        this.writeLocalXARollback_();
    }

    void readRollback() throws SqlException {
        NetXACallInfo callInfo = this.netCon.xares_.callInfoArray_[this.netCon.currXACallInfoOffset_];
        callInfo.xaRetVal_ = 0;
        this.readLocalXARollback_();
        if (callInfo.xaRetVal_ != 0) {
            callInfo.xaFunction_ = 6;
            this.netCon.xares_.xaRetValErrorAccumSQL(callInfo, 0);
            callInfo.xaRetVal_ = 0;
            throw this.netCon.xares_.exceptionsOnXA;
        }
        this.netCon.setXAState(0);
    }

    public NetConnection getNetConnection() {
        return this.netCon;
    }

    private void checkPlatformVersion() throws SqlException {
        int supportedVersion = 8;
        if (this.netCon.xaHostVersion_ >= supportedVersion) {
            return;
        }
        String platform = null;
        platform = "Linux, Unix, Windows";
        throw new SqlException(this.netCon.agent_.logWriter_, new ClientMessageId("XN012.S"), platform, supportedVersion, this.netCon.xaHostVersion_);
    }

    private NetConnection createNetConnection(LogWriter logWriter, String user, String password, BasicClientDataSource40 dataSource, int rmId, boolean isXAConn, ClientPooledConnection cpc) throws SqlException {
        return (NetConnection)ClientDriver.getFactory().newNetConnection(logWriter, user, password, dataSource, rmId, isXAConn, cpc);
    }
}

