/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class AIjdbcTest
extends BaseJDBCTestCase {
    public AIjdbcTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new CleanDatabaseTestSetup(TestConfiguration.defaultSuite(AIjdbcTest.class, false)){

            @Override
            protected void decorateSQL(Statement stmt) throws SQLException {
                stmt.execute("create table tab1 (x int, y int generated always as identity,z char(2))");
                stmt.execute("create view tab1_view (a,b) as select y,y+1 from tab1");
            }
        };
    }

    @Override
    protected void initializeConnection(Connection conn) throws SQLException {
        conn.setAutoCommit(false);
    }

    public void testSelect() throws SQLException {
        Statement s = this.createStatement();
        ResultSet rs = s.executeQuery("select x,z from tab1");
        ResultSetMetaData rsmd = rs.getMetaData();
        AIjdbcTest.assertFalse((String)"Column count doesn't match.", (rsmd.getColumnCount() != 2 ? 1 : 0) != 0);
        AIjdbcTest.assertFalse((String)"Column 1 is NOT ai.", (boolean)rsmd.isAutoIncrement(1));
        AIjdbcTest.assertFalse((String)"Column 2 is NOT ai.", (boolean)rsmd.isAutoIncrement(2));
        rs.close();
        rs = s.executeQuery("select y, x,z from tab1");
        rsmd = rs.getMetaData();
        AIjdbcTest.assertFalse((String)"Column count doesn't match.", (rsmd.getColumnCount() != 3 ? 1 : 0) != 0);
        AIjdbcTest.assertFalse((String)"Column 1 IS ai.", (!rsmd.isAutoIncrement(1) ? 1 : 0) != 0);
        AIjdbcTest.assertFalse((String)"Column 2 is NOT ai.", (boolean)rsmd.isAutoIncrement(2));
        AIjdbcTest.assertFalse((String)"Column 3 is NOT ai.", (boolean)rsmd.isAutoIncrement(3));
        rs.close();
        s.close();
    }

    public void testSelectView() throws SQLException {
        Statement s = this.createStatement();
        ResultSet rs = s.executeQuery("select * from tab1_view");
        ResultSetMetaData rsmd = rs.getMetaData();
        AIjdbcTest.assertFalse((String)"Column count doesn't match.", (rsmd.getColumnCount() != 2 ? 1 : 0) != 0);
        AIjdbcTest.assertFalse((String)"Column 1 IS ai.", (!rsmd.isAutoIncrement(1) ? 1 : 0) != 0);
        AIjdbcTest.assertFalse((String)"Column 1 is NOT ai.", (boolean)rsmd.isAutoIncrement(2));
        rs.close();
        s.close();
    }
}

