/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public final class NestedCommitTest
extends BaseJDBCTestCase {
    public NestedCommitTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(NestedCommitTest.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNestedCommit() throws Exception {
        Statement st = this.createStatement();
        st.getConnection().setHoldability(2);
        try {
            st.executeUpdate("CREATE PROCEDURE doConnCommit()        DYNAMIC RESULT SETS 0 LANGUAGE JAVA        EXTERNAL NAME 'org.apache.derbyTesting.functionTests.util.Triggers.doConnCommit'     CONTAINS SQL       PARAMETER STYLE JAVA");
            st.executeUpdate("CREATE PROCEDURE doConnRollback()        DYNAMIC RESULT SETS 0 LANGUAGE JAVA        EXTERNAL NAME 'org.apache.derbyTesting.functionTests.util.Triggers.doConnRollback'     CONTAINS SQL       PARAMETER STYLE JAVA");
            st.executeUpdate("CREATE PROCEDURE doConnStmt(IN TEXT CHAR(50))        DYNAMIC RESULT SETS 0 LANGUAGE JAVA        EXTERNAL NAME 'org.apache.derbyTesting.functionTests.util.Triggers.doConnStmt'     CONTAINS SQL       PARAMETER STYLE JAVA");
            st.executeUpdate("CREATE FUNCTION doConnCommitInt()        RETURNS INT EXTERNAL NAME 'org.apache.derbyTesting.functionTests.util.Triggers.doConnCommitInt'        LANGUAGE JAVA PARAMETER STYLE JAVA");
            st.executeUpdate("CREATE FUNCTION doConnStmtInt(TEXT CHAR(50))        RETURNS INT EXTERNAL NAME 'org.apache.derbyTesting.functionTests.util.Triggers.doConnStmtInt'        LANGUAGE JAVA PARAMETER STYLE JAVA");
            st.executeUpdate("create table x (x int)");
            st.executeUpdate("insert into x values 1,2,3,4");
            this.setAutoCommit(false);
            CallableStatement cSt = this.prepareCall("call doConnCommit()");
            NestedCommitTest.assertUpdateCount(cSt, 0);
            cSt = this.prepareCall("call doConnRollback()");
            NestedCommitTest.assertUpdateCount(cSt, 0);
            cSt = this.prepareCall("call doConnStmt('call doConnCommit()')");
            NestedCommitTest.assertUpdateCount(cSt, 0);
            cSt = this.prepareCall("call doConnStmt('call doConnRollback()')");
            NestedCommitTest.assertUpdateCount(cSt, 0);
            ResultSet rs = st.executeQuery("values doConnCommitInt()");
            NestedCommitTest.assertTrue((boolean)rs.next());
            try {
                rs.getString(1);
            }
            catch (SQLException e) {
                NestedCommitTest.assertSQLState("XCL16", e);
            }
            rs = st.executeQuery("values doConnStmtInt('values doConnCommitInt()')");
            JDBC.assertFullResultSet(rs, (Object[][])new String[][]{{"1"}}, true);
            NestedCommitTest.assertStatementError("38000", st, "insert into x select x+doConnCommitInt() from x");
            NestedCommitTest.assertStatementError("38000", st, "delete from x where x in (select x+doConnCommitInt() from x)");
            NestedCommitTest.assertStatementError("38000", st, "delete from x where x = doConnCommitInt()");
            NestedCommitTest.assertStatementError("38000", st, "update x set x = doConnCommitInt()");
            NestedCommitTest.assertStatementError("38000", st, "select doConnStmtInt('call doConnStmt(''call doConnCommit()'')') from x");
            cSt = this.prepareCall("call doConnStmt('set isolation serializable')");
            NestedCommitTest.assertUpdateCount(cSt, 0);
        }
        finally {
            this.dontThrow(st, "drop table x");
            this.dontThrow(st, "drop procedure doConnCommit");
            this.dontThrow(st, "drop procedure doConnRollback");
            this.dontThrow(st, "drop function doConnCommitInt");
            this.dontThrow(st, "drop procedure doConnStmt");
            this.dontThrow(st, "drop function doConnStmtInt");
            this.commit();
        }
    }

    private void dontThrow(Statement st, String stm) {
        try {
            st.executeUpdate(stm);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

