/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.util;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class BigDecimalHandler {
    public static int representation;
    public static final int STRING_REPRESENTATION = 1;
    public static final int BIGDECIMAL_REPRESENTATION = 2;
    private static final int[] bdConvertibleTypes;

    public static String getBigDecimalString(ResultSet rs, int columnIndex) throws SQLException {
        String bigDecimalString = null;
        switch (representation) {
            case 2: {
                if (rs.getBigDecimal(columnIndex) == null) break;
                bigDecimalString = rs.getBigDecimal(columnIndex).toString();
                break;
            }
            case 1: {
                bigDecimalString = rs.getString(columnIndex);
                int columnType = rs.getMetaData().getColumnType(columnIndex);
                if (bigDecimalString == null || BigDecimalHandler.canConvertToDecimal(columnType)) break;
                throw new SQLException("Invalid data conversion. Method not called.");
            }
            default: {
                new Exception("Failed: Invalid Big Decimal representation").printStackTrace();
            }
        }
        return bigDecimalString;
    }

    public static String getBigDecimalString(ResultSet rs, String columnName, int columnIndex) throws SQLException {
        String bigDecimalString = null;
        switch (representation) {
            case 2: {
                if (rs.getBigDecimal(columnName) == null) break;
                bigDecimalString = rs.getBigDecimal(columnName).toString();
                break;
            }
            case 1: {
                bigDecimalString = rs.getString(columnName);
                int columnType = rs.getMetaData().getColumnType(columnIndex);
                if (bigDecimalString == null || BigDecimalHandler.canConvertToDecimal(columnType)) break;
                throw new SQLException("Invalid data conversion. Method not called.");
            }
            default: {
                new Exception("Failed: Invalid Big Decimal representation").printStackTrace();
            }
        }
        return bigDecimalString;
    }

    public static String getObjectString(ResultSet rs, int columnIndex) throws SQLException {
        String objectString = null;
        switch (representation) {
            case 2: {
                if (rs.getObject(columnIndex) == null) break;
                objectString = rs.getObject(columnIndex).toString();
                break;
            }
            case 1: {
                int columnType = rs.getMetaData().getColumnType(columnIndex);
                if (columnType == 3) {
                    objectString = rs.getString(columnIndex);
                    break;
                }
                if (rs.getObject(columnIndex) == null) break;
                objectString = rs.getObject(columnIndex).toString();
                break;
            }
            default: {
                new Exception("Failed: Invalid Big Decimal representation").printStackTrace();
            }
        }
        return objectString;
    }

    public static String getObjectString(ResultSet rs, String columnName, int columnIndex) throws SQLException {
        String objectString = null;
        switch (representation) {
            case 2: {
                if (rs.getObject(columnName) == null) break;
                objectString = rs.getObject(columnName).toString();
                break;
            }
            case 1: {
                int columnType = rs.getMetaData().getColumnType(columnIndex);
                if (columnType == 3) {
                    objectString = rs.getString(columnName);
                    break;
                }
                if (rs.getObject(columnName) == null) break;
                objectString = rs.getObject(columnName).toString();
                break;
            }
            default: {
                new Exception("Failed: Invalid Big Decimal representation").printStackTrace();
            }
        }
        return objectString;
    }

    public static void updateBigDecimalString(ResultSet rs, int columnIndex, String bdString) throws SQLException {
        switch (representation) {
            case 2: {
                BigDecimal bd = bdString == null ? null : new BigDecimal(bdString);
                rs.updateBigDecimal(columnIndex, bd);
                break;
            }
            case 1: {
                rs.updateString(columnIndex, bdString);
                break;
            }
            default: {
                new Exception("Failed: Invalid Big Decimal representation").printStackTrace();
            }
        }
    }

    public static void updateBigDecimalString(ResultSet rs, String columnName, String bdString) throws SQLException {
        switch (representation) {
            case 2: {
                BigDecimal bd = bdString == null ? null : new BigDecimal(bdString);
                rs.updateBigDecimal(columnName, bd);
                break;
            }
            case 1: {
                rs.updateString(columnName, bdString);
                break;
            }
            default: {
                new Exception("Failed: Invalid Big Decimal representation").printStackTrace();
            }
        }
    }

    public static String getBigDecimalString(CallableStatement cs, int parameterIndex, int parameterType) throws SQLException {
        String bigDecimalString = null;
        switch (representation) {
            case 2: {
                if (cs.getBigDecimal(parameterIndex) == null) break;
                bigDecimalString = cs.getBigDecimal(parameterIndex).toString();
                break;
            }
            case 1: {
                bigDecimalString = cs.getString(parameterIndex);
                if (bigDecimalString == null || BigDecimalHandler.canConvertToDecimal(parameterType)) break;
                throw new SQLException("Invalid data conversion. Method not called.");
            }
            default: {
                new Exception("Failed: Invalid Big Decimal representation").printStackTrace();
            }
        }
        return bigDecimalString;
    }

    public static void setBigDecimalString(PreparedStatement ps, int parameterIndex, String bdString) throws SQLException {
        switch (representation) {
            case 2: {
                BigDecimal bd = bdString == null ? null : new BigDecimal(bdString);
                ps.setBigDecimal(parameterIndex, bd);
                break;
            }
            case 1: {
                ps.setString(parameterIndex, bdString);
                break;
            }
            default: {
                new Exception("Failed: Invalid Big Decimal representation").printStackTrace();
            }
        }
    }

    public static void setObjectString(PreparedStatement ps, int parameterIndex, String objectString) throws SQLException {
        switch (representation) {
            case 2: {
                BigDecimal bd = objectString == null ? null : new BigDecimal(objectString);
                ps.setObject(parameterIndex, bd);
                break;
            }
            case 1: {
                ps.setObject(parameterIndex, objectString);
                break;
            }
            default: {
                new Exception("Failed: Invalid Big Decimal representation").printStackTrace();
            }
        }
    }

    protected static boolean canConvertToDecimal(int type) throws SQLException {
        boolean canConvert = false;
        for (int bdType = 0; bdType < bdConvertibleTypes.length; ++bdType) {
            if (type != bdConvertibleTypes[bdType]) continue;
            canConvert = true;
            break;
        }
        return canConvert;
    }

    static {
        try {
            Class.forName("java.math.BigDecimal");
            representation = 2;
            Method getbd = ResultSet.class.getMethod("getBigDecimal", Integer.TYPE);
            representation = 2;
        }
        catch (ClassNotFoundException e) {
            representation = 1;
        }
        catch (NoSuchMethodException e) {
            representation = 1;
        }
        bdConvertibleTypes = new int[]{-6, 5, 4, -5, 7, 6, 8, 3, 2, -7, 1, 12, -1};
    }
}

