/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.jce;

import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.crypto.CipherProvider;
import org.apache.derby.impl.services.jce.JCECipherFactory;
import org.apache.derby.shared.common.sanity.SanityManager;

class JCECipherProvider
implements CipherProvider {
    private Cipher cipher;
    private int mode;
    private boolean ivUsed = true;
    private final IvParameterSpec ivspec;
    private final int encryptionBlockSize;
    private boolean sunjce;
    private SecretKey cryptixKey;

    JCECipherProvider(int mode, SecretKey secretKey, byte[] iv, String algorithm, String provider) throws StandardException {
        GeneralSecurityException t;
        this.ivspec = new IvParameterSpec(iv);
        try {
            block28: {
                if (provider == null) {
                    this.cipher = Cipher.getInstance(algorithm);
                    if ("SunJCE".equals(this.cipher.getProvider().getName())) {
                        this.sunjce = true;
                    }
                } else {
                    if (provider.equals("SunJCE")) {
                        this.sunjce = true;
                    } else if (provider.equals("BouncyCastleProvider")) {
                        provider = "BC";
                    }
                    this.cipher = Cipher.getInstance(algorithm, provider);
                }
                this.encryptionBlockSize = this.cipher.getBlockSize();
                this.mode = mode;
                try {
                    if (mode == 1) {
                        if (algorithm.indexOf("/ECB") > -1) {
                            this.cipher.init(1, secretKey);
                        } else {
                            this.cipher.init(1, (Key)secretKey, this.ivspec);
                        }
                        break block28;
                    }
                    if (mode == 2) {
                        if (algorithm.indexOf("/ECB") > -1) {
                            this.cipher.init(2, secretKey);
                        } else {
                            this.cipher.init(2, (Key)secretKey, this.ivspec);
                        }
                        break block28;
                    }
                    throw StandardException.newException("XBCX1.S", new Object[0]);
                }
                catch (InvalidKeyException ike) {
                    if (algorithm.startsWith("DES")) {
                        SecretKeyFactory skf = provider == null ? SecretKeyFactory.getInstance(secretKey.getAlgorithm()) : SecretKeyFactory.getInstance(secretKey.getAlgorithm(), provider);
                        secretKey = skf.translateKey(new SecretKeySpec(secretKey.getEncoded(), secretKey.getAlgorithm()));
                        if (mode == 1) {
                            if (algorithm.indexOf("/ECB") > -1) {
                                this.cipher.init(1, secretKey);
                            } else {
                                this.cipher.init(1, (Key)secretKey, this.ivspec);
                            }
                        } else if (mode == 2) {
                            if (algorithm.indexOf("/ECB") > -1) {
                                this.cipher.init(2, secretKey);
                            } else {
                                this.cipher.init(2, (Key)secretKey, this.ivspec);
                            }
                        }
                    }
                    throw StandardException.newException("XBCX0.S", ike, new Object[0]);
                }
            }
            this.cryptixKey = secretKey;
            if (this.cipher.getIV() == null) {
                this.ivUsed = false;
            }
            SanityManager.ASSERT(this.verifyIV(iv));
            return;
        }
        catch (InvalidKeyException ike) {
            t = ike;
        }
        catch (NoSuchAlgorithmException nsae) {
            throw StandardException.newException("XBCXC.S", algorithm, JCECipherFactory.providerErrorName(provider));
        }
        catch (NoSuchProviderException nspe) {
            throw StandardException.newException("XBCXG.S", JCECipherFactory.providerErrorName(provider));
        }
        catch (GeneralSecurityException gse) {
            t = gse;
        }
        throw StandardException.newException("XBCX0.S", t, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int encrypt(byte[] cleartext, int offset, int length, byte[] ciphertext, int outputOffset) throws StandardException {
        SanityManager.ASSERT(this.mode == 1, "calling encrypt on a decryption engine");
        SanityManager.ASSERT(cleartext != null, "encrypting null cleartext");
        SanityManager.ASSERT(offset >= 0, "offset < 0");
        SanityManager.ASSERT(length > 0, "length <= 0");
        SanityManager.ASSERT(offset + length <= cleartext.length, "offset+length > cleartext.length");
        SanityManager.ASSERT(length <= ciphertext.length - outputOffset, "provided ciphertext buffer insufficient");
        int retval = 0;
        try {
            JCECipherProvider jCECipherProvider = this;
            synchronized (jCECipherProvider) {
                if (!this.sunjce) {
                    try {
                        if (this.mode == 1) {
                            if (this.ivUsed) {
                                this.cipher.init(1, (Key)this.cryptixKey, this.ivspec);
                            } else {
                                this.cipher.init(1, this.cryptixKey);
                            }
                        } else if (this.mode == 2) {
                            if (this.ivUsed) {
                                this.cipher.init(2, (Key)this.cryptixKey, this.ivspec);
                            } else {
                                this.cipher.init(2, this.cryptixKey);
                            }
                        }
                    }
                    catch (InvalidKeyException ike) {
                        System.out.println("A " + ike);
                        throw StandardException.newException("XBCX0.S", ike, new Object[0]);
                    }
                }
                retval = this.cipher.doFinal(cleartext, offset, length, ciphertext, outputOffset);
            }
        }
        catch (IllegalStateException ise) {
            SanityManager.THROWASSERT(ise);
        }
        catch (GeneralSecurityException gse) {
            System.out.println("B " + gse);
            throw StandardException.newException("XBCX0.S", gse, new Object[0]);
        }
        SanityManager.ASSERT(retval == length, "ciphertext length != length");
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int decrypt(byte[] ciphertext, int offset, int length, byte[] cleartext, int outputOffset) throws StandardException {
        SanityManager.ASSERT(this.mode == 2, "calling decrypt on a encryption engine");
        SanityManager.ASSERT(ciphertext != null, "decrypting null ciphertext");
        SanityManager.ASSERT(offset >= 0, "offset < 0");
        SanityManager.ASSERT(length > 0, "length <= 0");
        SanityManager.ASSERT(offset + length <= ciphertext.length, "offset+length > ciphertext.length");
        SanityManager.ASSERT(length <= cleartext.length - outputOffset, "provided cleartexte buffer insufficient");
        int retval = 0;
        try {
            JCECipherProvider jCECipherProvider = this;
            synchronized (jCECipherProvider) {
                if (!this.sunjce) {
                    try {
                        if (this.mode == 1) {
                            if (this.ivUsed) {
                                this.cipher.init(1, (Key)this.cryptixKey, this.ivspec);
                            } else {
                                this.cipher.init(1, this.cryptixKey);
                            }
                        } else if (this.mode == 2) {
                            if (this.ivUsed) {
                                this.cipher.init(2, (Key)this.cryptixKey, this.ivspec);
                            } else {
                                this.cipher.init(2, this.cryptixKey);
                            }
                        }
                    }
                    catch (InvalidKeyException ike) {
                        System.out.println("C " + ike);
                        throw StandardException.newException("XBCX0.S", ike, new Object[0]);
                    }
                }
                retval = this.cipher.doFinal(ciphertext, offset, length, cleartext, outputOffset);
            }
        }
        catch (IllegalStateException ise) {
            SanityManager.THROWASSERT(ise);
        }
        catch (GeneralSecurityException gse) {
            System.out.println("D " + gse);
            throw StandardException.newException("XBCX0.S", gse, new Object[0]);
        }
        SanityManager.ASSERT(retval == length, "cleartext length != length");
        return retval;
    }

    boolean verifyIV(byte[] IV) {
        byte[] myIV = this.cipher.getIV();
        if (myIV == null) {
            return !this.ivUsed;
        }
        if (myIV.length != IV.length) {
            return false;
        }
        for (int i = 0; i < IV.length; ++i) {
            if (myIV[i] == IV[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getEncryptionBlockSize() {
        return this.encryptionBlockSize;
    }
}

