/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.catalog;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.Cacheable;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.impl.sql.catalog.DataDictionaryImpl;
import org.apache.derby.impl.sql.catalog.TDCacheable;
import org.apache.derby.impl.sql.catalog.TableKey;
import org.apache.derby.shared.common.sanity.SanityManager;

class NameTDCacheable
extends TDCacheable {
    private TableKey identity;

    NameTDCacheable(DataDictionaryImpl dd) {
        super(dd);
    }

    @Override
    public void clearIdentity() {
        this.identity = null;
        this.td = null;
    }

    @Override
    public Object getIdentity() {
        return this.identity;
    }

    @Override
    public Cacheable createIdentity(Object key, Object createParameter) {
        if (!(key instanceof TableKey)) {
            SanityManager.THROWASSERT("Key for a NameTDCacheElement is a " + key.getClass().getName() + " instead of a TableKey");
        }
        if (!(createParameter instanceof TableDescriptor)) {
            SanityManager.THROWASSERT("Create parameter for a NameTDCacheElement is a " + createParameter.getClass().getName() + "instead of a TableDescriptorImpl");
        }
        this.identity = (TableKey)key;
        this.td = (TableDescriptor)createParameter;
        if (this.td != null) {
            return this;
        }
        return null;
    }

    @Override
    public Cacheable setIdentity(Object key) throws StandardException {
        if (!(key instanceof TableKey)) {
            SanityManager.THROWASSERT("Key for a NameTDCacheElement is a " + key.getClass().getName() + " instead of a TableKey");
        }
        this.identity = (TableKey)key;
        this.td = this.dd.getUncachedTableDescriptor(this.identity);
        if (this.td != null) {
            this.dd.addTableDescriptorToOtherCache(this.td, this);
            return this;
        }
        return null;
    }
}

