/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.BitSet;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.OptimizablePredicateList;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.compile.RowOrdering;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.GroupByList;
import org.apache.derby.impl.sql.compile.NumericConstantNode;
import org.apache.derby.impl.sql.compile.OrderByColumn;
import org.apache.derby.impl.sql.compile.OrderByList;
import org.apache.derby.impl.sql.compile.OrderByNode;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.RowCountNode;
import org.apache.derby.impl.sql.compile.SetOperatorNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.sanity.SanityManager;

public class IntersectOrExceptNode
extends SetOperatorNode {
    private int opType;
    public static final int INTERSECT_OP = 1;
    public static final int EXCEPT_OP = 2;
    private boolean addNewNodesCalled;
    private int[] intermediateOrderByColumns;
    private int[] intermediateOrderByDirection;
    private boolean[] intermediateOrderByNullsLow;

    IntersectOrExceptNode(int opType, ResultSetNode leftResult, ResultSetNode rightResult, boolean all, Properties tableProperties, ContextManager cm) throws StandardException {
        super(leftResult, rightResult, all, tableProperties, cm);
        this.opType = opType;
    }

    private int getOpType() {
        return this.opType;
    }

    @Override
    ResultSetNode preprocess(int numTables, GroupByList gbl, FromList fromList) throws StandardException {
        this.intermediateOrderByColumns = new int[this.getResultColumns().size()];
        this.intermediateOrderByDirection = new int[this.intermediateOrderByColumns.length];
        this.intermediateOrderByNullsLow = new boolean[this.intermediateOrderByColumns.length];
        OrderByList obl = this.qec.getOrderByList(0);
        if (obl != null) {
            int i;
            BitSet colsOrdered = new BitSet(this.intermediateOrderByColumns.length);
            int orderByListSize = obl.size();
            int intermediateOrderByIdx = 0;
            for (i = 0; i < orderByListSize; ++i) {
                int columnIdx;
                if (colsOrdered.get(i)) continue;
                OrderByColumn orderByColumn = obl.getOrderByColumn(i);
                this.intermediateOrderByDirection[intermediateOrderByIdx] = orderByColumn.isAscending() ? 1 : -1;
                this.intermediateOrderByNullsLow[intermediateOrderByIdx] = orderByColumn.isNullsOrderedLow();
                this.intermediateOrderByColumns[intermediateOrderByIdx] = columnIdx = orderByColumn.getResultColumn().getColumnPosition() - 1;
                colsOrdered.set(columnIdx);
                ++intermediateOrderByIdx;
            }
            for (i = 0; i < this.intermediateOrderByColumns.length; ++i) {
                if (colsOrdered.get(i)) continue;
                this.intermediateOrderByDirection[intermediateOrderByIdx] = 1;
                this.intermediateOrderByNullsLow[intermediateOrderByIdx] = false;
                this.intermediateOrderByColumns[intermediateOrderByIdx] = i;
                ++intermediateOrderByIdx;
            }
            this.qec.setOrderByList(0, null);
        } else {
            for (int i = 0; i < this.intermediateOrderByColumns.length; ++i) {
                this.intermediateOrderByDirection[i] = 1;
                this.intermediateOrderByNullsLow[i] = false;
                this.intermediateOrderByColumns[i] = i;
            }
        }
        this.pushOrderingDown(this.leftResultSet);
        this.pushOrderingDown(this.rightResultSet);
        return super.preprocess(numTables, gbl, fromList);
    }

    private void pushOrderingDown(ResultSetNode rsn) throws StandardException {
        ContextManager cm = this.getContextManager();
        OrderByList orderByList = new OrderByList(null, cm);
        for (int i = 0; i < this.intermediateOrderByColumns.length; ++i) {
            OrderByColumn orderByColumn = new OrderByColumn(new NumericConstantNode(TypeId.getBuiltInTypeId(4), this.intermediateOrderByColumns[i] + 1, cm), cm);
            if (this.intermediateOrderByDirection[i] < 0) {
                orderByColumn.setDescending();
            }
            if (this.intermediateOrderByNullsLow[i]) {
                orderByColumn.setNullsOrderedLow();
            }
            orderByList.addOrderByColumn(orderByColumn);
        }
        orderByList.bindOrderByColumns(rsn);
        rsn.pushQueryExpressionSuffix();
        rsn.pushOrderByList(orderByList);
    }

    @Override
    public CostEstimate estimateCost(OptimizablePredicateList predList, ConglomerateDescriptor cd, CostEstimate outerCost, Optimizer optimizer, RowOrdering rowOrdering) throws StandardException {
        this.leftResultSet = this.optimizeSource(optimizer, this.leftResultSet, null, outerCost);
        this.rightResultSet = this.optimizeSource(optimizer, this.rightResultSet, null, outerCost);
        CostEstimate costEst = this.getCostEstimate(optimizer);
        CostEstimate leftCostEstimate = this.leftResultSet.getCostEstimate();
        CostEstimate rightCostEstimate = this.rightResultSet.getCostEstimate();
        costEst.setCost(leftCostEstimate.getEstimatedCost() + rightCostEstimate.getEstimatedCost(), this.getRowCountEstimate(leftCostEstimate.rowCount(), rightCostEstimate.rowCount()), this.getSingleScanRowCountEstimate(leftCostEstimate.singleScanRowCount(), rightCostEstimate.singleScanRowCount()));
        return costEst;
    }

    @Override
    public Optimizable modifyAccessPath(JBitSet outerTables) throws StandardException {
        Optimizable retOptimizable = super.modifyAccessPath(outerTables);
        if (this.addNewNodesCalled) {
            return retOptimizable;
        }
        return (Optimizable)((Object)this.addNewNodes());
    }

    @Override
    ResultSetNode modifyAccessPaths() throws StandardException {
        ResultSetNode retRSN = super.modifyAccessPaths();
        if (this.addNewNodesCalled) {
            return retRSN;
        }
        return this.addNewNodes();
    }

    private ResultSetNode addNewNodes() throws StandardException {
        if (this.addNewNodesCalled) {
            return this;
        }
        this.addNewNodesCalled = true;
        FromTable treeTop = this;
        for (int i = 0; i < this.qec.size(); ++i) {
            OrderByList obl = this.qec.getOrderByList(i);
            if (obl != null) {
                treeTop = new OrderByNode(treeTop, obl, this.tableProperties, this.getContextManager());
            }
            ValueNode offset = this.qec.getOffset(i);
            ValueNode fetchFirst = this.qec.getFetchFirst(i);
            if (offset == null && fetchFirst == null) continue;
            ResultColumnList newRcl = treeTop.getResultColumns().copyListAndObjects();
            newRcl.genVirtualColumnNodes(treeTop, treeTop.getResultColumns());
            treeTop = new RowCountNode(treeTop, newRcl, offset, fetchFirst, this.qec.getHasJDBCLimitClause()[i], this.getContextManager());
        }
        return treeTop;
    }

    @Override
    void generate(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        this.assignResultSetNumber();
        this.setCostEstimate(this.getFinalCostEstimate());
        acb.pushGetResultSetFactoryExpression(mb);
        this.getLeftResultSet().generate(acb, mb);
        this.getRightResultSet().generate(acb, mb);
        acb.pushThisAsActivation(mb);
        mb.push(this.getResultSetNumber());
        mb.push(this.getCostEstimate().getEstimatedRowCount());
        mb.push(this.getCostEstimate().getEstimatedCost());
        mb.push(this.getOpType());
        mb.push(this.all);
        mb.push(this.getCompilerContext().addSavedObject(this.intermediateOrderByColumns));
        mb.push(this.getCompilerContext().addSavedObject(this.intermediateOrderByDirection));
        mb.push(this.getCompilerContext().addSavedObject(this.intermediateOrderByNullsLow));
        mb.callMethod((short)185, null, "getSetOpResultSet", "org.apache.derby.iapi.sql.execute.NoPutResultSet", 11);
    }

    @Override
    CostEstimate getFinalCostEstimate() throws StandardException {
        if (this.getCandidateFinalCostEstimate() != null) {
            return this.getCandidateFinalCostEstimate();
        }
        CostEstimate leftCE = this.leftResultSet.getFinalCostEstimate();
        CostEstimate rightCE = this.rightResultSet.getFinalCostEstimate();
        this.setCandidateFinalCostEstimate(this.getNewCostEstimate());
        this.getCandidateFinalCostEstimate().setCost(leftCE.getEstimatedCost() + rightCE.getEstimatedCost(), this.getRowCountEstimate(leftCE.rowCount(), rightCE.rowCount()), this.getSingleScanRowCountEstimate(leftCE.singleScanRowCount(), rightCE.singleScanRowCount()));
        return this.getCandidateFinalCostEstimate();
    }

    @Override
    String getOperatorName() {
        switch (this.opType) {
            case 1: {
                return "INTERSECT";
            }
            case 2: {
                return "EXCEPT";
            }
        }
        SanityManager.THROWASSERT("Invalid intersectOrExcept opType: " + this.opType);
        return "?";
    }

    double getRowCountEstimate(double leftRowCount, double rightRowCount) {
        switch (this.opType) {
            case 1: {
                return Math.min(leftRowCount, rightRowCount) / 2.0;
            }
            case 2: {
                return (leftRowCount + Math.max(0.0, leftRowCount - rightRowCount)) / 2.0;
            }
        }
        SanityManager.THROWASSERT("Invalid intersectOrExcept opType: " + this.opType);
        return 1.0;
    }

    double getSingleScanRowCountEstimate(double leftSingleScanRowCount, double rightSingleScanRowCount) {
        return this.getRowCountEstimate(leftSingleScanRowCount, rightSingleScanRowCount);
    }
}

