/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.ArrayList;
import java.util.ListIterator;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.RowOrdering;
import org.apache.derby.impl.sql.compile.ColumnOrdering;
import org.apache.derby.shared.common.sanity.SanityManager;

class RowOrderingImpl
implements RowOrdering {
    private final ArrayList<ColumnOrdering> ordering = new ArrayList();
    ColumnOrdering columnsAlwaysOrdered;
    private final ArrayList<Optimizable> alwaysOrderedOptimizables = new ArrayList();
    ColumnOrdering currentColumnOrdering;
    private final ArrayList<Optimizable> unorderedOptimizables = new ArrayList();

    RowOrderingImpl() {
        this.columnsAlwaysOrdered = new ColumnOrdering(3);
    }

    @Override
    public boolean isColumnAlwaysOrdered(int tableNumber, int columnNumber) {
        return this.columnsAlwaysOrdered.contains(tableNumber, columnNumber);
    }

    @Override
    public boolean orderedOnColumn(int direction, int orderPosition, int tableNumber, int columnNumber) throws StandardException {
        if (this.alwaysOrdered(tableNumber)) {
            return true;
        }
        if (this.columnsAlwaysOrdered.contains(tableNumber, columnNumber)) {
            return true;
        }
        if (orderPosition >= this.ordering.size()) {
            return false;
        }
        ColumnOrdering co = this.ordering.get(orderPosition);
        return co.ordered(direction, tableNumber, columnNumber);
    }

    @Override
    public boolean orderedOnColumn(int direction, int tableNumber, int columnNumber) throws StandardException {
        if (this.alwaysOrdered(tableNumber)) {
            return true;
        }
        if (this.columnsAlwaysOrdered.contains(tableNumber, columnNumber)) {
            return true;
        }
        boolean ordered = false;
        for (int i = 0; i < this.ordering.size(); ++i) {
            ColumnOrdering co = this.ordering.get(i);
            boolean thisOrdered = co.ordered(direction, tableNumber, columnNumber);
            if (!thisOrdered) continue;
            ordered = true;
            break;
        }
        return ordered;
    }

    @Override
    public void addOrderedColumn(int direction, int tableNumber, int columnNumber) {
        ColumnOrdering currColOrder;
        if (!this.unorderedOptimizables.isEmpty()) {
            return;
        }
        if (this.ordering.isEmpty()) {
            currColOrder = new ColumnOrdering(direction);
            this.ordering.add(currColOrder);
        } else {
            currColOrder = this.ordering.get(this.ordering.size() - 1);
        }
        if (currColOrder.direction() != direction) {
            SanityManager.THROWASSERT("direction == " + direction + ", currentColumnOrdering.direction() == " + currColOrder.direction());
        }
        currColOrder.addColumn(tableNumber, columnNumber);
    }

    @Override
    public void nextOrderPosition(int direction) {
        if (!this.unorderedOptimizables.isEmpty()) {
            return;
        }
        this.currentColumnOrdering = new ColumnOrdering(direction);
        this.ordering.add(this.currentColumnOrdering);
    }

    @Override
    public void optimizableAlwaysOrdered(Optimizable optimizable) {
        int tableNumber;
        if (this.unorderedOptimizablesOtherThan(optimizable)) {
            return;
        }
        boolean hasTableNumber = optimizable.hasTableNumber();
        int n = tableNumber = hasTableNumber ? optimizable.getTableNumber() : 0;
        if ((this.ordering.isEmpty() || hasTableNumber && this.ordering.get(0).hasTable(tableNumber)) && hasTableNumber && !this.columnsAlwaysOrdered.hasAnyOtherTable(tableNumber)) {
            if (optimizable.hasTableNumber()) {
                this.removeOptimizable(optimizable.getTableNumber());
            }
            this.alwaysOrderedOptimizables.add(optimizable);
        }
    }

    @Override
    public void columnAlwaysOrdered(Optimizable optimizable, int columnNumber) {
        this.columnsAlwaysOrdered.addColumn(optimizable.getTableNumber(), columnNumber);
    }

    @Override
    public boolean alwaysOrdered(int tableNumber) {
        for (Optimizable optTable : this.alwaysOrderedOptimizables) {
            if (!optTable.hasTableNumber() || optTable.getTableNumber() != tableNumber) continue;
            return true;
        }
        return false;
    }

    @Override
    public void removeOptimizable(int tableNumber) {
        for (int i = this.ordering.size() - 1; i >= 0; --i) {
            ColumnOrdering ord = this.ordering.get(i);
            ord.removeColumns(tableNumber);
            if (!ord.empty()) continue;
            this.ordering.remove(i);
        }
        this.columnsAlwaysOrdered.removeColumns(tableNumber);
        this.removeOptimizable(tableNumber, this.unorderedOptimizables);
        this.removeOptimizable(tableNumber, this.alwaysOrderedOptimizables);
    }

    private void removeOptimizable(int tableNumber, ArrayList<Optimizable> list) {
        ListIterator<Optimizable> it = list.listIterator();
        while (it.hasNext()) {
            Optimizable optTable = it.next();
            if (!optTable.hasTableNumber() || optTable.getTableNumber() != tableNumber) continue;
            it.remove();
        }
    }

    @Override
    public void addUnorderedOptimizable(Optimizable optimizable) {
        this.unorderedOptimizables.add(optimizable);
    }

    @Override
    public void copy(RowOrdering copyTo) {
        int i;
        if (!(copyTo instanceof RowOrderingImpl)) {
            SanityManager.THROWASSERT("copyTo should be a RowOrderingImpl, is a " + copyTo.getClass().getName());
        }
        RowOrderingImpl dest = (RowOrderingImpl)copyTo;
        dest.ordering.clear();
        dest.currentColumnOrdering = null;
        dest.unorderedOptimizables.clear();
        for (i = 0; i < this.unorderedOptimizables.size(); ++i) {
            dest.unorderedOptimizables.add(this.unorderedOptimizables.get(i));
        }
        dest.alwaysOrderedOptimizables.clear();
        for (i = 0; i < this.alwaysOrderedOptimizables.size(); ++i) {
            dest.alwaysOrderedOptimizables.add(this.alwaysOrderedOptimizables.get(i));
        }
        for (i = 0; i < this.ordering.size(); ++i) {
            ColumnOrdering co = this.ordering.get(i);
            dest.ordering.add(co.cloneMe());
            if (co != this.currentColumnOrdering) continue;
            dest.rememberCurrentColumnOrdering(i);
        }
        dest.columnsAlwaysOrdered = null;
        if (this.columnsAlwaysOrdered != null) {
            dest.columnsAlwaysOrdered = this.columnsAlwaysOrdered.cloneMe();
        }
    }

    private void rememberCurrentColumnOrdering(int posn) {
        this.currentColumnOrdering = this.ordering.get(posn);
    }

    public String toString() {
        Optimizable opt;
        int i;
        String retval = null;
        retval = "Unordered optimizables: ";
        for (i = 0; i < this.unorderedOptimizables.size(); ++i) {
            opt = this.unorderedOptimizables.get(i);
            retval = opt.getBaseTableName() != null ? retval + opt.getBaseTableName() : retval + this.unorderedOptimizables.get(i).toString();
            retval = retval + " ";
        }
        retval = retval + "\n";
        retval = retval + "\nAlways ordered optimizables: ";
        for (i = 0; i < this.alwaysOrderedOptimizables.size(); ++i) {
            opt = this.alwaysOrderedOptimizables.get(i);
            retval = opt.getBaseTableName() != null ? retval + opt.getBaseTableName() : retval + this.alwaysOrderedOptimizables.get(i).toString();
            retval = retval + " ";
        }
        retval = retval + "\n";
        for (i = 0; i < this.ordering.size(); ++i) {
            retval = retval + " ColumnOrdering " + i + ": " + this.ordering.get(i);
        }
        return retval;
    }

    private boolean unorderedOptimizablesOtherThan(Optimizable optimizable) {
        for (int i = 0; i < this.unorderedOptimizables.size(); ++i) {
            Optimizable thisOpt = this.unorderedOptimizables.get(i);
            if (thisOpt == optimizable) continue;
            return true;
        }
        return false;
    }
}

