/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.sql.execute.NestedLoopJoinResultSet;

class NestedLoopLeftOuterJoinResultSet
extends NestedLoopJoinResultSet {
    protected GeneratedMethod emptyRowFun;
    private boolean wasRightOuterJoin;
    private boolean matchRight = false;
    private boolean returnedEmptyRight = false;
    private ExecRow rightEmptyRow = null;
    public int emptyRightRowsReturned = 0;

    @Override
    public ExecRow getNextRowCore() throws StandardException {
        if (this.isXplainOnlyMode()) {
            return null;
        }
        ExecRow result = null;
        boolean haveRow = false;
        boolean restrict = false;
        this.beginTime = this.getCurrentTimeMillis();
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S", "next");
        }
        if (this.returnedEmptyRight) {
            this.leftRow = this.leftResultSet.getNextRowCore();
            if (this.leftRow == null) {
                this.closeRight();
            } else {
                ++this.rowsSeenLeft;
                this.openRight();
            }
            this.returnedEmptyRight = false;
        }
        while (this.leftRow != null && !haveRow) {
            this.rightRow = this.rightResultSet.getNextRowCore();
            if (this.rightRow == null) {
                if (!this.matchRight) {
                    haveRow = true;
                    this.returnedEmptyRight = true;
                    if (this.rightEmptyRow == null) {
                        this.rightEmptyRow = (ExecRow)this.emptyRowFun.invoke(this.activation);
                    }
                    this.getMergedRow(this.leftRow, this.rightEmptyRow);
                    ++this.emptyRightRowsReturned;
                    continue;
                }
                this.matchRight = false;
                this.leftRow = this.leftResultSet.getNextRowCore();
                if (this.leftRow == null) {
                    this.closeRight();
                    continue;
                }
                ++this.rowsSeenLeft;
                this.openRight();
                continue;
            }
            ++this.rowsSeenRight;
            if (this.restriction != null) {
                DataValueDescriptor restrictBoolean = (DataValueDescriptor)this.restriction.invoke(this.activation);
                boolean bl = restrict = !restrictBoolean.isNull() && restrictBoolean.getBoolean();
                if (!restrict) {
                    ++this.rowsFiltered;
                    continue;
                }
            }
            this.matchRight = true;
            this.getMergedRow(this.leftRow, this.rightRow);
            haveRow = true;
        }
        if (haveRow) {
            result = this.mergedRow;
            this.setCurrentRow(this.mergedRow);
            ++this.rowsReturned;
        } else {
            this.clearCurrentRow();
        }
        this.nextTime += this.getElapsedMillis(this.beginTime);
        return result;
    }

    protected void getMergedRow(ExecRow leftRow, ExecRow rightRow) throws StandardException {
        DataValueDescriptor src_col;
        int rightNumCols;
        int leftNumCols;
        if (this.wasRightOuterJoin) {
            ExecRow tmp = leftRow;
            leftRow = rightRow;
            rightRow = tmp;
            leftNumCols = this.rightNumCols;
            rightNumCols = this.leftNumCols;
        } else {
            leftNumCols = this.leftNumCols;
            rightNumCols = this.rightNumCols;
        }
        if (this.mergedRow == null) {
            this.mergedRow = this.getExecutionFactory().getValueRow(leftNumCols + rightNumCols);
        }
        int colInCtr = 1;
        int colOutCtr = 1;
        while (colInCtr <= leftNumCols) {
            src_col = leftRow.getColumn(colInCtr);
            if (src_col != null && src_col.hasStream()) {
                src_col = src_col.cloneValue(false);
            }
            this.mergedRow.setColumn(colOutCtr, src_col);
            ++colInCtr;
            ++colOutCtr;
        }
        colInCtr = 1;
        while (colInCtr <= rightNumCols) {
            src_col = rightRow.getColumn(colInCtr);
            if (src_col != null && src_col.hasStream()) {
                src_col = src_col.cloneValue(false);
            }
            this.mergedRow.setColumn(colOutCtr, src_col);
            ++colInCtr;
            ++colOutCtr;
        }
    }

    @Override
    void clearScanState() {
        this.matchRight = false;
        this.returnedEmptyRight = false;
        this.rightEmptyRow = null;
        this.emptyRightRowsReturned = 0;
        super.clearScanState();
    }

    NestedLoopLeftOuterJoinResultSet(NoPutResultSet leftResultSet, int leftNumCols, NoPutResultSet rightResultSet, int rightNumCols, Activation activation, GeneratedMethod restriction, int resultSetNumber, GeneratedMethod emptyRowFun, boolean wasRightOuterJoin, boolean oneRowRightSide, boolean notExistsRightSide, double optimizerEstimatedRowCount, double optimizerEstimatedCost, String userSuppliedOptimizerOverrides) {
        super(leftResultSet, leftNumCols, rightResultSet, rightNumCols, activation, restriction, resultSetNumber, oneRowRightSide, notExistsRightSide, optimizerEstimatedRowCount, optimizerEstimatedCost, userSuppliedOptimizerOverrides);
        this.emptyRowFun = emptyRowFun;
        this.wasRightOuterJoin = wasRightOuterJoin;
    }
}

