/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.execute.ExecAggregator;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.NumberDataValue;
import org.apache.derby.impl.sql.execute.OrderableAggregator;

public class SumAggregator
extends OrderableAggregator {
    @Override
    protected void accumulate(DataValueDescriptor addend) throws StandardException {
        if (this.value == null) {
            this.value = addend.cloneValue(false);
        } else {
            NumberDataValue input = (NumberDataValue)addend;
            NumberDataValue nv = (NumberDataValue)this.value;
            this.value = nv.plus(input, nv, nv);
        }
    }

    @Override
    public ExecAggregator newAggregator() {
        return new SumAggregator();
    }

    @Override
    public int getTypeFormatId() {
        return 154;
    }

    @Override
    public String toString() {
        try {
            return "SumAggregator: " + this.value.getString();
        }
        catch (StandardException e) {
            return super.toString() + ":" + e.getMessage();
        }
    }
}

