/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.btree;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.store.access.BackingStoreHashtable;
import org.apache.derby.iapi.store.raw.Page;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.store.access.btree.BTreeRowPosition;
import org.apache.derby.impl.store.access.btree.BTreeScan;
import org.apache.derby.impl.store.access.btree.ControlRow;
import org.apache.derby.impl.store.access.btree.LeafControlRow;
import org.apache.derby.impl.store.access.btree.WaitError;
import org.apache.derby.shared.common.sanity.SanityManager;

public class BTreeMaxScan
extends BTreeScan {
    private boolean moveToLeftSibling() throws StandardException {
        try {
            this.positionAtPreviousPage();
            return true;
        }
        catch (WaitError we) {
            long left = this.scan_position.current_leaf.getleftSiblingPageNumber();
            if (BTreeMaxScan.isEmpty(this.scan_position.current_leaf.getPage())) {
                this.scan_position.current_leaf.release();
                this.scan_position.init();
            } else {
                this.scan_position.current_slot = 1;
                this.savePositionAndReleasePage();
            }
            Page leftPage = this.container.getPage(left);
            if (leftPage != null) {
                leftPage.unlatch();
                leftPage = null;
            }
            return false;
        }
    }

    @Override
    protected int fetchRows(BTreeRowPosition pos, DataValueDescriptor[][] row_array, RowLocation[] rowloc_array, BackingStoreHashtable hash_table, long max_rowcnt, int[] key_column_numbers) throws StandardException {
        throw StandardException.newException("XSCB3.S", new Object[0]);
    }

    @Override
    protected void positionAtStartPosition(BTreeRowPosition pos) throws StandardException {
        SanityManager.ASSERT(this.scan_state == 1);
        SanityManager.ASSERT(pos.current_rh == null);
        SanityManager.ASSERT(pos.current_positionKey == null);
        while (true) {
            ControlRow root = ControlRow.get(this, 1L);
            this.stat_numpages_visited += root.getLevel() + 1;
            if (this.init_startKeyValue != null) {
                throw StandardException.newException("XSCB3.S", new Object[0]);
            }
            pos.current_leaf = (LeafControlRow)root.searchRight(this);
            pos.current_slot = pos.current_leaf.page.recordCount();
            boolean exact = false;
            --pos.current_slot;
            boolean latch_released = !this.getLockingPolicy().lockScanRow(this, pos, this.init_lock_fetch_desc, pos.current_lock_template, pos.current_lock_row_loc, false, this.init_forUpdate, this.lock_operation);
            ++pos.current_slot;
            latch_released = BTreeMaxScan.test_errors(this, "BTreeMaxScan_positionAtStartPosition", pos, this.getLockingPolicy(), pos.current_leaf, latch_released);
            if (!latch_released) break;
            pos.init();
        }
        this.scan_state = 2;
        SanityManager.ASSERT(pos.current_leaf != null);
    }

    public boolean fetchMax(DataValueDescriptor[] fetch_row) throws StandardException {
        BTreeRowPosition pos = this.scan_position;
        int ret_row_count = 0;
        SanityManager.ASSERT(this.container != null, "BTreeMaxScan.fetchMax() called on a closed scan.");
        if (this.scan_state == 2) {
            if (!this.reposition(this.scan_position, true)) {
                SanityManager.THROWASSERT("can not fail with 2nd param true.");
            }
        } else if (this.scan_state == 1) {
            this.positionAtStartPosition(this.scan_position);
        } else {
            SanityManager.ASSERT(this.scan_state == 3);
            return false;
        }
        boolean max_found = false;
        block0: while (!max_found && pos.current_leaf != null) {
            if (pos.current_slot <= 1) {
                boolean latch_released = !this.moveToLeftSibling();
                if (!latch_released) continue;
                SanityManager.DEBUG("BTreeMaxScan.latchConflict", "Couldn't get latch nowait, will retry");
                if (pos.current_positionKey == null) {
                    SanityManager.DEBUG("BTreeMaxScan.latchConflict", "Restart scan from rightmost leaf");
                    this.scan_state = 1;
                    this.positionAtStartPosition(pos);
                    continue;
                }
                if (this.reposition(pos, false)) continue;
                SanityManager.DEBUG("BTreeMaxScan.latchConflict", "Saved position is gone");
                if (!this.reposition(pos, true)) {
                    SanityManager.THROWASSERT("Cannot fail with 2nd param true");
                }
                ++pos.current_slot;
                continue;
            }
            --pos.current_slot;
            while (pos.current_slot > 0) {
                ++this.stat_numrows_visited;
                RecordHandle rh = pos.current_leaf.page.fetchFromSlot(null, pos.current_slot, fetch_row, this.init_fetchDesc, true);
                boolean latch_released = !this.getLockingPolicy().lockScanRow(this, pos, this.init_lock_fetch_desc, pos.current_lock_template, pos.current_lock_row_loc, false, this.init_forUpdate, this.lock_operation);
                pos.current_rh = rh;
                if (latch_released && !this.reposition(pos, false)) {
                    if (!this.reposition(pos, true)) {
                        SanityManager.THROWASSERT("Cannot fail with 2nd param true");
                    }
                    ++pos.current_slot;
                    continue block0;
                }
                if (pos.current_leaf.page.isDeletedAtSlot(pos.current_slot)) {
                    ++this.stat_numdeleted_rows_visited;
                    pos.current_rh_qualified = false;
                } else {
                    pos.current_rh_qualified = !fetch_row[0].isNull();
                }
                if (pos.current_rh_qualified) {
                    ++ret_row_count;
                    ++this.stat_numrows_qualified;
                    pos.current_slot = -1;
                    max_found = true;
                    continue block0;
                }
                --pos.current_slot;
            }
        }
        if (pos.current_leaf != null) {
            pos.current_leaf.release();
            pos.current_leaf = null;
        }
        this.positionAtDoneScan(this.scan_position);
        return max_found;
    }
}

