/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.btree.index;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.raw.FetchDescriptor;
import org.apache.derby.iapi.store.raw.LockingPolicy;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.store.access.btree.BTree;
import org.apache.derby.impl.store.access.btree.BTreeLockingPolicy;
import org.apache.derby.impl.store.access.btree.BTreeRowPosition;
import org.apache.derby.impl.store.access.btree.ControlRow;
import org.apache.derby.impl.store.access.btree.LeafControlRow;
import org.apache.derby.impl.store.access.btree.OpenBTree;
import org.apache.derby.impl.store.access.btree.WaitError;
import org.apache.derby.impl.store.access.btree.index.B2I;
import org.apache.derby.impl.store.access.heap.HeapController;
import org.apache.derby.shared.common.sanity.SanityManager;

class B2IRowLocking3
implements BTreeLockingPolicy {
    protected ConglomerateController base_cc;
    protected OpenBTree open_btree;
    private Transaction rawtran;

    B2IRowLocking3(Transaction rawtran, int lock_level, LockingPolicy locking_policy, ConglomerateController base_cc, OpenBTree open_btree) {
        this.rawtran = rawtran;
        this.base_cc = base_cc;
        this.open_btree = open_btree;
    }

    private boolean lockPreviousToFirstKey(LeafControlRow current_leaf, LeafControlRow aux_leaf, int lock_operation, int lock_duration) throws StandardException {
        boolean ret_status = this.base_cc.lockRow(1L, 3, lock_operation, false, lock_duration);
        if (!ret_status) {
            current_leaf.release();
            current_leaf = null;
            if (aux_leaf != null) {
                aux_leaf.release();
                aux_leaf = null;
            }
            this.base_cc.lockRow(1L, 3, lock_operation, true, lock_duration);
        }
        return ret_status;
    }

    private boolean lockRowOnPage(LeafControlRow current_leaf, LeafControlRow aux_leaf, int current_slot, BTreeRowPosition position, FetchDescriptor lock_fetch_desc, DataValueDescriptor[] lock_template, RowLocation lock_row_loc, int lock_operation, int lock_duration) throws StandardException {
        SanityManager.ASSERT(current_leaf != null);
        if (current_slot <= 0 || current_slot >= current_leaf.getPage().recordCount()) {
            SanityManager.THROWASSERT("current_slot = " + current_slot + "; current_leaf.getPage().recordCount() = " + current_leaf.getPage().recordCount());
        }
        SanityManager.ASSERT(lock_template != null, "template is null");
        SanityManager.ASSERT(lock_row_loc == lock_template[lock_template.length - 1], "row_loc is not the object in last column of lock_template.");
        if (position != null) {
            SanityManager.ASSERT(current_leaf == position.current_leaf);
            SanityManager.ASSERT(current_slot == position.current_slot);
        }
        RecordHandle rec_handle = current_leaf.getPage().fetchFromSlot(null, current_slot, lock_template, lock_fetch_desc, true);
        boolean ret_status = this.base_cc.lockRow(lock_row_loc, lock_operation, false, lock_duration);
        if (!ret_status) {
            if (position != null) {
                position.saveMeAndReleasePage();
            } else if (current_leaf != null) {
                current_leaf.release();
                current_leaf = null;
            }
            if (aux_leaf != null) {
                aux_leaf.release();
                aux_leaf = null;
            }
            if ((((HeapController)this.base_cc).getOpenConglomerate().getOpenMode() & 0x8000) != 0) {
                throw StandardException.newException("40XL1", new Object[0]);
            }
            this.base_cc.lockRow(lock_row_loc, lock_operation, true, lock_duration);
        }
        return ret_status;
    }

    private boolean searchLeftAndLockPreviousKey(LeafControlRow current_leaf, FetchDescriptor lock_fetch_desc, DataValueDescriptor[] lock_template, RowLocation lock_row_loc, OpenBTree open_btree, int lock_operation, int lock_duration) throws StandardException {
        long previous_pageno;
        LeafControlRow prev_leaf;
        boolean latches_released = false;
        try {
            prev_leaf = (LeafControlRow)current_leaf.getLeftSibling(open_btree);
        }
        catch (WaitError e) {
            previous_pageno = current_leaf.getleftSiblingPageNumber();
            current_leaf.release();
            current_leaf = null;
            prev_leaf = (LeafControlRow)ControlRow.get(open_btree, previous_pageno);
            latches_released = true;
        }
        block4: while (true) {
            try {
                while (true) {
                    if (prev_leaf.getPage().recordCount() > 1) {
                        boolean ret_status = this.lockRowOnPage(prev_leaf, current_leaf, prev_leaf.getPage().recordCount() - 1, null, lock_fetch_desc, lock_template, lock_row_loc, lock_operation, lock_duration);
                        if (ret_status) break block4;
                        prev_leaf = null;
                        current_leaf = null;
                        latches_released = true;
                        break block4;
                    }
                    if (prev_leaf.isLeftmostLeaf()) {
                        boolean ret_status = this.lockPreviousToFirstKey(prev_leaf, current_leaf, lock_operation, lock_duration);
                        if (ret_status) break block4;
                        prev_leaf = null;
                        current_leaf = null;
                        latches_released = true;
                        break block4;
                    }
                    LeafControlRow prev_prev_leaf = (LeafControlRow)prev_leaf.getLeftSibling(open_btree);
                    prev_leaf.release();
                    prev_leaf = prev_prev_leaf;
                    prev_prev_leaf = null;
                }
            }
            catch (WaitError e) {
                previous_pageno = prev_leaf.getleftSiblingPageNumber();
                if (current_leaf != null) {
                    current_leaf.release();
                    current_leaf = null;
                }
                prev_leaf.release();
                prev_leaf = null;
                prev_leaf = (LeafControlRow)ControlRow.get(open_btree, previous_pageno);
                latches_released = true;
                continue;
            }
            break;
        }
        if (prev_leaf != null) {
            prev_leaf.release();
        }
        return !latches_released;
    }

    protected boolean _lockScanRow(OpenBTree open_btree, BTreeRowPosition pos, boolean request_row_lock, FetchDescriptor lock_fetch_desc, DataValueDescriptor[] lock_template, RowLocation lock_row_loc, boolean previous_key_lock, boolean forUpdate, int lock_operation) throws StandardException {
        boolean latch_released = false;
        if (request_row_lock) {
            if (pos.current_slot == 0) {
                latch_released = !this.lockNonScanPreviousRow(pos.current_leaf, 1, lock_fetch_desc, lock_template, lock_row_loc, open_btree, lock_operation, 2);
                latch_released = OpenBTree.test_errors(open_btree, "B2iRowLocking3_1_lockScanRow", null, this, pos.current_leaf, latch_released);
            } else {
                latch_released = !this.lockRowOnPage(pos.current_leaf, null, pos.current_slot, pos, lock_fetch_desc, lock_template, lock_row_loc, lock_operation, 2);
                latch_released = OpenBTree.test_errors(open_btree, "B2iRowLocking3_2_lockScanRow", pos, this, pos.current_leaf, latch_released);
            }
        }
        return !latch_released;
    }

    @Override
    public boolean lockScanCommittedDeletedRow(OpenBTree open_btree, LeafControlRow leaf, DataValueDescriptor[] template, FetchDescriptor lock_fetch_desc, int slot_no) throws StandardException {
        SanityManager.ASSERT(leaf != null);
        if (slot_no <= 0 || slot_no >= leaf.getPage().recordCount()) {
            SanityManager.THROWASSERT("slot_no = " + slot_no + "; leaf.getPage().recordCount() = " + leaf.getPage().recordCount());
        }
        SanityManager.ASSERT(template != null, "template is null");
        RowLocation row_loc = (RowLocation)template[((B2I)open_btree.getConglomerate()).rowLocationColumn];
        leaf.getPage().fetchFromSlot(null, slot_no, template, lock_fetch_desc, true);
        return this.base_cc.lockRow(row_loc, 1, false, 2);
    }

    @Override
    public boolean lockScanRow(OpenBTree open_btree, BTreeRowPosition pos, FetchDescriptor lock_fetch_desc, DataValueDescriptor[] lock_template, RowLocation lock_row_loc, boolean previous_key_lock, boolean forUpdate, int lock_operation) throws StandardException {
        return this._lockScanRow(open_btree, pos, true, lock_fetch_desc, lock_template, lock_row_loc, previous_key_lock, forUpdate, lock_operation);
    }

    @Override
    public void unlockScanRecordAfterRead(BTreeRowPosition pos, boolean forUpdate) throws StandardException {
    }

    @Override
    public boolean lockNonScanPreviousRow(LeafControlRow current_leaf, int current_slot, FetchDescriptor lock_fetch_desc, DataValueDescriptor[] lock_template, RowLocation lock_row_loc, OpenBTree open_btree, int lock_operation, int lock_duration) throws StandardException {
        boolean ret_status;
        if (current_slot > 1) {
            ret_status = this.lockRowOnPage(current_leaf, null, current_slot - 1, null, lock_fetch_desc, lock_template, lock_row_loc, lock_operation, lock_duration);
        } else {
            SanityManager.ASSERT(current_slot == 1);
            ret_status = current_leaf.isLeftmostLeaf() ? this.lockPreviousToFirstKey(current_leaf, null, lock_operation, lock_duration) : this.searchLeftAndLockPreviousKey(current_leaf, lock_fetch_desc, lock_template, lock_row_loc, open_btree, lock_operation, lock_duration);
        }
        return ret_status;
    }

    @Override
    public boolean lockNonScanRow(BTree btree, LeafControlRow current_leaf, LeafControlRow aux_leaf, DataValueDescriptor[] current_row, int lock_operation) throws StandardException {
        SanityManager.ASSERT(btree instanceof B2I);
        B2I b2i = (B2I)btree;
        boolean ret_status = this.base_cc.lockRow((RowLocation)current_row[b2i.rowLocationColumn], lock_operation, false, 2);
        if (!ret_status) {
            if (current_leaf != null) {
                current_leaf.release();
                current_leaf = null;
            }
            if (aux_leaf != null) {
                aux_leaf.release();
                aux_leaf = null;
            }
            this.base_cc.lockRow((RowLocation)current_row[b2i.rowLocationColumn], lock_operation, true, 2);
        }
        return ret_status;
    }

    @Override
    public boolean lockNonScanRowOnPage(LeafControlRow current_leaf, int current_slot, FetchDescriptor lock_fetch_desc, DataValueDescriptor[] lock_template, RowLocation lock_row_loc, int lock_operation) throws StandardException {
        return this.lockRowOnPage(current_leaf, null, current_slot, null, lock_fetch_desc, lock_template, lock_row_loc, lock_operation, 2);
    }
}

