/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.Externalizable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.io.CompressedNumber;
import org.apache.derby.iapi.services.io.DynamicByteArrayOutputStream;
import org.apache.derby.iapi.services.io.FormatIdInputStream;
import org.apache.derby.iapi.services.io.FormatIdOutputStream;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.io.LimitInputStream;
import org.apache.derby.iapi.services.io.Storable;
import org.apache.derby.iapi.services.io.StreamStorable;
import org.apache.derby.iapi.services.io.TypedFormat;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.store.access.AccessFactory;
import org.apache.derby.iapi.store.access.RowSource;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.store.raw.ContainerKey;
import org.apache.derby.iapi.store.raw.StreamContainerHandle;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.store.raw.data.BaseDataFileFactory;
import org.apache.derby.impl.store.raw.data.DecryptInputStream;
import org.apache.derby.impl.store.raw.data.MemByteHolder;
import org.apache.derby.impl.store.raw.data.StoredFieldHeader;
import org.apache.derby.impl.store.raw.data.StoredRecordHeader;
import org.apache.derby.io.StorageFile;
import org.apache.derby.shared.common.sanity.SanityManager;

class StreamFileContainer
implements TypedFormat,
PrivilegedExceptionAction<Object> {
    protected static int formatIdInteger = 290;
    protected static final int LARGE_SLOT_SIZE = 4;
    protected static final int MIN_BUFFER_SIZE = 1024;
    protected static final int FIELD_STATUS = StoredFieldHeader.setFixed(StoredFieldHeader.setInitial(), true);
    protected static final int FIELD_HEADER_SIZE = StoredFieldHeader.size(FIELD_STATUS, 0, 4);
    protected ContainerKey identity;
    private BaseDataFileFactory dataFactory;
    private int bufferSize;
    private StorageFile file;
    private OutputStream fileOut;
    private DynamicByteArrayOutputStream out;
    private FormatIdOutputStream logicalDataOut;
    private InputStream fileIn;
    private BufferedInputStream bufferedIn;
    private DecryptInputStream decryptIn;
    private LimitInputStream limitIn;
    private FormatIdInputStream logicalDataIn;
    private StoredRecordHeader recordHeader;
    private byte[] ciphertext;
    private byte[] zeroBytes;
    private static final int STORAGE_FILE_EXISTS_ACTION = 1;
    private static final int STORAGE_FILE_DELETE_ACTION = 2;
    private static final int STORAGE_FILE_MKDIRS_ACTION = 3;
    private static final int STORAGE_FILE_GET_OUTPUT_STREAM_ACTION = 4;
    private static final int STORAGE_FILE_GET_INPUT_STREAM_ACTION = 5;
    private int actionCode;
    private StorageFile actionStorageFile;

    StreamFileContainer(ContainerKey identity, BaseDataFileFactory dataFactory) {
        this.identity = identity;
        this.dataFactory = dataFactory;
    }

    StreamFileContainer(ContainerKey identity, BaseDataFileFactory dataFactory, Properties prop) throws StandardException {
        this.identity = identity;
        this.dataFactory = dataFactory;
        try {
            this.file = this.getFileName(identity, true, false);
            if (this.privExists(this.file)) {
                throw StandardException.newException("XSDF0.S", this.file);
            }
            this.getContainerProperties(prop);
        }
        catch (SecurityException se) {
            throw StandardException.newException("XSDF1.S", se, this.file);
        }
    }

    protected StreamFileContainer open(boolean forUpdate) throws StandardException {
        this.file = this.getFileName(this.identity, false, true);
        if (!this.privExists(this.file)) {
            return null;
        }
        try {
            if (!forUpdate) {
                this.fileIn = this.privGetInputStream(this.file);
                if (this.dataFactory.databaseEncrypted()) {
                    MemByteHolder byteHolder = new MemByteHolder(16384);
                    this.decryptIn = new DecryptInputStream(this.fileIn, byteHolder, this.dataFactory);
                    this.limitIn = new LimitInputStream(this.decryptIn);
                } else {
                    this.bufferedIn = new BufferedInputStream(this.fileIn, 16384);
                    this.limitIn = new LimitInputStream(this.bufferedIn);
                }
            } else {
                SanityManager.THROWASSERT("updating existing stream container not supported yet");
                return null;
            }
            this.logicalDataIn = new FormatIdInputStream(this.limitIn);
            this.recordHeader = new StoredRecordHeader();
            this.recordHeader.read(this.logicalDataIn);
        }
        catch (IOException ioe) {
            throw StandardException.newException("XSDF1.S", ioe, this.file);
        }
        return this;
    }

    protected void close() {
        try {
            if (this.fileIn != null) {
                this.fileIn.close();
                this.fileIn = null;
                if (this.dataFactory.databaseEncrypted()) {
                    this.decryptIn.close();
                    this.decryptIn = null;
                } else {
                    this.bufferedIn.close();
                    this.bufferedIn = null;
                }
                this.logicalDataIn.close();
                this.logicalDataIn = null;
            }
            if (this.fileOut != null) {
                this.fileOut.close();
                this.logicalDataOut.close();
                this.fileOut = null;
                this.logicalDataOut = null;
                this.out = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public int getTypeFormatId() {
        return 290;
    }

    public void getContainerProperties(Properties prop) throws StandardException {
        AccessFactory af = (AccessFactory)StreamFileContainer.getServiceModule(this.dataFactory, "org.apache.derby.iapi.store.access.AccessFactory");
        TransactionController tc = af == null ? null : af.getTransaction(StreamFileContainer.getContextService().getCurrentContextManager());
        this.bufferSize = PropertyUtil.getServiceInt(tc, prop, "derby.storage.streamFileBufferSize", 1024, Integer.MAX_VALUE, 16384);
    }

    public ContainerKey getIdentity() {
        return this.identity;
    }

    protected boolean use(StreamContainerHandle handle) throws StandardException {
        return true;
    }

    public void load(RowSource rowSource) throws StandardException {
        this.out = new DynamicByteArrayOutputStream(this.bufferSize);
        this.logicalDataOut = new FormatIdOutputStream(this.out);
        boolean encrypted = this.dataFactory.databaseEncrypted();
        if (encrypted) {
            if (this.zeroBytes == null) {
                this.zeroBytes = new byte[this.dataFactory.getEncryptionBlockSize() - 1];
            }
            this.out.write(this.zeroBytes, 0, this.dataFactory.getEncryptionBlockSize() - 1);
        }
        try {
            int validColumnsSize;
            this.fileOut = this.privGetOutputStream(this.file);
            FormatableBitSet validColumns = rowSource.getValidColumns();
            DataValueDescriptor[] row = rowSource.getNextRowFromRowSource();
            int numberFields = 0;
            if (validColumns != null) {
                for (int i = validColumns.getLength() - 1; i >= 0; --i) {
                    if (!validColumns.isSet(i)) continue;
                    numberFields = i + 1;
                    break;
                }
            } else {
                numberFields = row.length;
            }
            this.recordHeader = new StoredRecordHeader(0, numberFields);
            int rhLen = this.recordHeader.write(this.out);
            int n = validColumnsSize = validColumns == null ? 0 : validColumns.getLength();
            while (row != null) {
                int arrayPosition = -1;
                for (int i = 0; i < numberFields; ++i) {
                    DataValueDescriptor column;
                    if (validColumns == null) {
                        column = row[++arrayPosition];
                        this.writeColumn(column);
                    } else if (validColumnsSize > i && validColumns.isSet(i)) {
                        column = row[++arrayPosition];
                        this.writeColumn(column);
                    } else {
                        this.writeColumn(null);
                    }
                    if (this.out.getUsed() < this.bufferSize && this.bufferSize - this.out.getUsed() >= 1024) continue;
                    this.writeToFile();
                }
                row = rowSource.getNextRowFromRowSource();
            }
            if (encrypted) {
                if (this.out.getUsed() > this.dataFactory.getEncryptionBlockSize() - 1) {
                    this.writeToFile();
                }
            } else if (this.out.getUsed() > 0) {
                this.writeToFile();
            }
        }
        catch (IOException ioe) {
            throw StandardException.newException("XSDA4.S", ioe, new Object[0]);
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToFile() throws StandardException {
        block17: {
            try {
                if (this.dataFactory.databaseEncrypted()) {
                    int realLen = this.out.getUsed() - (this.dataFactory.getEncryptionBlockSize() - 1);
                    int tail = realLen % this.dataFactory.getEncryptionBlockSize();
                    int padding = tail == 0 ? 0 : this.dataFactory.getEncryptionBlockSize() - tail;
                    int startByte = tail == 0 ? this.dataFactory.getEncryptionBlockSize() - 1 : tail - 1;
                    int encryptedLen = realLen + padding;
                    if (realLen <= 0) {
                        return;
                    }
                    if (this.ciphertext == null) {
                        this.ciphertext = new byte[encryptedLen];
                    } else if (this.ciphertext.length < encryptedLen) {
                        this.ciphertext = new byte[encryptedLen];
                    }
                    this.dataFactory.encrypt(this.out.getByteArray(), startByte, encryptedLen, this.ciphertext, 0, false);
                    CompressedNumber.writeInt(this.fileOut, realLen);
                    this.dataFactory.writeInProgress();
                    try {
                        this.fileOut.write(this.ciphertext, 0, encryptedLen);
                    }
                    finally {
                        this.dataFactory.writeFinished();
                    }
                    this.out.reset();
                    if (this.dataFactory.databaseEncrypted()) {
                        if (this.zeroBytes == null) {
                            this.zeroBytes = new byte[this.dataFactory.getEncryptionBlockSize() - 1];
                        }
                        this.out.write(this.zeroBytes, 0, this.dataFactory.getEncryptionBlockSize() - 1);
                    }
                    break block17;
                }
                if (this.out.getUsed() == 0) {
                    return;
                }
                this.dataFactory.writeInProgress();
                try {
                    this.fileOut.write(this.out.getByteArray(), 0, this.out.getUsed());
                }
                finally {
                    this.dataFactory.writeFinished();
                }
                this.out.reset();
            }
            catch (IOException ioe) {
                throw StandardException.newException("XSDA4.S", ioe, new Object[0]);
            }
        }
    }

    private void writeColumn(Object column) throws StandardException, IOException {
        Storable sColumn;
        int fieldStatus = FIELD_STATUS;
        if (column == null) {
            fieldStatus = StoredFieldHeader.setNonexistent(fieldStatus);
            StoredFieldHeader.write(this.out, fieldStatus, 0, 4);
            return;
        }
        if (column instanceof Storable && (sColumn = (Storable)column).isNull()) {
            fieldStatus = StoredFieldHeader.setNull(fieldStatus, true);
            StoredFieldHeader.write(this.out, fieldStatus, 0, 4);
            return;
        }
        int beginPosition = this.out.getPosition();
        int fieldDataLength = 0;
        StoredFieldHeader.write(this.out, fieldStatus, fieldDataLength, 4);
        if (column instanceof StreamStorable && ((StreamStorable)column).returnStream() != null) {
            column = ((StreamStorable)column).returnStream();
        }
        if (column instanceof InputStream) {
            int lenRead;
            InputStream inColumn = (InputStream)column;
            int bufferLen = Math.min(Math.max(inColumn.available(), 64), 8192);
            byte[] bufData = new byte[bufferLen];
            while ((lenRead = inColumn.read(bufData)) != -1) {
                fieldDataLength += lenRead;
                this.out.write(bufData, 0, lenRead);
            }
        } else if (column instanceof Storable) {
            Storable sColumn2 = (Storable)column;
            sColumn2.writeExternal(this.logicalDataOut);
            fieldDataLength = this.out.getPosition() - beginPosition - FIELD_HEADER_SIZE;
        } else {
            this.logicalDataOut.writeObject(column);
            fieldDataLength = this.out.getPosition() - beginPosition - FIELD_HEADER_SIZE;
        }
        int endPosition = this.out.getPosition();
        this.out.setPosition(beginPosition);
        StoredFieldHeader.write(this.out, fieldStatus, fieldDataLength, 4);
        if (!StoredFieldHeader.isNull(fieldStatus)) {
            this.out.setPosition(endPosition);
        }
    }

    public boolean fetchNext(Object[] row) throws StandardException {
        boolean inUserCode = false;
        int columnId = 0;
        try {
            int numberFields = this.recordHeader.getNumberFields();
            int arrayPosition = 0;
            for (columnId = 0; columnId < numberFields && arrayPosition < row.length; ++columnId) {
                this.limitIn.clearLimit();
                int fieldStatus = StoredFieldHeader.readStatus(this.logicalDataIn);
                int fieldDataLength = StoredFieldHeader.readFieldDataLength(this.logicalDataIn, fieldStatus, 4);
                this.limitIn.setLimit(fieldDataLength);
                if (StoredFieldHeader.isExtensible(fieldStatus)) {
                    SanityManager.THROWASSERT("extensible fields not supported yet.  columnId = " + columnId);
                }
                SanityManager.ASSERT(!StoredFieldHeader.isOverflow(fieldStatus), "overflow field is not supported yet");
                Object column = row[arrayPosition];
                if (StoredFieldHeader.isNullable(fieldStatus)) {
                    if (column == null) {
                        throw StandardException.newException("XSDA6.S", Integer.toString(columnId));
                    }
                    if (!(column instanceof Storable)) {
                        throw StandardException.newException("XSDA6.S", column.getClass().getName());
                    }
                    Storable sColumn = (Storable)column;
                    if (StoredFieldHeader.isNull(fieldStatus)) {
                        sColumn.restoreToNull();
                        ++arrayPosition;
                        continue;
                    }
                    inUserCode = true;
                    sColumn.readExternal(this.logicalDataIn);
                    inUserCode = false;
                    ++arrayPosition;
                    continue;
                }
                if (StoredFieldHeader.isNull(fieldStatus)) {
                    throw StandardException.newException("XSDA6.S", Integer.toString(columnId));
                }
                Object neColumn = row[arrayPosition];
                if (neColumn instanceof Externalizable) {
                    Externalizable exColumn = (Externalizable)neColumn;
                    inUserCode = true;
                    exColumn.readExternal(this.logicalDataIn);
                    inUserCode = false;
                    ++arrayPosition;
                    continue;
                }
                neColumn = null;
                inUserCode = true;
                row[arrayPosition] = this.logicalDataIn.readObject();
                inUserCode = false;
                ++arrayPosition;
            }
        }
        catch (IOException ioe) {
            if (inUserCode) {
                if (ioe instanceof EOFException) {
                    throw StandardException.newException("XSDA7.S", ioe, this.logicalDataIn.getErrorInfo());
                }
                throw StandardException.newException("XSDA8.S", ioe, this.logicalDataIn.getErrorInfo());
            }
            if (ioe instanceof InvalidClassException) {
                throw StandardException.newException("XSDA8.S", ioe, this.logicalDataIn.getErrorInfo());
            }
            if (ioe instanceof EOFException && columnId == 0) {
                this.close();
                return false;
            }
            throw this.dataFactory.markCorrupt(StandardException.newException("XSDB9.D", ioe, this.identity));
        }
        catch (ClassNotFoundException cnfe) {
            SanityManager.ASSERT(inUserCode);
            throw StandardException.newException("XSDA9.S", cnfe, this.logicalDataIn.getErrorInfo());
        }
        catch (LinkageError le) {
            if (inUserCode) {
                throw StandardException.newException("XSDA8.S", le, this.logicalDataIn.getErrorInfo());
            }
            throw le;
        }
        return true;
    }

    public boolean removeContainer() throws StandardException {
        this.close();
        if (this.privExists(this.file)) {
            return this.privDelete(this.file);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StorageFile getFileName(ContainerKey identity, boolean forCreate, boolean errorOK) throws StandardException {
        if (identity.getSegmentId() == -1L) {
            return this.dataFactory.storageFactory.newStorageFile(this.dataFactory.storageFactory.getTempDir(), "T" + identity.getContainerId() + ".tmp");
        }
        SanityManager.THROWASSERT("cannot create stream container in non-temp segments yet.");
        StorageFile container = this.dataFactory.getContainerPath(identity, false);
        if (!this.privExists(container)) {
            if (!forCreate) {
                return null;
            }
            StorageFile directory = container.getParentDir();
            if (!this.privExists(directory)) {
                BaseDataFileFactory baseDataFileFactory = this.dataFactory;
                synchronized (baseDataFileFactory) {
                    if (!this.privExists(directory)) {
                        boolean created = false;
                        IOException ex = null;
                        try {
                            created = this.privMkdirs(directory);
                        }
                        catch (IOException ioe) {
                            ex = ioe;
                        }
                        if (!created) {
                            if (errorOK) {
                                return null;
                            }
                            throw StandardException.newException("XSDF3.S", ex, directory);
                        }
                    }
                }
            }
        }
        return container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean privExists(StorageFile file) {
        this.actionCode = 1;
        this.actionStorageFile = file;
        try {
            Object ret = AccessController.doPrivileged(this);
            boolean bl = (Boolean)ret;
            return bl;
        }
        catch (PrivilegedActionException pae) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.actionStorageFile = null;
        }
    }

    private synchronized boolean privMkdirs(StorageFile file) throws IOException {
        this.actionCode = 3;
        this.actionStorageFile = file;
        try {
            Object ret = AccessController.doPrivileged(this);
            boolean bl = (Boolean)ret;
            return bl;
        }
        catch (PrivilegedActionException pae) {
            throw (IOException)pae.getCause();
        }
        finally {
            this.actionStorageFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean privDelete(StorageFile file) {
        this.actionCode = 2;
        this.actionStorageFile = file;
        try {
            Object ret = AccessController.doPrivileged(this);
            boolean bl = (Boolean)ret;
            return bl;
        }
        catch (PrivilegedActionException pae) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.actionStorageFile = null;
        }
    }

    private synchronized OutputStream privGetOutputStream(StorageFile file) throws FileNotFoundException {
        this.actionCode = 4;
        this.actionStorageFile = file;
        try {
            OutputStream outputStream = (OutputStream)AccessController.doPrivileged(this);
            return outputStream;
        }
        catch (PrivilegedActionException pae) {
            throw (FileNotFoundException)pae.getException();
        }
        finally {
            this.actionStorageFile = null;
        }
    }

    private synchronized InputStream privGetInputStream(StorageFile file) throws FileNotFoundException {
        this.actionCode = 5;
        this.actionStorageFile = file;
        try {
            InputStream inputStream = (InputStream)AccessController.doPrivileged(this);
            return inputStream;
        }
        catch (PrivilegedActionException pae) {
            throw (FileNotFoundException)pae.getException();
        }
        finally {
            this.actionStorageFile = null;
        }
    }

    @Override
    public Object run() throws IOException {
        switch (this.actionCode) {
            case 1: {
                return this.actionStorageFile.exists();
            }
            case 2: {
                return this.actionStorageFile.delete();
            }
            case 3: {
                boolean created = this.actionStorageFile.mkdirs();
                this.actionStorageFile.limitAccessToOwner();
                return created;
            }
            case 4: {
                return this.actionStorageFile.getOutputStream();
            }
            case 5: {
                return this.actionStorageFile.getInputStream();
            }
        }
        return null;
    }

    private static ContextService getContextService() {
        return AccessController.doPrivileged(new PrivilegedAction<ContextService>(){

            @Override
            public ContextService run() {
                return ContextService.getFactory();
            }
        });
    }

    private static Object getServiceModule(final Object serviceModule, final String factoryInterface) {
        return AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return Monitor.getServiceModule(serviceModule, factoryInterface);
            }
        });
    }
}

