/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.replication.slave;

import java.util.NoSuchElementException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

class ReplicationLogScan {
    private byte[] logToScan;
    private int currentPosition;
    private long currentInstant;
    private int currentDataOffset;
    private byte[] currentData;
    private boolean hasInfo;
    private boolean isLogSwitch;

    protected ReplicationLogScan() {
    }

    protected void init(byte[] logToScan) {
        this.logToScan = logToScan;
        this.currentPosition = 0;
        this.currentInstant = -1L;
        this.currentData = null;
        this.isLogSwitch = false;
        this.hasInfo = false;
    }

    protected boolean next() throws StandardException {
        SanityManager.ASSERT(this.logToScan.length >= this.currentPosition, "Outside log byte[] boundary");
        if (this.currentPosition == this.logToScan.length) {
            this.hasInfo = false;
            return this.hasInfo;
        }
        try {
            int currentLength = this.retrieveInt();
            if (currentLength == 0) {
                this.isLogSwitch = true;
                this.hasInfo = true;
            } else {
                this.currentInstant = this.retrieveLong();
                this.currentData = new byte[currentLength];
                this.retrieveBytes(this.currentData, currentLength);
                this.retrieveInt();
                this.isLogSwitch = false;
                this.hasInfo = true;
            }
        }
        catch (StandardException se) {
            this.hasInfo = false;
            throw se;
        }
        return this.hasInfo;
    }

    protected long getInstant() throws NoSuchElementException {
        if (!this.hasInfo) {
            throw new NoSuchElementException();
        }
        if (this.isLogSwitch) {
            SanityManager.THROWASSERT("Log switch log records have no instant");
            return -1L;
        }
        return this.currentInstant;
    }

    protected int getDataLength() throws NoSuchElementException {
        if (!this.hasInfo) {
            throw new NoSuchElementException();
        }
        if (this.isLogSwitch) {
            SanityManager.THROWASSERT("Log switch log records have no length");
            return -1;
        }
        return this.currentData.length;
    }

    protected byte[] getData() throws NoSuchElementException {
        if (!this.hasInfo) {
            throw new NoSuchElementException();
        }
        if (this.isLogSwitch) {
            SanityManager.THROWASSERT("Log switch log records have no data");
            return null;
        }
        return this.currentData;
    }

    protected boolean hasValidInformation() {
        return this.hasInfo;
    }

    protected boolean isLogRecord() throws NoSuchElementException {
        if (!this.hasInfo) {
            throw new NoSuchElementException();
        }
        return !this.isLogSwitch;
    }

    protected boolean isLogFileSwitch() throws NoSuchElementException {
        if (!this.hasInfo) {
            throw new NoSuchElementException();
        }
        return this.isLogSwitch;
    }

    private void retrieveBytes(byte[] readInto, int length) throws StandardException {
        SanityManager.ASSERT(this.logToScan.length >= this.currentPosition + length, "Trying to read more bytes than there are in this logToScan");
        SanityManager.ASSERT(readInto.length == length, "readInto does not have a size of " + length + ", but a size of " + readInto.length);
        try {
            System.arraycopy(this.logToScan, this.currentPosition, readInto, 0, length);
            this.currentPosition += length;
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            throw StandardException.newException("XRE01", aioobe, new Object[0]);
        }
    }

    private int retrieveInt() throws StandardException {
        SanityManager.ASSERT(this.logToScan.length >= this.currentPosition + 4, "Trying to read more bytes than there are in this logToScan");
        try {
            int i = (this.logToScan[this.currentPosition++] << 24) + ((this.logToScan[this.currentPosition++] & 0xFF) << 16) + ((this.logToScan[this.currentPosition++] & 0xFF) << 8) + (this.logToScan[this.currentPosition++] & 0xFF);
            return i;
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            throw StandardException.newException("XRE01", aioobe, new Object[0]);
        }
    }

    private long retrieveLong() throws StandardException {
        SanityManager.ASSERT(this.logToScan.length >= this.currentPosition + 8, "Trying to read more bytes than there are in this logToScan");
        try {
            long l = ((long)this.logToScan[this.currentPosition++] << 56) + (((long)this.logToScan[this.currentPosition++] & 0xFFL) << 48) + (((long)this.logToScan[this.currentPosition++] & 0xFFL) << 40) + (((long)this.logToScan[this.currentPosition++] & 0xFFL) << 32) + (((long)this.logToScan[this.currentPosition++] & 0xFFL) << 24) + (long)((this.logToScan[this.currentPosition++] & 0xFF) << 16) + (long)((this.logToScan[this.currentPosition++] & 0xFF) << 8) + (long)(this.logToScan[this.currentPosition++] & 0xFF);
            return l;
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            throw StandardException.newException("XRE01", aioobe, new Object[0]);
        }
    }
}

