/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.jdbc;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;
import org.apache.derby.iapi.jdbc.EngineConnection;
import org.apache.derby.iapi.jdbc.ResourceAdapter;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.jdbc.BasicEmbeddedDataSource40;
import org.apache.derby.jdbc.EmbedPooledConnection;
import org.apache.derby.jdbc.EmbedXAResource;
import org.apache.derby.jdbc.XAStatementControl;

class EmbedXAConnection
extends EmbedPooledConnection
implements XAConnection {
    private EmbedXAResource xaRes;

    EmbedXAConnection(BasicEmbeddedDataSource40 ds, ResourceAdapter ra, String u, String p, boolean requestPassword) throws SQLException {
        super(ds, u, p, requestPassword);
        this.xaRes = new EmbedXAResource(this, ra);
    }

    @Override
    public boolean isInGlobalTransaction() {
        return this.isGlobal();
    }

    private boolean isGlobal() {
        return this.xaRes.getCurrentXid() != null;
    }

    @Override
    public final synchronized XAResource getXAResource() throws SQLException {
        this.checkActive();
        return this.xaRes;
    }

    @Override
    public void checkAutoCommit(boolean autoCommit) throws SQLException {
        if (autoCommit && this.isGlobal()) {
            throw Util.generateCsSQLException("XJ056.S", new Object[0]);
        }
        super.checkAutoCommit(autoCommit);
    }

    @Override
    public int checkHoldCursors(int holdability, boolean downgrade) throws SQLException {
        if (holdability == 1 && this.isGlobal()) {
            if (!downgrade) {
                throw Util.generateCsSQLException("XJ05C.S", new Object[0]);
            }
            holdability = 2;
        }
        return super.checkHoldCursors(holdability, downgrade);
    }

    @Override
    public void checkSavepoint() throws SQLException {
        if (this.isGlobal()) {
            throw Util.generateCsSQLException("XJ058.S", new Object[0]);
        }
        super.checkSavepoint();
    }

    @Override
    public void checkRollback() throws SQLException {
        if (this.isGlobal()) {
            throw Util.generateCsSQLException("XJ058.S", new Object[0]);
        }
        super.checkRollback();
    }

    @Override
    public void checkCommit() throws SQLException {
        if (this.isGlobal()) {
            throw Util.generateCsSQLException("XJ057.S", new Object[0]);
        }
        super.checkCommit();
    }

    @Override
    public void checkClose() throws SQLException {
        if (!this.isGlobal()) {
            super.checkClose();
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        Connection handle;
        if (!this.isGlobal()) {
            handle = super.getConnection();
        } else {
            if (this.currentConnectionHandle != null) {
                throw Util.generateCsSQLException("XJ059.S", new Object[0]);
            }
            handle = this.getNewCurrentConnectionHandle();
        }
        this.currentConnectionHandle.syncState();
        return handle;
    }

    @Override
    public Statement wrapStatement(Statement s) throws SQLException {
        XAStatementControl sc = new XAStatementControl(this, s);
        return sc.applicationStatement;
    }

    @Override
    public PreparedStatement wrapStatement(PreparedStatement ps, String sql, Object generatedKeys) throws SQLException {
        ps = super.wrapStatement(ps, sql, generatedKeys);
        XAStatementControl sc = new XAStatementControl(this, ps, sql, generatedKeys);
        return (PreparedStatement)((Object)sc.applicationStatement);
    }

    @Override
    public CallableStatement wrapStatement(CallableStatement cs, String sql) throws SQLException {
        cs = super.wrapStatement(cs, sql);
        XAStatementControl sc = new XAStatementControl(this, cs, sql);
        return (CallableStatement)((Object)sc.applicationStatement);
    }

    @Override
    public EngineConnection getRealConnection() throws SQLException {
        EngineConnection rc = super.getRealConnection();
        if (rc != null) {
            return rc;
        }
        this.openRealConnection();
        this.currentConnectionHandle.setState(true);
        return this.realConnection;
    }
}

