/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen.font.table;

import java.io.ByteArrayInputStream;
import java.util.Vector;
import org.apache.batik.svggen.font.table.GlyfCompositeComp;
import org.apache.batik.svggen.font.table.GlyfDescript;
import org.apache.batik.svggen.font.table.GlyfTable;

public class GlyfCompositeDescript
extends GlyfDescript {
    private Vector components = new Vector();

    public GlyfCompositeDescript(GlyfTable glyfTable, ByteArrayInputStream byteArrayInputStream) {
        super(glyfTable, (short)-1, byteArrayInputStream);
        GlyfCompositeComp glyfCompositeComp;
        int n = 0;
        int n2 = 0;
        do {
            glyfCompositeComp = new GlyfCompositeComp(n, n2, byteArrayInputStream);
            this.components.addElement(glyfCompositeComp);
            GlyfDescript glyfDescript = glyfTable.getDescription(glyfCompositeComp.getGlyphIndex());
            if (glyfDescript == null) continue;
            n += glyfDescript.getPointCount();
            n2 += glyfDescript.getContourCount();
        } while ((glyfCompositeComp.getFlags() & 0x20) != 0);
        if ((glyfCompositeComp.getFlags() & 0x100) != 0) {
            this.readInstructions(byteArrayInputStream, byteArrayInputStream.read() << 8 | byteArrayInputStream.read());
        }
    }

    public int getEndPtOfContours(int n) {
        GlyfCompositeComp glyfCompositeComp = this.getCompositeCompEndPt(n);
        if (glyfCompositeComp != null) {
            GlyfDescript glyfDescript = this.parentTable.getDescription(glyfCompositeComp.getGlyphIndex());
            return glyfDescript.getEndPtOfContours(n - glyfCompositeComp.getFirstContour()) + glyfCompositeComp.getFirstIndex();
        }
        return 0;
    }

    public byte getFlags(int n) {
        GlyfCompositeComp glyfCompositeComp = this.getCompositeComp(n);
        if (glyfCompositeComp != null) {
            GlyfDescript glyfDescript = this.parentTable.getDescription(glyfCompositeComp.getGlyphIndex());
            return glyfDescript.getFlags(n - glyfCompositeComp.getFirstIndex());
        }
        return 0;
    }

    public short getXCoordinate(int n) {
        GlyfCompositeComp glyfCompositeComp = this.getCompositeComp(n);
        if (glyfCompositeComp != null) {
            GlyfDescript glyfDescript = this.parentTable.getDescription(glyfCompositeComp.getGlyphIndex());
            int n2 = n - glyfCompositeComp.getFirstIndex();
            short s = glyfDescript.getXCoordinate(n2);
            short s2 = glyfDescript.getYCoordinate(n2);
            short s3 = (short)glyfCompositeComp.scaleX(s, s2);
            s3 = (short)(s3 + glyfCompositeComp.getXTranslate());
            return s3;
        }
        return 0;
    }

    public short getYCoordinate(int n) {
        GlyfCompositeComp glyfCompositeComp = this.getCompositeComp(n);
        if (glyfCompositeComp != null) {
            GlyfDescript glyfDescript = this.parentTable.getDescription(glyfCompositeComp.getGlyphIndex());
            int n2 = n - glyfCompositeComp.getFirstIndex();
            short s = glyfDescript.getXCoordinate(n2);
            short s2 = glyfDescript.getYCoordinate(n2);
            short s3 = (short)glyfCompositeComp.scaleY(s, s2);
            s3 = (short)(s3 + glyfCompositeComp.getYTranslate());
            return s3;
        }
        return 0;
    }

    public boolean isComposite() {
        return true;
    }

    public int getPointCount() {
        GlyfCompositeComp glyfCompositeComp = (GlyfCompositeComp)this.components.elementAt(this.components.size() - 1);
        return glyfCompositeComp.getFirstIndex() + this.parentTable.getDescription(glyfCompositeComp.getGlyphIndex()).getPointCount();
    }

    public int getContourCount() {
        GlyfCompositeComp glyfCompositeComp = (GlyfCompositeComp)this.components.elementAt(this.components.size() - 1);
        return glyfCompositeComp.getFirstContour() + this.parentTable.getDescription(glyfCompositeComp.getGlyphIndex()).getContourCount();
    }

    public int getComponentIndex(int n) {
        return ((GlyfCompositeComp)this.components.elementAt(n)).getFirstIndex();
    }

    public int getComponentCount() {
        return this.components.size();
    }

    protected GlyfCompositeComp getCompositeComp(int n) {
        int n2 = 0;
        while (n2 < this.components.size()) {
            GlyfCompositeComp glyfCompositeComp = (GlyfCompositeComp)this.components.elementAt(n2);
            GlyfDescript glyfDescript = this.parentTable.getDescription(glyfCompositeComp.getGlyphIndex());
            if (glyfCompositeComp.getFirstIndex() <= n && n < glyfCompositeComp.getFirstIndex() + glyfDescript.getPointCount()) {
                return glyfCompositeComp;
            }
            ++n2;
        }
        return null;
    }

    protected GlyfCompositeComp getCompositeCompEndPt(int n) {
        int n2 = 0;
        while (n2 < this.components.size()) {
            GlyfCompositeComp glyfCompositeComp = (GlyfCompositeComp)this.components.elementAt(n2);
            GlyfDescript glyfDescript = this.parentTable.getDescription(glyfCompositeComp.getGlyphIndex());
            if (glyfCompositeComp.getFirstContour() <= n && n < glyfCompositeComp.getFirstContour() + glyfDescript.getContourCount()) {
                return glyfCompositeComp;
            }
            ++n2;
        }
        return null;
    }
}

