/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.afp.modca;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.fop.render.afp.modca.AbstractNamedAFPObject;
import org.apache.fop.render.afp.modca.ImageDataDescriptor;
import org.apache.fop.render.afp.modca.ObjectAreaDescriptor;
import org.apache.fop.render.afp.modca.ObjectAreaPosition;

public final class ObjectEnvironmentGroup
extends AbstractNamedAFPObject {
    private static final String DEFAULT_NAME = "OEG00001";
    private ObjectAreaDescriptor _objectAreaDescriptor = null;
    private ObjectAreaPosition _objectAreaPosition = null;
    private ImageDataDescriptor _imageDataDescriptor = null;

    public ObjectEnvironmentGroup() {
        this(DEFAULT_NAME);
    }

    public ObjectEnvironmentGroup(String name) {
        super(name);
    }

    public void setObjectArea(int x, int y, int width, int height, int rotation) {
        this._objectAreaDescriptor = new ObjectAreaDescriptor(width, height);
        this._objectAreaPosition = new ObjectAreaPosition(x, y, rotation);
    }

    public void setImageData(int xresol, int yresol, int width, int height) {
        this._imageDataDescriptor = new ImageDataDescriptor(xresol, yresol, width, height);
    }

    public void writeDataStream(OutputStream os) throws IOException {
        this.writeStart(os);
        this._objectAreaDescriptor.writeDataStream(os);
        this._objectAreaPosition.writeDataStream(os);
        if (this._imageDataDescriptor != null) {
            this._imageDataDescriptor.writeDataStream(os);
        }
        this.writeEnd(os);
    }

    private void writeStart(OutputStream os) throws IOException {
        byte[] data = new byte[]{90, 0, 16, -45, -88, -57, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        for (int i = 0; i < this._nameBytes.length; ++i) {
            data[9 + i] = this._nameBytes[i];
        }
        os.write(data);
    }

    private void writeEnd(OutputStream os) throws IOException {
        byte[] data = new byte[17];
        data[0] = 90;
        data[1] = 0;
        data[2] = 16;
        data[3] = -45;
        data[4] = -87;
        data[5] = -57;
        data[6] = 0;
        data[7] = 0;
        data[8] = 0;
        for (int i = 0; i < this._nameBytes.length; ++i) {
            data[9 + i] = this._nameBytes[i];
        }
        os.write(data);
    }
}

