/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class RoutineSecurityTest
extends BaseJDBCTestCase {
    public RoutineSecurityTest(String string) {
        super(string);
    }

    public static Test suite() {
        Test test = TestConfiguration.embeddedSuite(RoutineSecurityTest.class);
        return new CleanDatabaseTestSetup(test){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                statement.executeUpdate("CREATE FUNCTION GET_SYS_PROP(PROPERTY_KEY VARCHAR(60)) RETURNS VARCHAR(255) EXTERNAL NAME 'java.lang.System.getProperty' LANGUAGE JAVA PARAMETER STYLE JAVA");
                statement.executeUpdate("CREATE PROCEDURE DENIAL_OF_SERVICE(RC INT) EXTERNAL NAME 'java.lang.System.exit' LANGUAGE JAVA PARAMETER STYLE JAVA");
                statement.executeUpdate("CREATE PROCEDURE FORCEGC() EXTERNAL NAME 'java.lang.System.gc' LANGUAGE JAVA PARAMETER STYLE JAVA");
            }
        };
    }

    public void testGetSystemProperty() throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("VALUES GET_SYS_PROP(?)");
        String[] stringArray = new String[]{"derby.system.home", "user.home", "java.class.path", "java.home", "derbyRoutineSecurityTest.no", "derbyTesting.fred"};
        for (int i = 0; i < stringArray.length; ++i) {
            preparedStatement.setString(1, stringArray[i]);
            try {
                ResultSet resultSet = preparedStatement.executeQuery();
                resultSet.next();
                RoutineSecurityTest.fail((String)("Succeeded reading " + stringArray[i] + resultSet.getString(1)));
                continue;
            }
            catch (SQLException sQLException) {
                this.assertSecurityException(sQLException);
            }
        }
        String[] stringArray2 = new String[]{"java.version", "java.specification.name", "derbyRoutineSecurityTest.yes"};
        for (int i = 0; i < stringArray2.length; ++i) {
            preparedStatement.setString(1, stringArray2[i]);
            ResultSet resultSet = preparedStatement.executeQuery();
            resultSet.next();
            resultSet.getString(1);
            resultSet.close();
        }
        preparedStatement.close();
    }

    public void testSystemExit() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("CALL DENIAL_OF_SERVICE(?)");
        callableStatement.setInt(1, -1);
        try {
            callableStatement.executeUpdate();
            RoutineSecurityTest.fail((String)"Tough to get here since exit would have been called.");
        }
        catch (SQLException sQLException) {
            this.assertSecurityException(sQLException);
        }
        callableStatement.setInt(1, 0);
        try {
            callableStatement.executeUpdate();
            RoutineSecurityTest.fail((String)"Tough to get here since exit would have been called.");
        }
        catch (SQLException sQLException) {
            this.assertSecurityException(sQLException);
        }
        callableStatement.close();
    }

    public void testSystemGC() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("CALL FORCEGC()");
        callableStatement.executeUpdate();
        callableStatement.close();
    }

    public void testInternalClass() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("CREATE FUNCTION HACK_DERBY(PROPERTY_KEY VARCHAR(60)) RETURNS VARCHAR(60) EXTERNAL NAME 'org.apache.derby.catalog.SystemProcedures.SYSCS_GET_DATABASE_PROPERTY' LANGUAGE JAVA PARAMETER STYLE JAVA");
        statement.executeUpdate("CREATE PROCEDURE HACK_DERBY_2() EXTERNAL NAME 'org.apache.derby.catalog.SystemProcedures.SYSCS_UNFREEZE_DATABASE' LANGUAGE JAVA PARAMETER STYLE JAVA");
        statement.executeUpdate("CREATE PROCEDURE HACK_DERBY_3() EXTERNAL NAME 'org.apache.derby.any.clazz.method' LANGUAGE JAVA PARAMETER STYLE JAVA");
        statement.close();
        this.assertCompileError("42X51", "VALUES HACK_DERBY(?)");
        this.assertCompileError("42X51", "CALL HACK_DERBY_2()");
        this.assertCompileError("42X51", "CALL HACK_DERBY_3()");
    }

    private void assertSecurityException(SQLException sQLException) {
        RoutineSecurityTest.assertSQLState("38000", sQLException);
        sQLException = sQLException.getNextException();
        RoutineSecurityTest.assertNotNull((Object)sQLException);
        RoutineSecurityTest.assertSQLState("XJ001", sQLException);
    }
}

