/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.engine;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class LockInterruptTest
extends BaseJDBCTestCase {
    private static final String INTERRUPTED = "08000";
    private static final int LOCK_TIMEOUT = 60;
    private static final int DEADLOCK_TIMEOUT = 30;

    public LockInterruptTest(String string) {
        super(string);
    }

    public static Test suite() {
        Object object = TestConfiguration.embeddedSuite(LockInterruptTest.class);
        object = DatabasePropertyTestSetup.setLockTimeouts(object, 30, 60);
        Properties properties = new Properties();
        properties.put("derby.stream.error.extendedDiagSeverityLevel", "50000");
        object = new SystemPropertyTestSetup((Test)object, properties, true);
        return new CleanDatabaseTestSetup((Test)object);
    }

    public void testInterruptLockWaiter() throws Exception {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.executeUpdate("create table derby4711(x int)");
        this.commit();
        statement.executeUpdate("lock table derby4711 in share mode");
        Waiter waiter = new Waiter();
        waiter.start();
        Thread.sleep(2000L);
        Waiter waiter2 = new Waiter();
        waiter2.start();
        Thread.sleep(2000L);
        waiter.interrupt();
        Thread.sleep(1000L);
        this.commit();
        waiter.join();
        waiter2.join();
        Throwable throwable = waiter.throwable;
        LockInterruptTest.assertNotNull((String)"First thread should fail because of interrupt", (Object)throwable);
        if (!(throwable instanceof SQLException)) {
            LockInterruptTest.fail("Unexpected exception from first thread", throwable);
        }
        LockInterruptTest.assertSQLState(INTERRUPTED, (SQLException)throwable);
        if (LockInterruptTest.hasInterruptibleIO()) {
            LockInterruptTest.println("Skipping assert for t1.InterruptFlagSetOnThrow due  to interruptible IO.");
            LockInterruptTest.println("This is default on Solaris/Sun Java <= 1.6, use -XX:-UseVMInterruptibleIO if available.");
        } else {
            LockInterruptTest.assertTrue((boolean)waiter.InterruptFlagSetOnThrow);
        }
        Throwable throwable2 = waiter2.throwable;
        if (throwable2 != null) {
            LockInterruptTest.fail("Unexpected exception from second thread", throwable2);
        }
        if (waiter2.elapsedTime >= 30000L) {
            LockInterruptTest.fail((String)("Second thread needed " + waiter2.elapsedTime + " ms to complete. Probably stuck waiting for a lock."));
        }
        JDBC.assertSingleValueResultSet(statement.executeQuery("select * from derby4711"), "1");
    }

    private class Waiter
    extends Thread {
        private final Connection c;
        private final PreparedStatement ps;
        private Throwable throwable;
        private boolean InterruptFlagSetOnThrow;
        private long elapsedTime;

        private Waiter() throws SQLException {
            this.c = LockInterruptTest.this.openDefaultConnection();
            this.ps = this.c.prepareStatement("insert into derby4711 values 1");
        }

        @Override
        public void run() {
            try {
                this.runWaiter();
            }
            catch (Throwable throwable) {
                this.throwable = throwable;
                this.InterruptFlagSetOnThrow = Waiter.interrupted();
            }
        }

        private void runWaiter() throws SQLException {
            long l = System.currentTimeMillis();
            try {
                this.ps.executeUpdate();
            }
            finally {
                this.ps.close();
                this.c.close();
            }
            this.elapsedTime = System.currentTimeMillis() - l;
        }
    }
}

