/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.TestConfiguration;

public class UniqueConstraintSetNullTest
extends BaseJDBCTestCase {
    public UniqueConstraintSetNullTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("UniqueConstraintSetNullTest");
        baseTestSuite.addTest(TestConfiguration.embeddedSuite(UniqueConstraintSetNullTest.class));
        return baseTestSuite;
    }

    protected void setUp() throws Exception {
        Statement statement = this.createStatement();
        statement.executeUpdate("create table constraintest (val1 varchar (20) not null, val2 varchar (20))");
    }

    @Override
    protected void tearDown() throws Exception {
        this.dropTable("constraintest");
        this.commit();
        super.tearDown();
    }

    public void testUpdateNullablity() throws Exception {
        Statement statement = this.createStatement();
        statement.executeUpdate("alter table constraintest add constraint u_con unique (val1)");
        PreparedStatement preparedStatement = this.prepareStatement("insert into constraintest (val1) values (?)");
        preparedStatement.setString(1, "name1");
        preparedStatement.executeUpdate();
        try {
            preparedStatement.setString(1, "name1");
            preparedStatement.execute();
            UniqueConstraintSetNullTest.fail((String)"duplicate key in unique constraint!!!");
        }
        catch (SQLException sQLException) {
            UniqueConstraintSetNullTest.assertSQLState("duplicate key in unique constraint", "23505", sQLException);
        }
        try {
            preparedStatement.setNull(1, 12);
            preparedStatement.executeUpdate();
            UniqueConstraintSetNullTest.fail((String)"null value in not null field!!");
        }
        catch (SQLException sQLException) {
            UniqueConstraintSetNullTest.assertSQLState("null value in non null field", "23502", sQLException);
        }
        statement.executeUpdate("alter table constraintest alter column val1 null");
        preparedStatement.setNull(1, 12);
        preparedStatement.executeUpdate();
        preparedStatement.setNull(1, 12);
        preparedStatement.executeUpdate();
        try {
            preparedStatement.setString(1, "name1");
            preparedStatement.execute();
            UniqueConstraintSetNullTest.fail((String)"duplicate key in unique constraint!!!");
        }
        catch (SQLException sQLException) {
            UniqueConstraintSetNullTest.assertSQLState("duplicate key in unique constraint", "23505", sQLException);
        }
        statement.executeUpdate("delete from constraintest where val1 is null");
        statement.executeUpdate("alter table constraintest alter column val1 not null");
        try {
            preparedStatement.setString(1, "name1");
            preparedStatement.execute();
            UniqueConstraintSetNullTest.fail((String)"duplicate key in unique constraint!!!");
        }
        catch (SQLException sQLException) {
            UniqueConstraintSetNullTest.assertSQLState("duplicate key in unique constraint", "23505", sQLException);
        }
        try {
            preparedStatement.setNull(1, 12);
            preparedStatement.executeUpdate();
            UniqueConstraintSetNullTest.fail((String)"null value in not null field!!");
        }
        catch (SQLException sQLException) {
            UniqueConstraintSetNullTest.assertSQLState("null value in non null field", "23502", sQLException);
        }
    }
}

