/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.sql.Connection;
import java.sql.PreparedStatement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.TestConfiguration;

public class Derby5234Test
extends BaseJDBCTestCase {
    private static final long ITERATIONS = 12500L;
    private static final long MAX_KEY_PER_FIRST_EXTENT = 10217L;
    private static final int VARCHAR_LENGTH = 2000;
    private static final String SEED = "0123456789";

    public Derby5234Test(String string) {
        super(string);
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(Derby5234Test.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.goodStatement(this.getConnection(), "create table t5234( a bigint, b varchar( 2000 ) )");
    }

    @Override
    protected void tearDown() throws Exception {
        this.goodStatement(this.getConnection(), "drop table t5234");
        super.tearDown();
    }

    public void test_01_basic() throws Exception {
        this.vetBasic(12500L);
    }

    private void vetBasic(long l) throws Exception {
        Connection connection = this.getConnection();
        boolean bl = connection.getAutoCommit();
        connection.setAutoCommit(false);
        this.insertRows(connection, l);
        this.deleteRows(connection);
        this.compressTable(connection);
        this.insertRows(connection, l);
        connection.setAutoCommit(bl);
    }

    private void insertRows(Connection connection, long l) throws Exception {
        PreparedStatement preparedStatement = this.chattyPrepare(connection, "insert into t5234( a, b ) values ( ?, ? )");
        String string = this.makeVarcharValue();
        long l2 = 0L;
        for (long i = 0L; i < l; ++i) {
            if (i * 10L / l > l2) {
                connection.commit();
                ++l2;
            }
            preparedStatement.setLong(1, i);
            preparedStatement.setString(2, string);
            preparedStatement.executeUpdate();
        }
        connection.commit();
    }

    private String makeVarcharValue() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 2000 / SEED.length();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(SEED);
        }
        return stringBuffer.toString();
    }

    private void deleteRows(Connection connection) throws Exception {
        this.goodStatement(connection, "delete from t5234");
        connection.commit();
    }

    private void compressTable(Connection connection) throws Exception {
        this.goodStatement(connection, "call syscs_util.syscs_inplace_compress_table( 'APP', 'T5234', 0, 0, 1 )");
        connection.commit();
    }

    public void test_02_maxOK() throws Exception {
        this.vetBasic(10217L);
    }

    public void test_03_triggeringEdge() throws Exception {
        this.vetBasic(10218L);
    }
}

