/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import junit.framework.AssertionFailedError;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.execute.RunTimeStatistics;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.tools.ij;
import org.apache.derbyTesting.functionTests.util.TestNullOutputStream;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public abstract class BaseJDBCTestCase
extends BaseTestCase {
    private static final boolean ORDERED = true;
    private static final boolean UNORDERED = false;
    private Connection conn;
    private List<Statement> statements;
    private List<Connection> connections;

    public BaseJDBCTestCase(String string) {
        super(string);
    }

    public Connection getConnection() throws SQLException {
        if (this.conn != null) {
            if (!this.conn.isClosed()) {
                return this.conn;
            }
            this.conn = null;
        }
        this.conn = this.openDefaultConnection();
        return this.conn;
    }

    protected void initializeConnection(Connection connection) throws SQLException {
    }

    public Statement createStatement() throws SQLException {
        Statement statement = this.getConnection().createStatement();
        this.addStatement(statement);
        return statement;
    }

    private void addStatement(Statement statement) {
        if (this.statements == null) {
            this.statements = new ArrayList<Statement>();
        }
        this.statements.add(statement);
    }

    private void addConnection(Connection connection) {
        if (this.connections == null) {
            this.connections = new ArrayList<Connection>();
        }
        this.connections.add(connection);
    }

    public void closeStatement(Statement statement) throws SQLException {
        statement.close();
        if (this.statements != null) {
            this.statements.remove(statement);
        }
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        Statement statement = this.getConnection().createStatement(n, n2);
        this.addStatement(statement);
        return statement;
    }

    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        return this.getConnection().createStatement(n, n2, n3);
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        PreparedStatement preparedStatement = this.getConnection().prepareStatement(string);
        this.addStatement(preparedStatement);
        return preparedStatement;
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        PreparedStatement preparedStatement = this.getConnection().prepareStatement(string, n, n2);
        this.addStatement(preparedStatement);
        return preparedStatement;
    }

    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        PreparedStatement preparedStatement = this.getConnection().prepareStatement(string, n, n2, n3);
        this.addStatement(preparedStatement);
        return preparedStatement;
    }

    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        PreparedStatement preparedStatement = this.getConnection().prepareStatement(string, n);
        this.addStatement(preparedStatement);
        return preparedStatement;
    }

    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        PreparedStatement preparedStatement = this.getConnection().prepareStatement(string, nArray);
        this.addStatement(preparedStatement);
        return preparedStatement;
    }

    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        PreparedStatement preparedStatement = this.getConnection().prepareStatement(string, stringArray);
        this.addStatement(preparedStatement);
        return preparedStatement;
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        CallableStatement callableStatement = this.getConnection().prepareCall(string);
        this.addStatement(callableStatement);
        return callableStatement;
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        CallableStatement callableStatement = this.getConnection().prepareCall(string, n, n2);
        this.addStatement(callableStatement);
        return callableStatement;
    }

    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        CallableStatement callableStatement = this.getConnection().prepareCall(string, n, n2, n3);
        this.addStatement(callableStatement);
        return callableStatement;
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        this.getConnection().setAutoCommit(bl);
    }

    public void commit() throws SQLException {
        this.getConnection().commit();
    }

    public void rollback() throws SQLException {
        this.getConnection().rollback();
    }

    protected void runBareOverridable() throws Throwable {
        super.runBare();
    }

    @Override
    public final void runBare() throws Throwable {
        this.runBareOverridable();
        BaseJDBCTestCase.assertNull((String)"Connection should be null by now. Missing call to super.tearDown()?", (Object)this.conn);
    }

    protected void tearDown() throws Exception {
        if (this.statements != null) {
            for (Statement autoCloseable : this.statements) {
                autoCloseable.close();
            }
            this.statements = null;
        }
        if (this.connections != null) {
            for (Connection connection : this.connections) {
                JDBC.cleanup(connection);
            }
            this.connections = null;
        }
        this.conn = null;
    }

    public Connection openDefaultConnection() throws SQLException {
        Connection connection = this.getTestConfiguration().openDefaultConnection();
        this.addConnection(connection);
        this.initializeConnection(connection);
        return connection;
    }

    public Connection openDefaultConnection(TestConfiguration testConfiguration) throws SQLException {
        Connection connection = testConfiguration.openDefaultConnection();
        this.addConnection(connection);
        this.initializeConnection(connection);
        return connection;
    }

    public Connection openDefaultConnection(String string, String string2) throws SQLException {
        Connection connection = this.getTestConfiguration().openDefaultConnection(string, string2);
        this.addConnection(connection);
        this.initializeConnection(connection);
        return connection;
    }

    public Connection openUserConnection(String string) throws SQLException {
        return this.openDefaultConnection(string, this.getTestConfiguration().getPassword(string));
    }

    public Connection openConnection(String string) throws SQLException {
        Connection connection = this.getTestConfiguration().openConnection(string);
        this.addConnection(connection);
        this.initializeConnection(connection);
        return connection;
    }

    public int runScript(InputStream inputStream, String string) throws UnsupportedEncodingException, SQLException {
        TestNullOutputStream testNullOutputStream = new TestNullOutputStream();
        return ij.runScript((Connection)this.getConnection(), (InputStream)inputStream, (String)string, (OutputStream)testNullOutputStream, (String)string);
    }

    public int runScript(String string, String string2) throws UnsupportedEncodingException, SQLException, PrivilegedActionException, IOException {
        URL uRL = BaseJDBCTestCase.getTestResource(string);
        BaseJDBCTestCase.assertNotNull((String)("SQL script missing: " + string), (Object)uRL);
        InputStream inputStream = BaseJDBCTestCase.openTestResource(uRL);
        Connection connection = this.getConnection();
        int n = this.runScript(inputStream, string2);
        inputStream.close();
        if (!connection.isClosed() && !connection.getAutoCommit()) {
            connection.commit();
        }
        return n;
    }

    public int runSQLCommands(String string) throws UnsupportedEncodingException, SQLException {
        byte[] byArray = string.getBytes("UTF-8");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        return this.runScript(byteArrayInputStream, "UTF-8");
    }

    public static boolean usingEmbedded() {
        return TestConfiguration.getCurrent().getJDBCClient().isEmbedded();
    }

    public static boolean usingDerbyNetClient() {
        return TestConfiguration.getCurrent().getJDBCClient().isDerbyNetClient();
    }

    public static boolean usingDB2Client() {
        return TestConfiguration.getCurrent().getJDBCClient().isDB2Client();
    }

    public String getDatabaseProperty(String string) throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("VALUES SYSCS_UTIL.SYSCS_GET_DATABASE_PROPERTY(?)");
        preparedStatement.setString(1, string);
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        String string2 = resultSet.getString(1);
        resultSet.close();
        this.closeStatement(preparedStatement);
        return string2;
    }

    public static void assertEquals(Blob blob, Blob blob2) throws IOException, SQLException {
        if (blob == null || blob2 == null) {
            BaseJDBCTestCase.assertNull((String)"Blob b2 is null, b1 is not", (Object)blob);
            BaseJDBCTestCase.assertNull((String)"Blob b1 is null, b2 is not", (Object)blob2);
            return;
        }
        BaseJDBCTestCase.assertEquals((String)"Blobs have different lengths", (long)blob.length(), (long)blob2.length());
        InputStream inputStream = blob.getBinaryStream();
        InputStream inputStream2 = blob2.getBinaryStream();
        if (inputStream == null || inputStream2 == null) {
            BaseJDBCTestCase.assertNull((String)"Blob b2 has null-stream, blob b1 doesn't", (Object)inputStream);
            BaseJDBCTestCase.assertNull((String)"Blob b1 has null-stream, blob b2 doesn't", (Object)inputStream2);
            return;
        }
        inputStream = new BufferedInputStream(inputStream);
        inputStream2 = new BufferedInputStream(inputStream2);
        long l = 1L;
        int n = inputStream.read();
        int n2 = inputStream2.read();
        do {
            if (n != n2) {
                BaseJDBCTestCase.assertEquals((String)("Blobs differ at index " + l), (int)n, (int)n2);
            }
            ++l;
            n = inputStream.read();
            n2 = inputStream2.read();
        } while (n != -1 || n2 != -1);
        inputStream.close();
        inputStream2.close();
    }

    public static void assertEquals(Clob clob, Clob clob2) throws IOException, SQLException {
        if (clob == null || clob2 == null) {
            BaseJDBCTestCase.assertNull((String)"Clob c2 is null, c1 is not", (Object)clob);
            BaseJDBCTestCase.assertNull((String)"Clob c1 is null, c2 is not", (Object)clob2);
            return;
        }
        BaseJDBCTestCase.assertEquals((String)"Clobs have different lengths", (long)clob.length(), (long)clob2.length());
        Reader reader = clob.getCharacterStream();
        BaseJDBCTestCase.assertNotNull((Object)reader);
        Reader reader2 = clob2.getCharacterStream();
        BaseJDBCTestCase.assertNotNull((Object)reader2);
        reader = new BufferedReader(reader);
        reader2 = new BufferedReader(reader2);
        long l = 1L;
        int n = reader.read();
        int n2 = reader2.read();
        do {
            if (n != n2) {
                BaseJDBCTestCase.assertEquals((String)("Clobs differ at index " + l), (int)n, (int)n2);
            }
            ++l;
            n = reader.read();
            n2 = reader2.read();
        } while (n != -1 || n2 != -1);
        reader.close();
        reader2.close();
    }

    public static void assertEquals(String string, Time time, Time time2) {
        if (null == time && null == time2) {
            return;
        }
        BaseJDBCTestCase.assertNotNull((String)string, (Object)time);
        BaseJDBCTestCase.assertNotNull((String)string, (Object)time2);
        BaseJDBCTestCase.assertEquals((String)string, (String)time.toString(), (String)time2.toString());
    }

    public static void assertSQLState(String string, String string2, SQLException sQLException) {
        BaseJDBCTestCase.assertNotNull((String)"Exception cannot be null when asserting on SQLState", (Object)sQLException);
        try {
            String string3 = sQLException.getSQLState();
            if (string3 != null) {
                BaseJDBCTestCase.assertTrue((String)"The exception's SQL state must be five characters long", (string3.length() == 5 ? 1 : 0) != 0);
            }
            if (string2 != null) {
                BaseJDBCTestCase.assertTrue((String)"The expected SQL state must be five characters long", (string2.length() == 5 ? 1 : 0) != 0);
            }
            BaseJDBCTestCase.assertEquals((String)string, (String)string2, (String)string3);
        }
        catch (AssertionFailedError assertionFailedError) {
            assertionFailedError.initCause((Throwable)sQLException);
            if (BaseJDBCTestCase.usingDB2Client()) {
                String string4 = sQLException.getMessage();
                if (!string4.substring(string4.lastIndexOf(":") + 1).trim().equals(string2)) {
                    throw assertionFailedError;
                }
            }
            if ((sQLException = sQLException.getNextException()) != null) {
                BaseJDBCTestCase.assertSQLState(string, string2, sQLException);
            }
            throw assertionFailedError;
        }
    }

    public static void assertWarning(Connection connection, String string) throws SQLException {
        SQLWarning sQLWarning = connection.getWarnings();
        BaseJDBCTestCase.assertNotNull((Object)sQLWarning);
        for (SQLWarning sQLWarning2 = sQLWarning; sQLWarning2 != null; sQLWarning2 = sQLWarning2.getNextWarning()) {
            if (!string.equals(sQLWarning2.getSQLState())) continue;
            return;
        }
        BaseJDBCTestCase.fail((String)("Expected to see a SQLWarning with the SQLState " + string));
    }

    public static void assertSQLState(String string, SQLException sQLException) {
        BaseJDBCTestCase.assertSQLState("Unexpected SQL state.", string, sQLException);
    }

    public static void assertErrorCode(int n, SQLException sQLException) {
        BaseJDBCTestCase.assertNotNull((String)"Exception should not be null", (Object)sQLException);
        int n2 = sQLException.getErrorCode();
        if (n2 != n) {
            BaseJDBCTestCase.fail("Expected error code " + n + ", got " + n2, sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assertCompileError(String string, String string2) {
        try {
            PreparedStatement preparedStatement = this.prepareStatement(string2);
            if (BaseJDBCTestCase.usingDB2Client()) {
                try {
                    preparedStatement.execute();
                }
                finally {
                    preparedStatement.close();
                }
            }
            BaseJDBCTestCase.fail((String)("expected compile error: " + string));
        }
        catch (SQLException sQLException) {
            BaseJDBCTestCase.assertSQLState(string, sQLException);
        }
    }

    public void assertCheckTable(String string) throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("VALUES SYSCS_UTIL.SYSCS_CHECK_TABLE(?, ?)");
        preparedStatement.setString(1, this.getTestConfiguration().getUserName());
        preparedStatement.setString(2, string);
        ResultSet resultSet = preparedStatement.executeQuery();
        JDBC.assertSingleValueResultSet(resultSet, "1");
        preparedStatement.close();
    }

    protected void assertTableRowCount(String string, int n) throws SQLException {
        this.assertEscapedTableRowCount(JDBC.escape(string), n);
    }

    private void assertEscapedTableRowCount(String string, int n) throws SQLException {
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT COUNT(*) FROM " + string);
        resultSet.next();
        BaseJDBCTestCase.assertEquals((String)(string + " row count:"), (int)n, (int)resultSet.getInt(1));
        resultSet.close();
        statement.close();
    }

    protected final void emptyStatementCache() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("CALL SYSCS_UTIL.SYSCS_EMPTY_STATEMENT_CACHE()");
        this.closeStatement(statement);
    }

    public final void dropTable(String string) throws SQLException {
        BaseJDBCTestCase.dropTable(this.getConnection(), string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dropTable(Connection connection, String string) throws SQLException {
        String string2 = "DROP TABLE " + string;
        try (Statement statement = connection.createStatement();){
            statement.executeUpdate(string2);
        }
    }

    public final void dropView(String string) throws SQLException {
        BaseJDBCTestCase.dropView(this.getConnection(), string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dropView(Connection connection, String string) throws SQLException {
        String string2 = "DROP VIEW " + string;
        try (Statement statement = connection.createStatement();){
            statement.executeUpdate(string2);
        }
    }

    public static void assertStatementError(String[] stringArray, Statement statement, String string) {
        BaseJDBCTestCase.assertStatementErrorMinion(stringArray, true, statement, string);
    }

    public static void assertStatementErrorUnordered(String[] stringArray, Statement statement, String string) {
        BaseJDBCTestCase.assertStatementErrorMinion(stringArray, false, statement, string);
    }

    private static void assertStatementErrorMinion(String[] stringArray, boolean bl, Statement statement, String string) {
        ArrayList<String> arrayList = null;
        if (!bl) {
            arrayList = new ArrayList<String>(Arrays.asList(stringArray));
        }
        try {
            boolean bl2 = statement.execute(string);
            BaseJDBCTestCase.fetchAndDiscardAllResults(statement, bl2);
            Object object = "Expected error(s) '";
            for (int i = 0; i < stringArray.length; ++i) {
                object = (String)object + " " + stringArray[i];
            }
            object = (String)object + "' but no error was thrown.";
            BaseJDBCTestCase.fail((String)object);
        }
        catch (SQLException sQLException) {
            SQLException sQLException2;
            int n = 0;
            do {
                if (bl) {
                    BaseJDBCTestCase.assertSQLState(stringArray[n], sQLException2);
                    continue;
                }
                String string2 = sQLException2.getSQLState();
                BaseJDBCTestCase.assertTrue((String)("Unexpected state: " + string2), (boolean)arrayList.remove(string2));
                BaseJDBCTestCase.assertSQLState(string2, sQLException2);
            } while ((sQLException2 = sQLException2.getNextException()) != null && ++n < stringArray.length);
            BaseJDBCTestCase.assertEquals((String)("Got " + n + " exceptions. Expected at least" + stringArray.length), (int)n, (int)stringArray.length);
        }
    }

    public static void assertStatementError(String string, Statement statement, String string2) {
        BaseJDBCTestCase.assertStatementError(new String[]{string}, statement, string2);
    }

    public static void assertCommitError(String string, Connection connection) {
        try {
            connection.commit();
            BaseJDBCTestCase.fail();
        }
        catch (SQLException sQLException) {
            BaseJDBCTestCase.assertSQLState(string, sQLException);
        }
    }

    public static void assertStatementError(String string, int n, Statement statement, String string2) {
        try {
            boolean bl = statement.execute(string2);
            BaseJDBCTestCase.fetchAndDiscardAllResults(statement, bl);
            BaseJDBCTestCase.fail((String)("Expected error '" + string + "' but no error was thrown."));
        }
        catch (SQLException sQLException) {
            BaseJDBCTestCase.assertSQLState(string, sQLException);
            BaseJDBCTestCase.assertErrorCode(n, sQLException);
        }
    }

    public static void assertPreparedStatementError(String string, PreparedStatement preparedStatement) {
        try {
            boolean bl = preparedStatement.execute();
            BaseJDBCTestCase.fetchAndDiscardAllResults(preparedStatement, bl);
            BaseJDBCTestCase.fail((String)("Expected error '" + string + "' but no error was thrown."));
        }
        catch (SQLException sQLException) {
            BaseJDBCTestCase.assertSQLState(string, sQLException);
        }
    }

    public static void assertStatementError(String string, PreparedStatement preparedStatement) {
        try {
            boolean bl = preparedStatement.execute();
            BaseJDBCTestCase.fetchAndDiscardAllResults(preparedStatement, bl);
            BaseJDBCTestCase.fail((String)("Expected error '" + string + "' but no error was thrown."));
        }
        catch (SQLException sQLException) {
            BaseJDBCTestCase.assertSQLState(string, sQLException);
        }
    }

    public void assertCallError(String string, String string2) throws SQLException {
        try {
            CallableStatement callableStatement = this.prepareCall(string2);
            callableStatement.execute();
            BaseJDBCTestCase.fail((String)"FAIL - SQL expected to throw exception");
        }
        catch (SQLException sQLException) {
            BaseJDBCTestCase.assertSQLState(string, sQLException);
        }
    }

    public static void assertNextError(String string, ResultSet resultSet) {
        try {
            resultSet.next();
            BaseJDBCTestCase.fail((String)"Expected error on next()");
        }
        catch (SQLException sQLException) {
            BaseJDBCTestCase.assertSQLState(string, sQLException);
        }
    }

    public static void assertGetIntError(int n, String string, ResultSet resultSet) {
        try {
            resultSet.getInt(n);
            BaseJDBCTestCase.fail((String)("Expected exception " + string));
        }
        catch (SQLException sQLException) {
            BaseJDBCTestCase.assertSQLState(string, sQLException);
        }
    }

    public static void assertUpdateCount(Statement statement, int n, String string) throws SQLException {
        BaseJDBCTestCase.assertEquals((String)"Update count does not match:", (int)n, (int)statement.executeUpdate(string));
    }

    public static void assertUpdateCount(PreparedStatement preparedStatement, int n) throws SQLException {
        BaseJDBCTestCase.assertEquals((String)"Update count does not match:", (int)n, (int)preparedStatement.executeUpdate());
    }

    public SQLException getLastSQLException(SQLException sQLException) {
        SQLException sQLException2 = sQLException;
        for (SQLException sQLException3 = sQLException.getNextException(); sQLException3 != null; sQLException3 = sQLException3.getNextException()) {
            sQLException2 = sQLException3;
        }
        return sQLException2;
    }

    private static void fetchAndDiscardAllResults(Statement statement, boolean bl) throws SQLException {
        Object var2_2 = null;
        while (bl || statement.getUpdateCount() != -1) {
            if (bl) {
                JDBC.assertDrainResults(statement.getResultSet(), -1);
            }
            bl = statement.getMoreResults();
        }
    }

    public static void assertSQLExceptionEquals(SQLException sQLException, SQLException sQLException2) {
        BaseJDBCTestCase.assertNotNull((String)"Passed-in SQLException se1 cannot be null", (Object)sQLException);
        BaseJDBCTestCase.assertNotNull((String)"Passed-in SQLException se2 cannot be null", (Object)sQLException2);
        BaseJDBCTestCase.assertEquals((String)"SQLException class types are different", (String)sQLException.getClass().getName(), (String)sQLException2.getClass().getName());
        BaseJDBCTestCase.assertEquals((String)"Detailed messages of the SQLException's are different", (String)sQLException.getMessage(), (String)sQLException2.getMessage());
        Throwable throwable = sQLException.getCause();
        Throwable throwable2 = sQLException2.getCause();
        if (throwable == null) {
            BaseJDBCTestCase.assertNull((Object)throwable2);
        } else {
            BaseJDBCTestCase.assertThrowableEquals(throwable, throwable2);
        }
        if (sQLException.getNextException() == null) {
            BaseJDBCTestCase.assertNull((Object)sQLException2.getNextException());
        } else {
            BaseJDBCTestCase.assertSQLExceptionEquals(sQLException.getNextException(), sQLException2.getNextException());
        }
    }

    public static void assertEquivalentDataType(int n, int n2) {
        if (n == n2) {
            return;
        }
        if (n == 3 && n2 == 2) {
            return;
        }
        if (n == 2 && n2 == 3) {
            return;
        }
        if (n == 8 && n2 == 6) {
            return;
        }
        if (n == 6 && n2 == 8) {
            return;
        }
        BaseJDBCTestCase.fail((String)("types:" + n + " and " + n2 + " are not equivalent"));
    }

    public static int getClientTransactionID(Connection connection) throws SQLException {
        try {
            Method method = connection.getClass().getMethod("getTransactionID", new Class[0]);
            return (Integer)method.invoke((Object)connection, new Object[0]);
        }
        catch (Exception exception) {
            SQLException sQLException = new SQLException(exception.getMessage());
            sQLException.initCause(exception);
            throw sQLException;
        }
    }

    public static void checkEstimatedRowCount(Connection connection, double d) throws SQLException {
        if (!(connection instanceof EmbedConnection)) {
            return;
        }
        EmbedConnection embedConnection = (EmbedConnection)connection;
        LanguageConnectionContext languageConnectionContext = (LanguageConnectionContext)BaseJDBCTestCase.getLanguageConnectionContext((Connection)embedConnection);
        RunTimeStatistics runTimeStatistics = languageConnectionContext.getRunTimeStatisticsObject();
        BaseJDBCTestCase.assertNotNull((String)" RuntimeStatistics is null. Did you call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)?", (Object)runTimeStatistics);
        BaseJDBCTestCase.assertEquals((long)((long)d), (long)((long)runTimeStatistics.getEstimatedRowCount()));
    }

    protected void checkAllConsistency(Connection connection) throws SQLException {
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select schemaname, tablename, SYSCS_UTIL.SYSCS_CHECK_TABLE(schemaname, tablename) from sys.systables a,  sys.sysschemas b where a.schemaid = b.schemaid");
        int n = 0;
        while (resultSet.next()) {
            ++n;
            if (resultSet.getInt(3) == 1) continue;
            BaseJDBCTestCase.assertEquals((String)("Bad return from consistency check of " + resultSet.getString(1) + "." + resultSet.getString(2)), (int)1, (int)resultSet.getInt(3));
        }
        BaseJDBCTestCase.assertTrue((String)("Something wrong with consistency check query, found only " + n + " tables."), (n >= 5 ? 1 : 0) != 0);
        resultSet.close();
        statement.close();
        connection.commit();
    }

    protected static void dumpRs(ResultSet resultSet, PrintStream printStream) throws SQLException {
        int n;
        if (resultSet == null) {
            printStream.println("<NULL>");
            return;
        }
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n2 = resultSetMetaData.getColumnCount();
        if (n2 <= 0) {
            printStream.println("(no columns!)");
            return;
        }
        StringBuilder stringBuilder = new StringBuilder("\t ");
        StringBuilder stringBuilder2 = new StringBuilder("\t ");
        for (int i = 1; i <= n2; ++i) {
            if (i > 1) {
                stringBuilder.append(",");
                stringBuilder2.append(" ");
            }
            int n3 = stringBuilder.length();
            stringBuilder.append(resultSetMetaData.getColumnLabel(i));
            for (n = n3 = stringBuilder.length() - n3; n > 0; --n) {
                stringBuilder2.append("-");
            }
        }
        printStream.println(stringBuilder.toString());
        printStream.println(stringBuilder2.toString());
        StringBuilder stringBuilder3 = new StringBuilder();
        while (resultSet.next()) {
            stringBuilder3.append("\t{");
            for (n = 1; n <= n2; ++n) {
                if (n > 1) {
                    stringBuilder3.append(",");
                }
                stringBuilder3.append(resultSet.getString(n));
            }
            stringBuilder3.append("}\n");
        }
        printStream.println(stringBuilder3.toString());
        resultSet.close();
    }

    public static void dumpRs(ResultSet resultSet) throws SQLException {
        BaseJDBCTestCase.dumpRs(resultSet, System.out);
    }

    protected void goodStatement(Connection connection, String string) throws SQLException {
        PreparedStatement preparedStatement = this.chattyPrepare(connection, string);
        preparedStatement.execute();
        preparedStatement.close();
    }

    protected void goodUpdate(Connection connection, String string, int n) throws SQLException {
        PreparedStatement preparedStatement = this.chattyPrepare(connection, string);
        int n2 = preparedStatement.executeUpdate();
        preparedStatement.close();
        BaseJDBCTestCase.println("Expecting to touch " + n + " rows.");
        BaseJDBCTestCase.assertEquals((int)n, (int)n2);
    }

    protected void assertResults(Connection connection, String string, String[][] stringArray, boolean bl) throws SQLException {
        PreparedStatement preparedStatement = this.chattyPrepare(connection, string);
        ResultSet resultSet = preparedStatement.executeQuery();
        this.assertResults(resultSet, stringArray, bl);
        resultSet.close();
        preparedStatement.close();
    }

    protected void assertResults(ResultSet resultSet, String[][] stringArray, boolean bl) throws SQLException {
        for (String[] stringArray2 : stringArray) {
            int n = stringArray2.length;
            BaseJDBCTestCase.assertTrue((boolean)resultSet.next());
            for (int i = 0; i < n; ++i) {
                String string = stringArray2[i];
                String string2 = null;
                int n2 = i + 1;
                string2 = resultSet.getString(n2);
                if (resultSet.wasNull()) {
                    string2 = null;
                }
                if (string2 != null && bl) {
                    string2 = string2.trim();
                }
                BaseJDBCTestCase.assertEquals((string == null ? 1 : 0) != 0, (boolean)resultSet.wasNull());
                if (string == null) {
                    BaseJDBCTestCase.assertNull((Object)string2);
                    continue;
                }
                BaseJDBCTestCase.assertEquals((String)string, (String)string2);
            }
        }
        BaseJDBCTestCase.assertFalse((boolean)resultSet.next());
    }

    protected static ResultSet executeQuery(Statement statement, String string) throws SQLException {
        BaseJDBCTestCase.println("Executing '" + string + "'");
        return statement.executeQuery(string);
    }

    protected PreparedStatement chattyPrepare(Connection connection, String string) throws SQLException {
        BaseJDBCTestCase.println("Preparing statement:\n\t" + string);
        return connection.prepareStatement(string);
    }

    protected CallableStatement chattyPrepareCall(Connection connection, String string) throws SQLException {
        BaseJDBCTestCase.println("Preparing callable statement:\n\t" + string);
        return connection.prepareCall(string);
    }

    protected void expectCompilationError(String string, String string2) {
        BaseJDBCTestCase.println("\nExpecting " + string + " when preparing:\n\t" + string2);
        this.assertCompileError(string, string2);
    }

    protected void expectCompilationError(Connection connection, String string, String string2) {
        BaseJDBCTestCase.println("\nExpecting " + string + " when preparing:\n\t" + string2);
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(string2);
        }
        catch (SQLException sQLException) {
            BaseJDBCTestCase.assertSQLState(string, sQLException);
            return;
        }
        BaseJDBCTestCase.fail((String)("Expected SQL state: " + string));
    }

    protected void expectExecutionError(Connection connection, String string, String string2) throws Exception {
        BaseJDBCTestCase.println("\nExpecting " + string + " when executing:\n\t");
        PreparedStatement preparedStatement = this.chattyPrepare(connection, string2);
        BaseJDBCTestCase.assertStatementError(string, preparedStatement);
        preparedStatement.close();
    }

    private static Object getLanguageConnectionContext(Connection connection) {
        final EmbedConnection embedConnection = (EmbedConnection)connection;
        return AccessController.doPrivileged(new PrivilegedAction<LanguageConnectionContext>(){

            @Override
            public LanguageConnectionContext run() {
                return embedConnection.getLanguageConnection();
            }
        });
    }
}

