/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import junit.extensions.TestSetup;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import org.apache.derbyTesting.functionTests.util.PrivilegedFileOpsForTests;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.ChangeSSLSetup;
import org.apache.derbyTesting.junit.ChangeUserSetup;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.Connector;
import org.apache.derbyTesting.junit.ConnectorSetup;
import org.apache.derbyTesting.junit.DataSourceConnector;
import org.apache.derbyTesting.junit.DatabaseChangeSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.Derby;
import org.apache.derbyTesting.junit.DropDatabaseSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.JDBCClient;
import org.apache.derbyTesting.junit.JDBCClientSetup;
import org.apache.derbyTesting.junit.NetworkServerControlWrapper;
import org.apache.derbyTesting.junit.NetworkServerTestSetup;
import org.apache.derbyTesting.junit.ReleaseRepository;
import org.apache.derbyTesting.junit.SecurityManagerSetup;
import org.apache.derbyTesting.junit.ServerSetup;

public final class TestConfiguration {
    private static final String DEFAULT_DBNAME = "wombat";
    private static final String DEFAULT_DBNAME_SQL = "dbsqlauth";
    private static final String DEFAULT_USER_NAME = "APP";
    private static final String DEFAULT_USER_PASSWORD = "APP";
    private static final int DEFAULT_PORT = 1527;
    private static final String DEFAULT_FRAMEWORK = "embedded";
    private static final String DEFAULT_HOSTNAME = "localhost";
    private static final int LOCKFILETIMEOUT = 300000;
    private static final int MAX_PORTS_USED = 22;
    private static final int basePort;
    private static int lastAssignedPort;
    private static final int bogusPort;
    private static int assignedPortCount;
    private FileOutputStream serverOutput;
    private static final int SLEEP_TIME = 1000;
    private static final String KEY_DBNAME = "databaseName";
    private static final String KEY_FRAMEWORK = "framework";
    private static final String KEY_USER_PASSWORD = "password";
    private static final String KEY_USER_NAME = "user";
    private static final String KEY_HOSTNAME = "hostName";
    private static final String KEY_PORT = "port";
    private static final String KEY_VERBOSE = "derby.tests.debug";
    private static final String KEY_LOGIN_TIMEOUT = "derby.tests.login.timeout";
    private static final String KEY_TRACE = "derby.tests.trace";
    public static final String KEY_OMIT_LUCENE = "derby.tests.omitLucene";
    public static final String KEY_OMIT_JSON = "derby.tests.omitJson";
    private static final String KEY_STOP_AFTER_FIRST_FAIL = "derby.tests.stopAfterFirstFail";
    private static final String KEY_SSL = "ssl";
    private static final String KEY_JMX_PORT = "jmxPort";
    private static int uniqueDB;
    private static ReleaseRepository releaseRepository;
    private static final TestConfiguration JUNIT_CONFIG;
    private static final TestConfiguration DEFAULT_CONFIG;
    private static final ThreadLocal<TestConfiguration> CURRENT_CONFIG;
    private final String defaultDbName;
    private final ArrayList<String> usedDbNames = new ArrayList();
    private final HashMap<String, String> logicalDbMapping = new HashMap();
    private final String url;
    private final String userName;
    private final String userPassword;
    private final int port;
    private final String hostName;
    private final JDBCClient jdbcClient;
    private final int jmxPort;
    private boolean isVerbose;
    private boolean doTrace;
    private boolean stopAfterFirstFail;
    private String ssl;
    private Properties connectionAttributes;
    private String passwordToken = "";
    Connector connector;

    public static TestConfiguration getCurrent() {
        return CURRENT_CONFIG.get();
    }

    public static synchronized ReleaseRepository getReleaseRepository() {
        if (releaseRepository == null) {
            try {
                releaseRepository = ReleaseRepository.getInstance();
            }
            catch (IOException iOException) {
                BaseTestCase.printStackTrace(iOException);
                Assert.fail((String)("failed to initialize the release repository: " + iOException.getMessage()));
            }
        }
        return releaseRepository;
    }

    static void setCurrent(TestConfiguration testConfiguration) {
        CURRENT_CONFIG.set(testConfiguration);
    }

    public static Test defaultSuite(Class clazz) {
        return TestConfiguration.defaultSuite(clazz, true);
    }

    public static Test defaultSuite(Class clazz, boolean bl) {
        BaseTestSuite baseTestSuite = new BaseTestSuite(TestConfiguration.suiteName(clazz));
        if (bl) {
            baseTestSuite.addTest((Test)new CleanDatabaseTestSetup(TestConfiguration.embeddedSuite(clazz)));
            baseTestSuite.addTest((Test)new CleanDatabaseTestSetup(TestConfiguration.clientServerSuite(clazz)));
        } else {
            baseTestSuite.addTest(TestConfiguration.embeddedSuite(clazz));
            baseTestSuite.addTest(TestConfiguration.clientServerSuite(clazz));
        }
        return baseTestSuite;
    }

    public static Test defaultExistingServerSuite(Class clazz) {
        return TestConfiguration.defaultExistingServerSuite(clazz, true);
    }

    public static Test defaultExistingServerSuite(Class clazz, boolean bl) {
        BaseTestSuite baseTestSuite = new BaseTestSuite(TestConfiguration.suiteName(clazz));
        if (bl) {
            baseTestSuite.addTest((Test)new CleanDatabaseTestSetup(TestConfiguration.clientExistingServerSuite(clazz)));
        } else {
            baseTestSuite.addTest(TestConfiguration.clientExistingServerSuite(clazz));
        }
        return baseTestSuite;
    }

    public static Test existingServerSuite(Class clazz, boolean bl, String string, int n) {
        BaseTestSuite baseTestSuite = new BaseTestSuite(TestConfiguration.suiteName(clazz));
        if (bl) {
            baseTestSuite.addTest((Test)new CleanDatabaseTestSetup(TestConfiguration.clientExistingServerSuite(clazz, string, n)));
        } else {
            baseTestSuite.addTest(TestConfiguration.clientExistingServerSuite(clazz, string, n));
        }
        return baseTestSuite;
    }

    public static Test existingServerSuite(Class clazz, boolean bl, String string, int n, String string2) {
        BaseTestSuite baseTestSuite = new BaseTestSuite(TestConfiguration.suiteName(clazz));
        if (bl) {
            baseTestSuite.addTest((Test)new CleanDatabaseTestSetup(TestConfiguration.clientExistingServerSuite(clazz, string, n, string2)));
        } else {
            baseTestSuite.addTest(TestConfiguration.clientExistingServerSuite(clazz, string, n, string2));
        }
        return baseTestSuite;
    }

    public static Test forceJDBC3Suite(Class clazz) {
        BaseTestSuite baseTestSuite = new BaseTestSuite(TestConfiguration.suiteName(clazz));
        baseTestSuite.addTest((Test)new CleanDatabaseTestSetup(TestConfiguration.forceJDBC3Embedded(TestConfiguration.embeddedSuite(clazz))));
        baseTestSuite.addTest((Test)new CleanDatabaseTestSetup(TestConfiguration.forceJDBC3NetClient(TestConfiguration.clientServerSuite(clazz))));
        return baseTestSuite;
    }

    static String suiteName(Class clazz) {
        int n = clazz.getName().lastIndexOf(46);
        String string = clazz.getName();
        if (n != -1) {
            string = string.substring(n + 1, string.length());
        }
        return string;
    }

    public static Test embeddedSuite(Class clazz) {
        return new BaseTestSuite(clazz, TestConfiguration.suiteName(clazz) + ":embedded");
    }

    public static Test clientServerSuite(Class clazz) {
        return TestConfiguration.clientServerDecorator(TestConfiguration.bareClientServerSuite(clazz));
    }

    public static Test clientServerSuiteWithAlternativePort(Class clazz) {
        return TestConfiguration.clientServerDecoratorWithAlternativePort(TestConfiguration.bareClientServerSuite(clazz));
    }

    public static Test clientExistingServerSuite(Class clazz) {
        return TestConfiguration.defaultExistingServerDecorator(TestConfiguration.bareClientServerSuite(clazz));
    }

    public static Test clientExistingServerSuite(Class clazz, String string, int n) {
        return TestConfiguration.existingServerDecorator(TestConfiguration.bareClientServerSuite(clazz), string, n);
    }

    public static Test clientExistingServerSuite(Class clazz, String string, int n, String string2) {
        return TestConfiguration.existingServerDecorator(TestConfiguration.bareClientServerSuite(clazz), string, n, string2);
    }

    public static Test clientServerDecorator(Test test) {
        NetworkServerTestSetup networkServerTestSetup = new NetworkServerTestSetup(test, false);
        return TestConfiguration.defaultServerDecorator((Test)networkServerTestSetup);
    }

    public static Test clientServerDecorator(Test test, String[] stringArray, String[] stringArray2, boolean bl, String string, boolean bl2, boolean bl3) {
        NetworkServerTestSetup networkServerTestSetup = new NetworkServerTestSetup(test, stringArray, stringArray2, bl, string, bl2, bl3);
        return TestConfiguration.defaultServerDecorator((Test)networkServerTestSetup);
    }

    public static Test clientServerDecoratorWithPort(Test test, int n) {
        NetworkServerTestSetup networkServerTestSetup = new NetworkServerTestSetup(test, false);
        return TestConfiguration.existingServerDecorator((Test)networkServerTestSetup, DEFAULT_HOSTNAME, n);
    }

    public static Test clientServerDecoratorWithAlternativePort(Test test) {
        NetworkServerTestSetup networkServerTestSetup = new NetworkServerTestSetup(test, false);
        return TestConfiguration.defaultServerDecoratorWithAlternativePort((Test)networkServerTestSetup);
    }

    public static Test defaultExistingServerDecorator(Test test) {
        if (!Derby.hasClient() || JDBC.vmSupportsJSR169()) {
            return new BaseTestSuite("empty: no network server support in JSR169 (or derbyclient.jar missing).");
        }
        ServerSetup serverSetup = new ServerSetup(test, DEFAULT_HOSTNAME, TestConfiguration.getCurrent().getPort());
        serverSetup.setJDBCClient(JDBCClient.DERBYNETCLIENT);
        return serverSetup;
    }

    public static Test defaultServerDecorator(Test test) {
        if (!TestConfiguration.supportsClientServer()) {
            return new BaseTestSuite("empty: no network server support");
        }
        return new ServerSetup(test, DEFAULT_HOSTNAME, TestConfiguration.getCurrent().getPort());
    }

    public static Test existingServerDecorator(Test test, String string, int n) {
        if (!TestConfiguration.supportsClientServer()) {
            return new BaseTestSuite("empty: no network server support");
        }
        ServerSetup serverSetup = new ServerSetup(test, string, n);
        serverSetup.setJDBCClient(JDBCClient.DERBYNETCLIENT);
        return serverSetup;
    }

    public static Test existingServerDecorator(Test test, String string, int n, String string2) {
        if (!TestConfiguration.supportsClientServer()) {
            return new BaseTestSuite("empty: no network server support");
        }
        ServerSetup serverSetup = new ServerSetup(test, string, n);
        serverSetup.setJDBCClient(JDBCClient.DERBYNETCLIENT);
        serverSetup.setDbPath(string2);
        return serverSetup;
    }

    public static Test defaultServerDecoratorWithAlternativePort(Test test) {
        if (!TestConfiguration.supportsClientServer()) {
            return new BaseTestSuite("empty: no network server support");
        }
        int n = TestConfiguration.getCurrent().getNextAvailablePort();
        return new ServerSetup(test, DEFAULT_HOSTNAME, n);
    }

    private static boolean supportsClientServer() {
        return JDBC.vmSupportsJDBC3() && Derby.hasClient() && Derby.hasServer();
    }

    private static Test bareClientServerSuite(Class clazz) {
        BaseTestSuite baseTestSuite = new BaseTestSuite(TestConfiguration.suiteName(clazz) + ":client");
        if (TestConfiguration.supportsClientServer()) {
            baseTestSuite.addTestSuite(clazz);
        }
        return baseTestSuite;
    }

    public static synchronized String generateUniqueDatabaseName() {
        String string = "singleUse/oneuse";
        string = string.concat(Integer.toHexString(uniqueDB++));
        return string;
    }

    public static TestSetup singleUseDatabaseDecorator(Test test) {
        String string = TestConfiguration.generateUniqueDatabaseName();
        return new DatabaseChangeSetup((Test)new DropDatabaseSetup(test, string), string, string, true);
    }

    public static TestSetup singleUseDatabaseDecorator(Test test, String string) {
        return new DatabaseChangeSetup((Test)new DropDatabaseSetup(test, string), string, string, true);
    }

    public static TestSetup singleUseDatabaseDecoratorNoShutdown(Test test) {
        String string = TestConfiguration.generateUniqueDatabaseName();
        return new DatabaseChangeSetup((Test)new DropDatabaseSetup(test, string, false), string, string, true);
    }

    public static DatabaseChangeSetup additionalDatabaseDecorator(Test test, String string) {
        return new DatabaseChangeSetup((Test)new DropDatabaseSetup(test, string), string, TestConfiguration.generateUniqueDatabaseName(), false);
    }

    public static DatabaseChangeSetup additionalDatabaseDecoratorNoShutdown(Test test, String string) {
        return TestConfiguration.additionalDatabaseDecoratorNoShutdown(test, string, false);
    }

    public static DatabaseChangeSetup additionalDatabaseDecoratorNoShutdown(Test test, String string, boolean bl) {
        return new DatabaseChangeSetup((Test)new DropDatabaseSetup(test, string, false), string, TestConfiguration.generateUniqueDatabaseName(), bl);
    }

    public static DatabaseChangeSetup additionalDatabaseDecoratorNoShutdown(Test test, String string, String string2) {
        return new DatabaseChangeSetup((Test)new DropDatabaseSetup(test, string, false), string, string2, false);
    }

    public static Test changeUserDecorator(Test test, String string, String string2) {
        return new ChangeUserSetup(test, string, string2);
    }

    public static Test sqlAuthorizationDecorator(Test test) {
        Properties properties = new Properties();
        properties.setProperty("derby.database.sqlAuthorization", "true");
        DatabasePropertyTestSetup databasePropertyTestSetup = DatabasePropertyTestSetup.getNoTeardownInstance(test, properties, true);
        return TestConfiguration.changeUserDecorator((Test)new DatabaseChangeSetup((Test)databasePropertyTestSetup, DEFAULT_DBNAME_SQL, DEFAULT_DBNAME_SQL, true), "TEST_DBO", "dummy");
    }

    public static Test sqlAuthorizationDecoratorSingleUse(Test test) {
        return TestConfiguration.sqlAuthorizationDecoratorSingleUse(test, DEFAULT_DBNAME_SQL, false);
    }

    public static Test sqlAuthorizationDecoratorSingleUse(Test test, String string, boolean bl) {
        Properties properties = new Properties();
        properties.setProperty("derby.database.sqlAuthorization", "true");
        TestSetup testSetup = DatabasePropertyTestSetup.getNoTeardownInstance(test, properties, true);
        testSetup = new DropDatabaseSetup((Test)testSetup, string, bl);
        testSetup = new DatabaseChangeSetup((Test)testSetup, string, string, true);
        return TestConfiguration.changeUserDecorator((Test)testSetup, "TEST_DBO", "dummy");
    }

    public static Test sqlAuthorizationDecorator(Test test, String[] stringArray, String string) {
        String[] stringArray2 = new String[stringArray.length + 1];
        stringArray2[0] = "TEST_DBO";
        System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
        return TestConfiguration.sqlAuthorizationDecorator(DatabasePropertyTestSetup.builtinAuthentication(test, stringArray2, string));
    }

    public static Test connectionCPDecorator(Test test) {
        if (JDBC.vmSupportsJDBC3()) {
            return new ConnectorSetup(test, "org.apache.derbyTesting.junit.ConnectionPoolDataSourceConnector");
        }
        return new BaseTestSuite("ConnectionPoolDataSource not supported");
    }

    public static Test connectionXADecorator(Test test) {
        if (JDBC.vmSupportsJDBC3()) {
            return new ConnectorSetup(test, "org.apache.derbyTesting.junit.XADataSourceConnector");
        }
        return new BaseTestSuite("XADataSource not supported");
    }

    public static TestSetup connectionDSDecorator(Test test) {
        return new ConnectorSetup(test, "org.apache.derbyTesting.junit.DataSourceConnector");
    }

    public static Test forceJDBC3Embedded(Test object) {
        if (JDBC.vmSupportsJDBC4()) {
            object = new JDBCClientSetup((Test)object, JDBCClient.EMBEDDED_30);
        }
        return object;
    }

    public static Test forceJDBC3NetClient(Test test) {
        if (JDBC.vmSupportsJDBC4() && test instanceof ServerSetup) {
            ((ServerSetup)test).setJDBCClient(JDBCClient.DERBYNETCLIENT_30);
        }
        return test;
    }

    public static Test changeSSLDecorator(Test test, String string) {
        return new ChangeSSLSetup(test, string);
    }

    private TestConfiguration() {
        String string = TestConfiguration.getSystemProperties().getProperty("derby.tests.defaultDatabaseName");
        this.defaultDbName = string != null ? string : DEFAULT_DBNAME;
        this.usedDbNames.add(DEFAULT_DBNAME);
        this.logicalDbMapping.put(DEFAULT_DBNAME, DEFAULT_DBNAME);
        this.userName = "APP";
        this.userPassword = "APP";
        this.connectionAttributes = new Properties();
        this.hostName = DEFAULT_HOSTNAME;
        this.port = basePort;
        this.isVerbose = Boolean.valueOf(TestConfiguration.getSystemProperties().getProperty(KEY_VERBOSE));
        this.doTrace = Boolean.valueOf(TestConfiguration.getSystemProperties().getProperty(KEY_TRACE));
        this.stopAfterFirstFail = Boolean.valueOf(TestConfiguration.getSystemProperties().getProperty(KEY_STOP_AFTER_FIRST_FAIL));
        this.jdbcClient = JDBCClient.getDefaultEmbedded();
        this.ssl = null;
        this.jmxPort = this.getNextAvailablePort();
        this.println("basePort=" + basePort + ", bogusPort=" + bogusPort + ", jmxPort=" + this.jmxPort);
        this.url = this.createJDBCUrlWithDatabaseName(this.defaultDbName);
        this.initConnector(null);
    }

    TestConfiguration(TestConfiguration testConfiguration) {
        this.defaultDbName = testConfiguration.defaultDbName;
        this.usedDbNames.addAll(testConfiguration.usedDbNames);
        this.logicalDbMapping.putAll(testConfiguration.logicalDbMapping);
        this.userName = testConfiguration.userName;
        this.userPassword = testConfiguration.userPassword;
        this.connectionAttributes = new Properties(testConfiguration.connectionAttributes);
        this.isVerbose = testConfiguration.isVerbose;
        this.doTrace = testConfiguration.doTrace;
        this.port = testConfiguration.port;
        this.jmxPort = testConfiguration.jmxPort;
        this.jdbcClient = testConfiguration.jdbcClient;
        this.hostName = testConfiguration.hostName;
        this.ssl = testConfiguration.ssl;
        this.url = testConfiguration.url;
        this.initConnector(testConfiguration.connector);
    }

    TestConfiguration(TestConfiguration testConfiguration, JDBCClient jDBCClient, String string, int n) {
        this.defaultDbName = testConfiguration.defaultDbName;
        this.usedDbNames.addAll(testConfiguration.usedDbNames);
        this.logicalDbMapping.putAll(testConfiguration.logicalDbMapping);
        this.userName = testConfiguration.userName;
        this.userPassword = testConfiguration.userPassword;
        this.connectionAttributes = new Properties(testConfiguration.connectionAttributes);
        this.isVerbose = testConfiguration.isVerbose;
        this.doTrace = testConfiguration.doTrace;
        this.port = n;
        this.jmxPort = testConfiguration.jmxPort;
        if (bogusPort == n) {
            throw new IllegalStateException("port cannot equal bogusPort: " + bogusPort);
        }
        this.jdbcClient = jDBCClient;
        this.hostName = string;
        this.ssl = testConfiguration.ssl;
        this.url = this.createJDBCUrlWithDatabaseName(this.defaultDbName);
        this.initConnector(testConfiguration.connector);
    }

    TestConfiguration(TestConfiguration testConfiguration, JDBCClient jDBCClient, String string, int n, String string2) {
        this.defaultDbName = string2;
        this.usedDbNames.addAll(testConfiguration.usedDbNames);
        this.logicalDbMapping.putAll(testConfiguration.logicalDbMapping);
        this.userName = testConfiguration.userName;
        this.userPassword = testConfiguration.userPassword;
        this.connectionAttributes = new Properties(testConfiguration.connectionAttributes);
        this.isVerbose = testConfiguration.isVerbose;
        this.doTrace = testConfiguration.doTrace;
        this.port = n;
        this.jmxPort = testConfiguration.jmxPort;
        if (bogusPort == n) {
            throw new IllegalStateException("port cannot equal bogusPort: " + bogusPort);
        }
        this.jdbcClient = jDBCClient;
        this.hostName = string;
        this.ssl = testConfiguration.ssl;
        this.url = this.createJDBCUrlWithDatabaseName(this.defaultDbName);
        this.initConnector(testConfiguration.connector);
    }

    TestConfiguration(TestConfiguration testConfiguration, String string, String string2, String string3) {
        this.defaultDbName = testConfiguration.defaultDbName;
        this.usedDbNames.addAll(testConfiguration.usedDbNames);
        this.logicalDbMapping.putAll(testConfiguration.logicalDbMapping);
        this.userName = string;
        this.userPassword = string2;
        this.passwordToken = string3 == null ? testConfiguration.passwordToken : string3;
        this.connectionAttributes = new Properties(testConfiguration.connectionAttributes);
        this.isVerbose = testConfiguration.isVerbose;
        this.doTrace = testConfiguration.doTrace;
        this.port = testConfiguration.port;
        this.jmxPort = testConfiguration.jmxPort;
        this.jdbcClient = testConfiguration.jdbcClient;
        this.hostName = testConfiguration.hostName;
        this.ssl = testConfiguration.ssl;
        this.url = testConfiguration.url;
        this.initConnector(testConfiguration.connector);
    }

    TestConfiguration(TestConfiguration testConfiguration, String string) {
        this(testConfiguration);
        this.ssl = string;
    }

    TestConfiguration(TestConfiguration testConfiguration, String string, String string2, boolean bl) {
        this.usedDbNames.addAll(testConfiguration.usedDbNames);
        this.usedDbNames.add(string2);
        this.logicalDbMapping.putAll(testConfiguration.logicalDbMapping);
        Assert.assertNull((Object)this.logicalDbMapping.put(string, string2));
        this.defaultDbName = bl ? string2 : testConfiguration.defaultDbName;
        this.userName = testConfiguration.userName;
        this.userPassword = testConfiguration.userPassword;
        this.connectionAttributes = new Properties(testConfiguration.connectionAttributes);
        this.isVerbose = testConfiguration.isVerbose;
        this.doTrace = testConfiguration.doTrace;
        this.port = testConfiguration.port;
        this.jmxPort = testConfiguration.jmxPort;
        this.jdbcClient = testConfiguration.jdbcClient;
        this.hostName = testConfiguration.hostName;
        this.ssl = testConfiguration.ssl;
        this.url = this.createJDBCUrlWithDatabaseName(this.defaultDbName);
        this.initConnector(testConfiguration.connector);
    }

    private TestConfiguration(Properties properties) throws NumberFormatException {
        this.defaultDbName = properties.getProperty(KEY_DBNAME, DEFAULT_DBNAME);
        this.usedDbNames.add(this.defaultDbName);
        this.logicalDbMapping.put(this.defaultDbName, this.defaultDbName);
        this.userName = properties.getProperty(KEY_USER_NAME, "APP");
        this.userPassword = properties.getProperty(KEY_USER_PASSWORD, "APP");
        this.connectionAttributes = new Properties();
        this.hostName = properties.getProperty(KEY_HOSTNAME, DEFAULT_HOSTNAME);
        this.isVerbose = Boolean.valueOf(properties.getProperty(KEY_VERBOSE));
        this.doTrace = Boolean.valueOf(properties.getProperty(KEY_TRACE));
        this.port = basePort;
        this.jmxPort = this.getNextAvailablePort();
        this.println("basePort=" + basePort + ", bogusPort=" + bogusPort + ", jmxPort=" + this.jmxPort);
        this.ssl = properties.getProperty(KEY_SSL);
        String string = properties.getProperty(KEY_FRAMEWORK, DEFAULT_FRAMEWORK);
        this.jdbcClient = "DerbyNetClient".equals(string) ? JDBCClient.DERBYNETCLIENT : ("DerbyNet".equals(string) ? JDBCClient.DB2CLIENT : JDBCClient.getDefaultEmbedded());
        this.url = this.createJDBCUrlWithDatabaseName(this.defaultDbName);
        this.initConnector(null);
    }

    TestConfiguration addConnectionAttributes(Properties properties) {
        TestConfiguration testConfiguration = new TestConfiguration(this);
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            testConfiguration.connectionAttributes.setProperty(string, string2);
        }
        testConfiguration.initConnector(this.connector);
        return testConfiguration;
    }

    public static final Properties getSystemProperties() {
        return AccessController.doPrivileged(new PrivilegedAction<Properties>(){

            @Override
            public Properties run() {
                return System.getProperties();
            }
        });
    }

    private String createJDBCUrlWithDatabaseName(String string) {
        if (JDBC.vmSupportsJDBC3()) {
            Object object = this.jdbcClient.isEmbedded() ? this.jdbcClient.getUrlBase() : this.jdbcClient.getUrlBase() + this.hostName + ":" + this.port + "/";
            return ((String)object).concat(string);
        }
        return null;
    }

    private void initConnector(Connector connector) {
        Object object;
        if (connector != null) {
            try {
                object = Class.forName(connector.getClass().getName());
                this.connector = (Connector)((Class)object).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception exception) {
                Assert.fail((String)exception.getMessage());
            }
        } else if (JDBC.vmSupportsJDBC3()) {
            try {
                object = Class.forName("org.apache.derbyTesting.junit.DriverManagerConnector");
                this.connector = (Connector)((Class)object).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception exception) {
                Assert.fail((String)exception.getMessage());
            }
        } else {
            this.connector = new DataSourceConnector();
        }
        this.connector.setConfiguration(this);
        try {
            object = BaseTestCase.getSystemProperty(KEY_LOGIN_TIMEOUT);
            if (object != null) {
                int n = Integer.parseInt((String)object);
                this.connector.setLoginTimeout(n);
            }
        }
        catch (Exception exception) {
            Assert.fail((String)exception.getMessage());
        }
    }

    public JDBCClient getJDBCClient() {
        return this.jdbcClient;
    }

    public String getJDBCUrl() {
        return this.url;
    }

    public String getJDBCUrl(String string) {
        return this.createJDBCUrlWithDatabaseName(string);
    }

    public String getDefaultDatabaseName() {
        return this.defaultDbName;
    }

    public String getPhysicalDatabaseName(String string) {
        return this.logicalDbMapping.get(string);
    }

    public String getUserName() {
        return this.userName;
    }

    public String getUserPassword() {
        return this.userPassword;
    }

    public Properties getConnectionAttributes() {
        return this.connectionAttributes;
    }

    String getConnectionAttributesString() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration<?> enumeration = this.connectionAttributes.propertyNames();
        boolean bl = true;
        while (enumeration.hasMoreElements()) {
            if (!bl) {
                stringBuffer.append(';');
            }
            String string = (String)enumeration.nextElement();
            stringBuffer.append(string);
            stringBuffer.append('=');
            stringBuffer.append(this.connectionAttributes.getProperty(string));
            bl = false;
        }
        if (bl) {
            return null;
        }
        return stringBuffer.toString();
    }

    public String getHostName() {
        return this.hostName;
    }

    public static boolean isDefaultBasePort() {
        return basePort == 1527;
    }

    public static int getBasePort() {
        return basePort;
    }

    public int getPort() {
        return this.port;
    }

    public int getNextAvailablePort() {
        if (assignedPortCount + 1 > 22) {
            Assert.fail((String)("Port " + (lastAssignedPort + 1) + " exceeeds expected maximum. You may need to update TestConfiguration.MAX_PORTS_USED and the Wiki page at http://wiki.apache.org/db-derby/DerbyJUnitTesting if test runs now require more available ports"));
        }
        int n = lastAssignedPort + 1;
        ++assignedPortCount;
        lastAssignedPort = n;
        return n;
    }

    public int getJmxPort() {
        return this.jmxPort;
    }

    public int getBogusPort() {
        return bogusPort;
    }

    public String getSsl() {
        return this.ssl;
    }

    public Connection openDefaultConnection() throws SQLException {
        return this.connector.openConnection();
    }

    Connection openDefaultConnection(String string, String string2) throws SQLException {
        return this.connector.openConnection(string, string2);
    }

    Connection openConnection(String string) throws SQLException {
        return this.connector.openConnection(this.getAndVetPhysicalDatabaseName(string));
    }

    private String getAndVetPhysicalDatabaseName(String string) throws SQLException {
        String string2 = this.getPhysicalDatabaseName(string);
        if (this.usedDbNames.contains(string2)) {
            return string2;
        }
        throw new SQLException("Database name \"" + string + "\" is not in a list of used databases.Use method TestConfiguration.additionalDatabaseDecorator first.");
    }

    public Connection openConnection(String string, String string2, String string3) throws SQLException {
        return this.connector.openConnection(this.getAndVetPhysicalDatabaseName(string), string2, string3);
    }

    public Connection openPhysicalConnection(String string, String string2, String string3, Properties properties) throws SQLException {
        return this.connector.openConnection(string, string2, string3, properties);
    }

    public void shutdownDatabase() {
        try {
            this.connector.shutDatabase();
            Assert.fail((String)"Database failed to shut down");
        }
        catch (SQLException sQLException) {
            BaseJDBCTestCase.assertSQLState("Database shutdown", "08006", sQLException);
        }
    }

    public void shutdownEngine() {
        try {
            this.connector.shutEngine(true);
            Assert.fail((String)"Engine failed to shut down");
        }
        catch (SQLException sQLException) {
            BaseJDBCTestCase.assertSQLState("Engine shutdown", "XJ015", sQLException);
        }
    }

    public void shutdownEngine(boolean bl) {
        try {
            this.connector.shutEngine(bl);
            Assert.fail((String)"Engine failed to shut down");
        }
        catch (SQLException sQLException) {
            BaseJDBCTestCase.assertSQLState("Engine shutdown", "XJ015", sQLException);
        }
    }

    public int getLoginTimeout() throws SQLException {
        return this.connector.getLoginTimeout();
    }

    public void setLoginTimeout(int n) throws SQLException {
        this.connector.setLoginTimeout(n);
    }

    public void waitForShutdownComplete(String string) {
        String string2 = this.getDatabasePath(string);
        boolean bl = true;
        int n = 300000;
        int n2 = 0;
        File file = new File(string2 + File.separatorChar + "db.lck");
        File file2 = new File(string2 + File.separatorChar + "dbex.lck");
        while (bl) {
            if (n2 >= n) {
                System.out.println("TestConfigruation.waitForShutdownComplete: been looping waiting for lock files to be deleted for at least 5 minutes, giving up");
                break;
            }
            if (file.exists() || file2.exists()) {
                try {
                    System.out.println("TestConfiguration.waitForShutdownComplete: db*.lck files not deleted after " + n2 + " ms.");
                    Thread.sleep(1000L);
                    n2 += 1000;
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                continue;
            }
            bl = false;
        }
    }

    public void stopNetworkServer() {
        try {
            NetworkServerControlWrapper networkServerControlWrapper = new NetworkServerControlWrapper();
            networkServerControlWrapper.shutdown();
            if (this.serverOutput != null) {
                this.serverOutput.close();
            }
        }
        catch (Exception exception) {
            SQLException sQLException = new SQLException("Error shutting down server");
            sQLException.initCause(exception);
        }
    }

    public void startNetworkServer() throws SQLException {
        Exception exception = null;
        try {
            NetworkServerControlWrapper networkServerControlWrapper = new NetworkServerControlWrapper();
            this.serverOutput = AccessController.doPrivileged(new PrivilegedAction<FileOutputStream>(){

                @Override
                public FileOutputStream run() {
                    File file = new File("logs");
                    file.mkdir();
                    File file2 = new File(file, "serverConsoleOutput.log");
                    FileOutputStream fileOutputStream = null;
                    try {
                        fileOutputStream = new FileOutputStream(file2.getPath(), true);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        fileNotFoundException.printStackTrace();
                    }
                    return fileOutputStream;
                }
            });
            networkServerControlWrapper.start(new PrintWriter(this.serverOutput));
            boolean bl = false;
            int n = 10;
            while (!bl && n > 0) {
                try {
                    Thread.sleep(1000L);
                    networkServerControlWrapper.ping();
                    bl = true;
                }
                catch (Exception exception2) {
                    --n;
                    exception = exception2;
                }
            }
            if (!bl) {
                throw exception;
            }
        }
        catch (Exception exception3) {
            SQLException sQLException = new SQLException("Error starting network  server");
            sQLException.initCause(exception);
            throw sQLException;
        }
    }

    public void setVerbosity(boolean bl) {
        this.isVerbose = bl;
    }

    public void setTrace(boolean bl) {
        this.doTrace = bl;
    }

    public boolean isVerbose() {
        return this.isVerbose;
    }

    private void println(CharSequence charSequence) {
        if (this.isVerbose) {
            System.out.println("DEBUG: {TC@" + this.hashCode() + "} " + charSequence);
        }
    }

    public boolean doTrace() {
        return this.doTrace;
    }

    public boolean stopAfterFirstFail() {
        return this.stopAfterFirstFail;
    }

    public static boolean loadingFromJars() {
        return SecurityManagerSetup.isJars;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    File getFailureFolder(TestCase testCase) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("fail");
        stringBuffer.append(File.separatorChar);
        stringBuffer.append(this.getJDBCClient().getName());
        stringBuffer.append(File.separatorChar);
        String string = testCase.getClass().getName();
        int n = string.lastIndexOf(46);
        if (n != -1) {
            string = string.substring(n + 1, string.length());
        }
        stringBuffer.append(string);
        stringBuffer.append(File.separatorChar);
        char[] cArray = testCase.getName().toCharArray();
        block6: for (int i = 0; i < cArray.length; ++i) {
            switch (cArray[i]) {
                case '-': 
                case '_': {
                    continue block6;
                }
                default: {
                    if (Character.isLetterOrDigit(cArray[i])) continue block6;
                    cArray[i] = 95;
                }
            }
        }
        stringBuffer.append(cArray);
        String string2 = stringBuffer.toString().intern();
        final File file = new File(string2);
        String string3 = string2;
        synchronized (string3) {
            AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    if (file.exists()) {
                        // empty if block
                    }
                    return file.mkdirs();
                }
            });
        }
        return file;
    }

    boolean defaultSecurityManagerSetup() {
        if (this.jdbcClient.isDB2Client()) {
            SecurityManagerSetup.noSecurityManager();
            return false;
        }
        if ("<NONE>".equals(BaseTestCase.getSystemProperty("java.security.policy"))) {
            return false;
        }
        SecurityManagerSetup.installSecurityManager();
        return true;
    }

    static final String getPassword(String string, String string2) {
        return string.concat(string2);
    }

    public final String getPassword(String string) {
        return TestConfiguration.getPassword(string, this.passwordToken);
    }

    public final String getDatabasePath(String string) {
        Object object = string.replace('/', File.separatorChar);
        String string2 = BaseTestCase.getSystemProperty("derby.system.home");
        if (string2 == null) {
            Assert.fail((String)"not implemented");
        } else {
            object = string2 + File.separator + (String)object;
        }
        return object;
    }

    static {
        Object object = BaseTestCase.getSystemProperty("derby.tests.basePort");
        lastAssignedPort = object == null ? 1527 : Integer.parseInt((String)object);
        basePort = lastAssignedPort++;
        bogusPort = lastAssignedPort;
        assignedPortCount = 2;
        DEFAULT_CONFIG = JUNIT_CONFIG = new TestConfiguration();
        object = new File("system");
        String string = PrivilegedFileOpsForTests.getAbsolutePath((File)object);
        BaseTestCase.setSystemProperty("derby.system.home", string);
        CURRENT_CONFIG = new ThreadLocal<TestConfiguration>(){

            @Override
            protected TestConfiguration initialValue() {
                return DEFAULT_CONFIG;
            }
        };
    }
}

