/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.junit;

import java.io.IOException;
import junit.framework.Test;
import org.apache.derby.iapi.services.io.ArrayInputStream;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;

public class ArrayInputStreamTest
extends BaseTestCase {
    public static Test suite() {
        return new BaseTestSuite(ArrayInputStreamTest.class);
    }

    public ArrayInputStreamTest(String string) {
        super(string);
    }

    public void testSkipLongMaxValue() throws IOException {
        ArrayInputStream arrayInputStream = new ArrayInputStream(new byte[1000]);
        ArrayInputStreamTest.assertEquals((long)1000L, (long)arrayInputStream.skip(Long.MAX_VALUE));
        ArrayInputStreamTest.assertEquals((int)1000, (int)arrayInputStream.getPosition());
        arrayInputStream.setPosition(1);
        ArrayInputStreamTest.assertEquals((long)999L, (long)arrayInputStream.skip(Long.MAX_VALUE));
        ArrayInputStreamTest.assertEquals((int)1000, (int)arrayInputStream.getPosition());
    }

    public void testSkipBytesIntMaxValue() throws IOException {
        ArrayInputStream arrayInputStream = new ArrayInputStream(new byte[1000]);
        ArrayInputStreamTest.assertEquals((int)1000, (int)arrayInputStream.skipBytes(Integer.MAX_VALUE));
        ArrayInputStreamTest.assertEquals((int)1000, (int)arrayInputStream.getPosition());
        arrayInputStream.setPosition(1);
        ArrayInputStreamTest.assertEquals((int)999, (int)arrayInputStream.skipBytes(Integer.MAX_VALUE));
        ArrayInputStreamTest.assertEquals((int)1000, (int)arrayInputStream.getPosition());
    }

    public void testSkipNegative() throws IOException {
        ArrayInputStream arrayInputStream = new ArrayInputStream(new byte[1000]);
        ArrayInputStreamTest.assertEquals((long)0L, (long)arrayInputStream.skip(-1L));
    }

    public void testSkipBytesNegative() throws IOException {
        ArrayInputStream arrayInputStream = new ArrayInputStream(new byte[1000]);
        ArrayInputStreamTest.assertEquals((int)0, (int)arrayInputStream.skipBytes(-1));
    }
}

