/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.error.StandardException;

class CurrentDatetimeOperatorNode
extends ValueNode {
    static final int CURRENT_DATE = 0;
    static final int CURRENT_TIME = 1;
    static final int CURRENT_TIMESTAMP = 2;
    private static final int[] jdbcTypeId = new int[]{91, 92, 93};
    private static final String[] methodName = new String[]{"CURRENT DATE", "CURRENT TIME", "CURRENT TIMSTAMP"};
    private int whichType;

    CurrentDatetimeOperatorNode(int n, ContextManager contextManager) {
        super(contextManager);
        this.whichType = n;
    }

    @Override
    ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> list) throws StandardException {
        this.checkReliability(methodName[this.whichType], 1);
        this.setType(DataTypeDescriptor.getBuiltInDataTypeDescriptor(jdbcTypeId[this.whichType], false));
        return this;
    }

    @Override
    protected int getOrderableVariantType() {
        return 2;
    }

    @Override
    void generateExpression(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        switch (this.whichType) {
            case 0: {
                expressionClassBuilder.getCurrentDateExpression(methodBuilder);
                break;
            }
            case 1: {
                expressionClassBuilder.getCurrentTimeExpression(methodBuilder);
                break;
            }
            case 2: {
                expressionClassBuilder.getCurrentTimestampExpression(methodBuilder);
            }
        }
        expressionClassBuilder.generateDataValue(methodBuilder, this.getTypeCompiler(), this.getTypeServices().getCollationType(), null);
    }

    @Override
    public String toString() {
        return "";
    }

    @Override
    boolean isEquivalent(ValueNode valueNode) {
        if (this.isSameNodeKind(valueNode)) {
            CurrentDatetimeOperatorNode currentDatetimeOperatorNode = (CurrentDatetimeOperatorNode)valueNode;
            return currentDatetimeOperatorNode.whichType == this.whichType;
        }
        return false;
    }
}

