/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.conn.StatementContext;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.impl.sql.compile.DDLStatementNode;
import org.apache.derby.shared.common.error.StandardException;

class DropSchemaNode
extends DDLStatementNode {
    private int dropBehavior;
    private String schemaName;

    DropSchemaNode(String string, int n, ContextManager contextManager) {
        super(null, contextManager);
        this.schemaName = string;
        this.dropBehavior = n;
    }

    @Override
    public void bindStatement() throws StandardException {
        if (this.getDataDictionary().isSystemSchemaName(this.schemaName)) {
            throw StandardException.newException("42Y67", this.schemaName);
        }
        if (this.isPrivilegeCollectionRequired()) {
            LanguageConnectionContext languageConnectionContext = this.getLanguageConnectionContext();
            StatementContext statementContext = languageConnectionContext.getStatementContext();
            String string = statementContext.getSQLSessionContext().getCurrentUser();
            this.getCompilerContext().addRequiredSchemaPriv(this.schemaName, string, 18);
        }
    }

    @Override
    public String toString() {
        return "";
    }

    @Override
    String statementToString() {
        return "DROP SCHEMA";
    }

    @Override
    public ConstantAction makeConstantAction() throws StandardException {
        return this.getGenericConstantActionFactory().getDropSchemaConstantAction(this.schemaName);
    }
}

