/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.loader.GeneratedClass;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SPSDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.sql.execute.ExecPreparedStatement;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derby.impl.sql.compile.StatementNode;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.shared.common.error.StandardException;

class ExecSPSNode
extends StatementNode {
    private TableName name;
    private SPSDescriptor spsd;
    private ExecPreparedStatement ps;

    ExecSPSNode(TableName tableName, ContextManager contextManager) {
        super(contextManager);
        this.name = tableName;
    }

    @Override
    public void bindStatement() throws StandardException {
        DataDictionary dataDictionary = this.getDataDictionary();
        String string = this.name.getSchemaName();
        SchemaDescriptor schemaDescriptor = this.getSchemaDescriptor(this.name.getSchemaName());
        if (string == null) {
            this.name.setSchemaName(schemaDescriptor.getSchemaName());
        }
        if (schemaDescriptor.getUUID() != null) {
            this.spsd = dataDictionary.getSPSDescriptor(this.name.getTableName(), schemaDescriptor);
        }
        if (this.spsd == null) {
            throw StandardException.newException("42X94", "STATEMENT", this.name);
        }
        if (this.spsd.getType() == 'T') {
            throw StandardException.newException("42Y41", this.name);
        }
        this.getCompilerContext().createDependency(this.spsd);
    }

    @Override
    public boolean isAtomic() {
        return this.ps.isAtomic();
    }

    @Override
    public GeneratedClass generate(ByteArray byteArray) throws StandardException {
        if (!this.spsd.isValid()) {
            this.getLanguageConnectionContext().commitNestedTransaction();
            this.getLanguageConnectionContext().beginNestedTransaction(true);
        }
        this.ps = this.spsd.getPreparedStatement();
        this.getCompilerContext().setSavedObjects(this.ps.getSavedObjects());
        this.getCompilerContext().setCursorInfo(this.ps.getCursorInfo());
        GeneratedClass generatedClass = this.ps.getActivationClass();
        return generatedClass;
    }

    @Override
    public ResultDescription makeResultDescription() {
        return this.ps.getResultDescription();
    }

    @Override
    public Object getCursorInfo() {
        return this.ps.getCursorInfo();
    }

    @Override
    public DataTypeDescriptor[] getParameterTypes() throws StandardException {
        return this.spsd.getParams();
    }

    @Override
    public ConstantAction makeConstantAction() {
        return this.ps.getConstantAction();
    }

    @Override
    public boolean needsSavepoint() {
        return this.ps.needsSavepoint();
    }

    @Override
    public String executeStatementName() {
        return this.name.getTableName();
    }

    @Override
    public String executeSchemaName() {
        return this.name.getSchemaName();
    }

    @Override
    public String getSPSName() {
        return this.spsd.getQualifiedName();
    }

    @Override
    int activationKind() {
        return 2;
    }

    @Override
    String statementToString() {
        return "EXECUTE STATEMENT";
    }

    @Override
    void acceptChildren(Visitor visitor) throws StandardException {
        super.acceptChildren(visitor);
        if (this.name != null) {
            this.name = (TableName)this.name.accept(visitor);
        }
    }
}

