/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.harness;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class ProcessStreamResult
implements Runnable {
    protected InputStream in;
    protected OutputStreamWriter outStream;
    protected String encoding;
    protected boolean finished;
    protected IOException ioe;
    protected Thread myThread;
    protected long startTime;
    protected boolean interrupted;
    protected int timeout;

    public ProcessStreamResult(InputStream inputStream, BufferedOutputStream bufferedOutputStream, String string) throws IOException, InterruptedException {
        this(inputStream, bufferedOutputStream, string, null, null);
    }

    public ProcessStreamResult(InputStream inputStream, BufferedOutputStream bufferedOutputStream, String string, String string2, String string3) throws IOException, InterruptedException {
        this.in = inputStream;
        this.outStream = string3 == null ? new OutputStreamWriter(bufferedOutputStream) : new OutputStreamWriter((OutputStream)bufferedOutputStream, string3);
        this.encoding = string2;
        this.startTime = System.currentTimeMillis();
        if (string != null) {
            Integer n = Integer.valueOf(string);
            this.timeout = n;
        } else {
            this.timeout = 0;
        }
        this.myThread = new Thread(this);
        this.myThread.setPriority(1);
        this.myThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object;
        if (this.in == null) {
            System.out.println("The inputstream is null");
            System.exit(1);
        }
        try {
            int n;
            object = new char[1024];
            this.interrupted = false;
            InputStreamReader inputStreamReader = this.encoding != null ? new InputStreamReader(this.in, this.encoding) : new InputStreamReader(this.in);
            while ((n = inputStreamReader.read((char[])object, 0, ((char[])object).length)) != -1 && !this.interrupted) {
                this.outStream.write((char[])object, 0, n);
                this.outStream.flush();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.interrupted) {
            return;
        }
        ProcessStreamResult processStreamResult = this;
        object = processStreamResult;
        synchronized (processStreamResult) {
            this.finished = true;
            this.notifyAll();
            // ** MonitorExit[var1_1 /* !! */ ] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean Wait() throws IOException {
        ProcessStreamResult processStreamResult = this;
        synchronized (processStreamResult) {
            long l;
            long l2;
            int n;
            if (this.finished) {
                return this.interrupted;
            }
            if (this.timeout > 0 && (n = (int)((l2 = (l = System.currentTimeMillis()) - this.startTime) / 60000L)) > this.timeout) {
                this.interrupted = true;
                return this.interrupted;
            }
            try {
                l = (long)(this.timeout * 60) * 1000L;
                if (this.timeout > 0) {
                    this.wait(l);
                } else {
                    this.wait();
                }
                if (!this.finished) {
                    this.interrupted = true;
                }
            }
            catch (InterruptedException interruptedException) {
                this.interrupted = true;
                System.out.println("Interrupted: " + interruptedException.toString());
            }
        }
        return this.interrupted;
    }
}

