/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.i18n;

import java.nio.charset.Charset;
import java.sql.CallableStatement;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class JapanCodeConversionTest
extends BaseJDBCTestCase {
    private static final String[][] TABLE = new String[][]{{"1", "15:32:06", "\u30a4\u30d9\u30f3\u30c8\u30a2\u30e9\u30fc\u30e0\u304c\u6709\u52b9\u3067\u3059\u3002"}, {"2", "15:32:10", "DR:DRAUTO\u306f0 (Off)\u3067\u3059\u3002"}, {"3", "15:32:28", "INFORMIX-OnLine\u304c\u521d\u671f\u5316\u3055\u308c\u3001\u30c7\u30a3\u30b9\u30af\u306e\u521d\u671f\u5316\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002"}, {"4", "15:32:29", "\u30c1\u30a7\u30c3\u30af\u30dd\u30a4\u30f3\u30c8\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f:\u7d99\u7d9a\u6642\u9593\u306f 0\u79d2\u3067\u3057\u305f"}, {"5", "15:32:29", "\u3059\u3079\u3066\u306eDB\u9818\u57df\u306e\u30c7\u30fc\u30bf\u30b9\u30ad\u30c3\u30d7\u306f\u73fe\u5728\u30aa\u30d5\u306b\u306a\u3063\u3066\u3044\u307e\u3059\u3002"}, {"6", "15:32:30", "On-Line\u30e2\u30fc\u30c9"}, {"7", "15:32:31", "sysmaster\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u3092\u4f5c\u6210\u4e2d\u3067\u3059..."}, {"8", "15:33:22", "\u8ad6\u7406\u30ed\u30b0 1\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002"}, {"9", "15:33:23", "\u30ea\u30bf\u30fc\u30f3\u30b3\u30fc\u30c9 1\u3092\u623b\u3057\u3066\u30d7\u30ed\u30bb\u30b9\u304c\u7d42\u4e86\u3057\u307e\u3057\u305f:/bin/sh /bin/sh -c /work1/MOSES_7.22.UC1A5_27/sqldist/etc/log_full.sh 2 23 \u8ad6\u7406\u30ed\u30b0 1\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002 \u8ad6\u7406"}, {"10", "15:33:40", "\u8ad6\u7406\u30ed\u30b0 2\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002"}, {"11", "15:33:41", "\u30ea\u30bf\u30fc\u30f3\u30b3\u30fc\u30c9 1\u3092\u623b\u3057\u3066\u30d7\u30ed\u30bb\u30b9\u304c\u7d42\u4e86\u3057\u307e\u3057\u305f:/bin/sh /bin/sh -c /work1/MOSES_7.22.UC1A5_27/sqldist/etc/log_full.sh 2 23 \u8ad6\u7406\u30ed\u30b0 2\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002 \u8ad6\u7406"}, {"12", "15:33:43", "\u30c1\u30a7\u30c3\u30af\u30dd\u30a4\u30f3\u30c8\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f:\u7d99\u7d9a\u6642\u9593\u306f 2\u79d2\u3067\u3057\u305f"}, {"13", "15:34:29", "\u8ad6\u7406\u30ed\u30b0 3\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002"}, {"14", "15:34:30", "\u30ea\u30bf\u30fc\u30f3\u30b3\u30fc\u30c9 1\u3092\u623b\u3057\u3066\u30d7\u30ed\u30bb\u30b9\u304c\u7d42\u4e86\u3057\u307e\u3057\u305f:/bin/sh /bin/sh -c /work1/MOSES_7.22.UC1A5_27/sqldist/etc/log_full.sh 2 23 \u8ad6\u7406\u30ed\u30b0 3\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002 \u8ad6\u7406"}, {"15", "15:35:35", "sysmaster\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u306e\u4f5c\u6210\u306f\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002"}, {"16", "15:39:10", "\u30c1\u30a7\u30c3\u30af\u30dd\u30a4\u30f3\u30c8\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f:\u7d99\u7d9a\u6642\u9593\u306f 8\u79d2\u3067\u3057\u305f"}};

    public JapanCodeConversionTest(String string) {
        super(string);
    }

    public static Test suite() {
        if (Charset.isSupported("EUC_JP") && Charset.isSupported("SJIS")) {
            return new SupportFilesSetup(TestConfiguration.embeddedSuite(JapanCodeConversionTest.class), new String[]{"functionTests/tests/i18n/data/jap_EUC_JP.dat"}, null);
        }
        return new BaseTestSuite("JapanCodeConversionTest - skipped because of missing support for EUC_JP and SJIS");
    }

    @Override
    protected void tearDown() throws Exception {
        this.dropTable("T1_EUC_JP");
        this.dropTable("T1_EUC_JP_IMPORT_AS_EUC_JP");
        this.dropTable("T1_EUC_JP_IMPORT_AS_SJIS");
        super.tearDown();
    }

    public void testImportExport() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_IMPORT_TABLE(null, ?, ?, null, null, ?, 0)");
        CallableStatement callableStatement2 = this.prepareCall("call SYSCS_UTIL.SYSCS_EXPORT_TABLE(null, ?, ?, null, null, ?)");
        Statement statement = this.createStatement();
        statement.execute("create table T1_EUC_JP(jnum int, jtime time, jstring char(200))");
        callableStatement.setString(1, "T1_EUC_JP");
        callableStatement.setString(2, "extin/jap_EUC_JP.dat");
        callableStatement.setString(3, "EUC_JP");
        JapanCodeConversionTest.assertUpdateCount(callableStatement, 0);
        JDBC.assertFullResultSet(statement.executeQuery("SELECT * FROM T1_EUC_JP ORDER BY jnum"), TABLE);
        callableStatement2.setString(1, "T1_EUC_JP");
        callableStatement2.setString(2, "extout/jap_EUC_JP.dump");
        callableStatement2.setString(3, "EUC_JP");
        JapanCodeConversionTest.assertUpdateCount(callableStatement2, 0);
        callableStatement2.setString(1, "T1_EUC_JP");
        callableStatement2.setString(2, "extout/jap_SJIS.dump");
        callableStatement2.setString(3, "SJIS");
        JapanCodeConversionTest.assertUpdateCount(callableStatement2, 0);
        statement.execute("create table T1_EUC_JP_IMPORT_AS_EUC_JP(jnum int, jtime time, jstring char(200))");
        callableStatement.setString(1, "T1_EUC_JP_IMPORT_AS_EUC_JP");
        callableStatement.setString(2, "extout/jap_EUC_JP.dump");
        callableStatement.setString(3, "EUC_JP");
        JapanCodeConversionTest.assertUpdateCount(callableStatement, 0);
        JDBC.assertFullResultSet(statement.executeQuery("SELECT * FROM T1_EUC_JP_IMPORT_AS_EUC_JP ORDER BY jnum"), TABLE);
        statement.execute("create table T1_EUC_JP_IMPORT_AS_SJIS(jnum int, jtime time, jstring char(200))");
        callableStatement.setString(1, "T1_EUC_JP_IMPORT_AS_SJIS");
        callableStatement.setString(2, "extout/jap_SJIS.dump");
        callableStatement.setString(3, "SJIS");
        JapanCodeConversionTest.assertUpdateCount(callableStatement, 0);
        JDBC.assertFullResultSet(statement.executeQuery("SELECT * FROM T1_EUC_JP_IMPORT_AS_SJIS ORDER BY jnum"), TABLE);
    }
}

