/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.SupportFilesSetup;

public class Derby6587Test
extends BaseJDBCTestCase {
    public Derby6587Test(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("Derby6587Test");
        baseTestSuite.addTest(Derby6587Test.baseSuite("Derby6587:embedded"));
        return baseTestSuite;
    }

    public static Test baseSuite(String string) {
        BaseTestSuite baseTestSuite = new BaseTestSuite(Derby6587Test.class, string);
        SupportFilesSetup supportFilesSetup = new SupportFilesSetup((Test)baseTestSuite, new String[]{"functionTests/testData/Derby6587/Derby6587_TABLE1_T.csv", "functionTests/testData/Derby6587/Derby6587_TABLE2_T.csv"});
        return new CleanDatabaseTestSetup((Test)supportFilesSetup){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                statement.executeUpdate("CREATE TABLE TABLE1_T (UUID char (16) for bit data NOT NULL,NR integer NOT NULL,TEXT varchar(200) NOT NULL,CONSTRAINT IDX_1 PRIMARY KEY (UUID, NR))");
                statement.executeUpdate("CREATE TABLE TABLE2_T (UUID char (16) for bit data NOT NULL,ID1 char(5) NOT NULL,ID2 integer NOT NULL,NR integer NOT NULL,CONSTRAINT IDX_2 PRIMARY KEY (ID1, UUID))");
                statement.executeUpdate("ALTER TABLE TABLE2_T ADD CONSTRAINT FK_1 FOREIGN KEY (UUID, NR) REFERENCES TABLE1_T (UUID, NR) ON DELETE NO ACTION ON UPDATE NO ACTION");
            }
        };
    }

    public void setUp() throws SQLException {
        this.getConnection().setAutoCommit(false);
    }

    public void testBulkImport() throws SQLException {
        this.getConnection();
        try {
            this.doImportFromFile("extin/Derby6587_TABLE1_T.csv", "TABLE1_T");
            this.doImportFromFile("extin/Derby6587_TABLE2_T.csv", "TABLE2_T");
        }
        catch (SQLException sQLException) {
            Derby6587Test.fail((String)("caught SQLException: " + sQLException.getSQLState() + "; " + sQLException.getMessage()));
        }
    }

    @Override
    protected void tearDown() throws Exception {
        BaseJDBCTestCase.dropTable(this.getConnection(), "TABLE2_T");
        BaseJDBCTestCase.dropTable(this.getConnection(), "TABLE1_T");
        super.tearDown();
    }

    private void doImportFromFile(String string, String string2) throws SQLException {
        String string3 = "call SYSCS_UTIL.SYSCS_IMPORT_TABLE (? , ? , ? , ?, ? , ?, ?)";
        PreparedStatement preparedStatement = this.prepareStatement(string3);
        preparedStatement.setString(1, "APP");
        preparedStatement.setString(2, string2);
        preparedStatement.setString(3, string);
        preparedStatement.setString(4, null);
        preparedStatement.setString(5, null);
        preparedStatement.setString(6, null);
        preparedStatement.setInt(7, 0);
        preparedStatement.execute();
        preparedStatement.close();
    }
}

