/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.RuntimeStatisticsParser;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ScrollCursors1Test
extends BaseJDBCTestCase {
    public ScrollCursors1Test(String string) {
        super(string);
    }

    public void testForwardOnlyNegative() throws SQLException {
        Connection connection = this.getConnection();
        PreparedStatement preparedStatement = connection.prepareStatement("select i from t1");
        ResultSet resultSet = preparedStatement.executeQuery();
        try {
            resultSet.getRow();
            if (ScrollCursors1Test.usingEmbedded()) {
                ScrollCursors1Test.fail((String)"getRow succeeded on forward only cursor");
            }
        }
        catch (SQLException sQLException) {
            ScrollCursors1Test.assertSQLState("XJ061", sQLException);
        }
        try {
            resultSet.first();
            ScrollCursors1Test.fail((String)"first() not allowed on forward only result set");
        }
        catch (SQLException sQLException) {
            if (ScrollCursors1Test.usingEmbedded()) {
                ScrollCursors1Test.assertSQLState("XJ061", sQLException);
            }
            ScrollCursors1Test.assertSQLState("XJ125", sQLException);
        }
        try {
            resultSet.last();
            ScrollCursors1Test.fail((String)"last() not allowed on forward only result set");
        }
        catch (SQLException sQLException) {
            if (ScrollCursors1Test.usingEmbedded()) {
                ScrollCursors1Test.assertSQLState("XJ061", sQLException);
            }
            ScrollCursors1Test.assertSQLState("XJ125", sQLException);
        }
        try {
            resultSet.previous();
            ScrollCursors1Test.fail((String)"previous() not allowed on forward only result set");
        }
        catch (SQLException sQLException) {
            if (ScrollCursors1Test.usingEmbedded()) {
                ScrollCursors1Test.assertSQLState("XJ061", sQLException);
            }
            ScrollCursors1Test.assertSQLState("XJ125", sQLException);
        }
        try {
            resultSet.beforeFirst();
            ScrollCursors1Test.fail((String)"beforeFirst() not allowed on forward only result set");
        }
        catch (SQLException sQLException) {
            if (ScrollCursors1Test.usingEmbedded()) {
                ScrollCursors1Test.assertSQLState("XJ061", sQLException);
            }
            ScrollCursors1Test.assertSQLState("XJ125", sQLException);
        }
        try {
            resultSet.afterLast();
            ScrollCursors1Test.fail((String)"afterLast() not allowed on forward only result set");
        }
        catch (SQLException sQLException) {
            if (ScrollCursors1Test.usingEmbedded()) {
                ScrollCursors1Test.assertSQLState("XJ061", sQLException);
            }
            ScrollCursors1Test.assertSQLState("XJ125", sQLException);
        }
        try {
            resultSet.absolute(1);
            ScrollCursors1Test.fail((String)"absolute() not allowed on forward only result set");
        }
        catch (SQLException sQLException) {
            if (ScrollCursors1Test.usingEmbedded()) {
                ScrollCursors1Test.assertSQLState("XJ061", sQLException);
            }
            ScrollCursors1Test.assertSQLState("XJ125", sQLException);
        }
        try {
            resultSet.relative(1);
            ScrollCursors1Test.fail((String)"relative() not allowed on forward only result set");
        }
        catch (SQLException sQLException) {
            if (ScrollCursors1Test.usingEmbedded()) {
                ScrollCursors1Test.assertSQLState("XJ061", sQLException);
            }
            ScrollCursors1Test.assertSQLState("XJ125", sQLException);
        }
        resultSet.close();
        preparedStatement.close();
    }

    public void testScrollInsensitive() throws SQLException {
        Connection connection = this.getConnection();
        connection.setAutoCommit(false);
        PreparedStatement preparedStatement = connection.prepareStatement("select * from t1", 1004, 1007);
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.absolute(0);
        this.assertNoCurrentRow(resultSet);
        resultSet.close();
        resultSet = preparedStatement.executeQuery();
        resultSet.relative(0);
        this.assertNoCurrentRow(resultSet);
        resultSet.close();
        resultSet = preparedStatement.executeQuery();
        resultSet.relative(2);
        ScrollCursors1Test.assertEquals((String)"c", (String)resultSet.getString(1).trim());
        ScrollCursors1Test.assertEquals((int)3, (int)resultSet.getInt(2));
        resultSet.close();
        resultSet = preparedStatement.executeQuery();
        resultSet.first();
        ScrollCursors1Test.assertEquals((String)"b", (String)resultSet.getString(1).trim());
        ScrollCursors1Test.assertEquals((int)2, (int)resultSet.getInt(2));
        ScrollCursors1Test.assertEquals((int)1, (int)resultSet.getRow());
        resultSet.next();
        ScrollCursors1Test.assertEquals((String)"c", (String)resultSet.getString(1).trim());
        ScrollCursors1Test.assertEquals((int)3, (int)resultSet.getInt(2));
        ScrollCursors1Test.assertEquals((int)2, (int)resultSet.getRow());
        ScrollCursors1Test.assertEquals((int)2, (int)resultSet.getRow());
        resultSet.first();
        ScrollCursors1Test.assertEquals((String)"b", (String)resultSet.getString(1).trim());
        ScrollCursors1Test.assertEquals((int)2, (int)resultSet.getInt(2));
        ScrollCursors1Test.assertEquals((int)1, (int)resultSet.getRow());
        resultSet.next();
        ScrollCursors1Test.assertEquals((String)"c", (String)resultSet.getString(1).trim());
        ScrollCursors1Test.assertEquals((int)3, (int)resultSet.getInt(2));
        ScrollCursors1Test.assertEquals((int)2, (int)resultSet.getRow());
        resultSet.next();
        ScrollCursors1Test.assertEquals((String)"d", (String)resultSet.getString(1).trim());
        ScrollCursors1Test.assertEquals((int)4, (int)resultSet.getInt(2));
        ScrollCursors1Test.assertEquals((int)3, (int)resultSet.getRow());
        resultSet.first();
        ScrollCursors1Test.assertEquals((String)"b", (String)resultSet.getString(1).trim());
        ScrollCursors1Test.assertEquals((int)2, (int)resultSet.getInt(2));
        ScrollCursors1Test.assertEquals((int)1, (int)resultSet.getRow());
        resultSet.next();
        ScrollCursors1Test.assertEquals((String)"c", (String)resultSet.getString(1).trim());
        ScrollCursors1Test.assertEquals((int)3, (int)resultSet.getInt(2));
        ScrollCursors1Test.assertEquals((int)2, (int)resultSet.getRow());
        resultSet.afterLast();
        this.assertNoCurrentRow(resultSet);
        ScrollCursors1Test.assertEquals((int)0, (int)resultSet.getRow());
        ScrollCursors1Test.assertFalse((boolean)resultSet.next());
        this.assertNoCurrentRow(resultSet);
        ScrollCursors1Test.assertEquals((int)0, (int)resultSet.getRow());
        resultSet.previous();
        ScrollCursors1Test.assertEquals((String)"m", (String)resultSet.getString(1).trim());
        ScrollCursors1Test.assertEquals((int)13, (int)resultSet.getInt(2));
        ScrollCursors1Test.assertEquals((int)12, (int)resultSet.getRow());
        resultSet.previous();
        ScrollCursors1Test.assertEquals((String)"l", (String)resultSet.getString(1).trim());
        ScrollCursors1Test.assertEquals((int)12, (int)resultSet.getInt(2));
        ScrollCursors1Test.assertEquals((int)11, (int)resultSet.getRow());
        resultSet.last();
        ScrollCursors1Test.assertEquals((String)"m", (String)resultSet.getString(1).trim());
        ScrollCursors1Test.assertEquals((int)13, (int)resultSet.getInt(2));
        ScrollCursors1Test.assertEquals((int)12, (int)resultSet.getRow());
        resultSet.beforeFirst();
        this.assertNoCurrentRow(resultSet);
        ScrollCursors1Test.assertEquals((int)0, (int)resultSet.getRow());
        resultSet.next();
        ScrollCursors1Test.assertEquals((String)"b", (String)resultSet.getString(1).trim());
        ScrollCursors1Test.assertEquals((int)2, (int)resultSet.getInt(2));
        ScrollCursors1Test.assertEquals((int)1, (int)resultSet.getRow());
        resultSet.absolute(12);
        ScrollCursors1Test.assertEquals((String)"m", (String)resultSet.getString(1).trim());
        ScrollCursors1Test.assertEquals((int)13, (int)resultSet.getInt(2));
        ScrollCursors1Test.assertEquals((int)12, (int)resultSet.getRow());
        resultSet.absolute(-11);
        ScrollCursors1Test.assertEquals((String)"c", (String)resultSet.getString(1).trim());
        ScrollCursors1Test.assertEquals((int)3, (int)resultSet.getInt(2));
        ScrollCursors1Test.assertEquals((int)2, (int)resultSet.getRow());
        resultSet.absolute(13);
        this.assertNoCurrentRow(resultSet);
        ScrollCursors1Test.assertEquals((int)0, (int)resultSet.getRow());
        resultSet.absolute(-1);
        ScrollCursors1Test.assertEquals((String)"m", (String)resultSet.getString(1).trim());
        ScrollCursors1Test.assertEquals((int)13, (int)resultSet.getInt(2));
        ScrollCursors1Test.assertEquals((int)12, (int)resultSet.getRow());
        resultSet.close();
        resultSet = preparedStatement.executeQuery();
        resultSet.last();
        ScrollCursors1Test.assertEquals((String)"m", (String)resultSet.getString(1).trim());
        ScrollCursors1Test.assertEquals((int)13, (int)resultSet.getInt(2));
        ScrollCursors1Test.assertEquals((int)12, (int)resultSet.getRow());
        ScrollCursors1Test.assertFalse((boolean)resultSet.next());
        this.assertNoCurrentRow(resultSet);
        resultSet.last();
        ScrollCursors1Test.assertEquals((String)"m", (String)resultSet.getString(1).trim());
        ScrollCursors1Test.assertEquals((int)13, (int)resultSet.getInt(2));
        ScrollCursors1Test.assertEquals((int)12, (int)resultSet.getRow());
        resultSet.previous();
        ScrollCursors1Test.assertEquals((String)"l", (String)resultSet.getString(1).trim());
        ScrollCursors1Test.assertEquals((int)12, (int)resultSet.getInt(2));
        ScrollCursors1Test.assertEquals((int)11, (int)resultSet.getRow());
        resultSet.first();
        ScrollCursors1Test.assertEquals((String)"b", (String)resultSet.getString(1).trim());
        ScrollCursors1Test.assertEquals((int)2, (int)resultSet.getInt(2));
        ScrollCursors1Test.assertEquals((int)1, (int)resultSet.getRow());
        resultSet.previous();
        this.assertNoCurrentRow(resultSet);
        resultSet.next();
        ScrollCursors1Test.assertEquals((String)"b", (String)resultSet.getString(1).trim());
        ScrollCursors1Test.assertEquals((int)2, (int)resultSet.getInt(2));
        ScrollCursors1Test.assertEquals((int)1, (int)resultSet.getRow());
        resultSet.close();
        resultSet = preparedStatement.executeQuery();
        resultSet.afterLast();
        this.assertNoCurrentRow(resultSet);
        resultSet.previous();
        ScrollCursors1Test.assertEquals((String)"m", (String)resultSet.getString(1).trim());
        ScrollCursors1Test.assertEquals((int)13, (int)resultSet.getInt(2));
        ScrollCursors1Test.assertEquals((int)12, (int)resultSet.getRow());
        resultSet.previous();
        ScrollCursors1Test.assertEquals((String)"l", (String)resultSet.getString(1).trim());
        ScrollCursors1Test.assertEquals((int)12, (int)resultSet.getInt(2));
        ScrollCursors1Test.assertEquals((int)11, (int)resultSet.getRow());
        resultSet.close();
        preparedStatement.close();
        preparedStatement = connection.prepareStatement("select * from t1 where i >=11", 1004, 1007);
        resultSet = preparedStatement.executeQuery();
        resultSet.next();
        ScrollCursors1Test.assertEquals((String)"k", (String)resultSet.getString(1).trim());
        ScrollCursors1Test.assertEquals((int)11, (int)resultSet.getInt(2));
        ScrollCursors1Test.assertEquals((int)1, (int)resultSet.getRow());
        resultSet.next();
        ScrollCursors1Test.assertEquals((String)"l", (String)resultSet.getString(1).trim());
        ScrollCursors1Test.assertEquals((int)12, (int)resultSet.getInt(2));
        ScrollCursors1Test.assertEquals((int)2, (int)resultSet.getRow());
        resultSet.last();
        ScrollCursors1Test.assertEquals((String)"m", (String)resultSet.getString(1).trim());
        ScrollCursors1Test.assertEquals((int)13, (int)resultSet.getInt(2));
        ScrollCursors1Test.assertEquals((int)3, (int)resultSet.getRow());
        resultSet.previous();
        ScrollCursors1Test.assertEquals((String)"l", (String)resultSet.getString(1).trim());
        ScrollCursors1Test.assertEquals((int)12, (int)resultSet.getInt(2));
        ScrollCursors1Test.assertEquals((int)2, (int)resultSet.getRow());
        resultSet.afterLast();
        this.assertNoCurrentRow(resultSet);
        resultSet.previous();
        ScrollCursors1Test.assertEquals((String)"m", (String)resultSet.getString(1).trim());
        ScrollCursors1Test.assertEquals((int)13, (int)resultSet.getInt(2));
        ScrollCursors1Test.assertEquals((int)3, (int)resultSet.getRow());
        resultSet.close();
        resultSet = preparedStatement.executeQuery();
        resultSet.afterLast();
        this.assertNoCurrentRow(resultSet);
        resultSet.previous();
        ScrollCursors1Test.assertEquals((String)"m", (String)resultSet.getString(1).trim());
        ScrollCursors1Test.assertEquals((int)13, (int)resultSet.getInt(2));
        ScrollCursors1Test.assertEquals((int)3, (int)resultSet.getRow());
        resultSet.close();
        preparedStatement.close();
        preparedStatement = connection.prepareStatement("select i from t1", 1004, 1007);
        resultSet = preparedStatement.executeQuery();
        resultSet.absolute(5);
        ScrollCursors1Test.assertEquals((int)6, (int)resultSet.getInt(1));
        ScrollCursors1Test.assertEquals((int)5, (int)resultSet.getRow());
        resultSet.absolute(-5);
        ScrollCursors1Test.assertEquals((int)9, (int)resultSet.getInt(1));
        ScrollCursors1Test.assertEquals((int)8, (int)resultSet.getRow());
        resultSet.absolute(5);
        ScrollCursors1Test.assertEquals((int)6, (int)resultSet.getInt(1));
        ScrollCursors1Test.assertEquals((int)5, (int)resultSet.getRow());
        resultSet.close();
        resultSet = preparedStatement.executeQuery();
        resultSet.absolute(13);
        this.assertNoCurrentRow(resultSet);
        resultSet.previous();
        ScrollCursors1Test.assertEquals((int)13, (int)resultSet.getInt(1));
        ScrollCursors1Test.assertEquals((int)12, (int)resultSet.getRow());
        resultSet.close();
        resultSet = preparedStatement.executeQuery();
        resultSet.absolute(-13);
        this.assertNoCurrentRow(resultSet);
        resultSet.next();
        ScrollCursors1Test.assertEquals((int)2, (int)resultSet.getInt(1));
        ScrollCursors1Test.assertEquals((int)1, (int)resultSet.getRow());
        resultSet.close();
        resultSet = preparedStatement.executeQuery();
        resultSet.first();
        ScrollCursors1Test.assertEquals((int)2, (int)resultSet.getInt(1));
        ScrollCursors1Test.assertEquals((int)1, (int)resultSet.getRow());
        resultSet.relative(11);
        ScrollCursors1Test.assertEquals((int)13, (int)resultSet.getInt(1));
        ScrollCursors1Test.assertEquals((int)12, (int)resultSet.getRow());
        resultSet.relative(1);
        this.assertNoCurrentRow(resultSet);
        resultSet.last();
        ScrollCursors1Test.assertEquals((int)13, (int)resultSet.getInt(1));
        ScrollCursors1Test.assertEquals((int)12, (int)resultSet.getRow());
        resultSet.relative(-11);
        ScrollCursors1Test.assertEquals((int)2, (int)resultSet.getInt(1));
        ScrollCursors1Test.assertEquals((int)1, (int)resultSet.getRow());
        resultSet.close();
        preparedStatement.close();
        connection.commit();
        preparedStatement = connection.prepareStatement("Select i from t1", 1005, 1007);
        resultSet = preparedStatement.executeQuery();
        resultSet.first();
        ScrollCursors1Test.assertEquals((int)2, (int)resultSet.getInt(1));
        resultSet.next();
        ScrollCursors1Test.assertEquals((int)3, (int)resultSet.getInt(1));
        Statement statement = connection.createStatement();
        statement.executeUpdate("update t1 set i = 666 where i = 2");
        resultSet.first();
        connection.rollback();
        resultSet.close();
        preparedStatement = connection.prepareStatement("select i from t1", 1004, 1007);
        resultSet = preparedStatement.executeQuery();
        PreparedStatement preparedStatement2 = connection.prepareStatement("select i from t1");
        ResultSet resultSet2 = preparedStatement2.executeQuery();
        resultSet.first();
        ScrollCursors1Test.assertEquals((int)2, (int)resultSet.getInt(1));
        resultSet2.next();
        ScrollCursors1Test.assertEquals((int)2, (int)resultSet2.getInt(1));
        try {
            resultSet2.first();
            ScrollCursors1Test.fail((String)"first() not allowed on forward only result set");
        }
        catch (SQLException sQLException) {
            if (ScrollCursors1Test.usingEmbedded()) {
                ScrollCursors1Test.assertSQLState("XJ061", sQLException);
            }
            ScrollCursors1Test.assertSQLState("XJ125", sQLException);
        }
        resultSet.close();
        resultSet2.close();
        preparedStatement.close();
        preparedStatement.close();
        preparedStatement = connection.prepareStatement("select i from t1 where 1=0", 1004, 1007);
        resultSet = preparedStatement.executeQuery();
        resultSet.first();
        this.assertNoCurrentRow(resultSet);
        resultSet.previous();
        this.assertNoCurrentRow(resultSet);
        resultSet.next();
        this.assertNoCurrentRow(resultSet);
        resultSet.last();
        this.assertNoCurrentRow(resultSet);
        resultSet.previous();
        this.assertNoCurrentRow(resultSet);
        resultSet.absolute(1);
        this.assertNoCurrentRow(resultSet);
        resultSet.absolute(-1);
        this.assertNoCurrentRow(resultSet);
        ScrollCursors1Test.assertEquals((int)0, (int)resultSet.getRow());
        resultSet.close();
        resultSet = preparedStatement.executeQuery();
        resultSet.afterLast();
        this.assertNoCurrentRow(resultSet);
        resultSet.previous();
        this.assertNoCurrentRow(resultSet);
        resultSet.beforeFirst();
        this.assertNoCurrentRow(resultSet);
        resultSet.next();
        this.assertNoCurrentRow(resultSet);
        resultSet.close();
        resultSet = preparedStatement.executeQuery();
        resultSet.absolute(1);
        this.assertNoCurrentRow(resultSet);
        resultSet.absolute(-1);
        this.assertNoCurrentRow(resultSet);
        resultSet.close();
        resultSet = preparedStatement.executeQuery();
        resultSet.absolute(-1);
        this.assertNoCurrentRow(resultSet);
        resultSet.absolute(1);
        this.assertNoCurrentRow(resultSet);
        resultSet.close();
        connection.setAutoCommit(false);
        resultSet = preparedStatement.executeQuery();
        resultSet = preparedStatement.executeQuery();
        resultSet.first();
        this.assertNoCurrentRow(resultSet);
        resultSet.previous();
        this.assertNoCurrentRow(resultSet);
        resultSet.next();
        this.assertNoCurrentRow(resultSet);
        resultSet.last();
        this.assertNoCurrentRow(resultSet);
        resultSet.previous();
        this.assertNoCurrentRow(resultSet);
        resultSet.absolute(1);
        this.assertNoCurrentRow(resultSet);
        resultSet.absolute(-1);
        this.assertNoCurrentRow(resultSet);
        resultSet.next();
        this.assertNoCurrentRow(resultSet);
        resultSet.next();
        this.assertNoCurrentRow(resultSet);
        resultSet.close();
        preparedStatement.close();
        preparedStatement = connection.prepareStatement("select * from t1 order by i desc", 1004, 1007);
        resultSet = preparedStatement.executeQuery();
        resultSet.last();
        ScrollCursors1Test.assertEquals((String)"b", (String)resultSet.getString(1).trim());
        ScrollCursors1Test.assertEquals((int)2, (int)resultSet.getInt(2));
        resultSet.first();
        ScrollCursors1Test.assertEquals((String)"m", (String)resultSet.getString(1).trim());
        ScrollCursors1Test.assertEquals((int)13, (int)resultSet.getInt(2));
        resultSet.relative(11);
        ScrollCursors1Test.assertEquals((String)"b", (String)resultSet.getString(1).trim());
        ScrollCursors1Test.assertEquals((int)2, (int)resultSet.getInt(2));
        resultSet.previous();
        ScrollCursors1Test.assertEquals((String)"c", (String)resultSet.getString(1).trim());
        ScrollCursors1Test.assertEquals((int)3, (int)resultSet.getInt(2));
        resultSet.close();
        preparedStatement.close();
        preparedStatement = connection.prepareStatement("select * from t1", 1004, 1007);
        CallableStatement callableStatement = connection.prepareCall("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        callableStatement.execute();
        callableStatement.close();
        resultSet = preparedStatement.executeQuery();
        resultSet.last();
        ScrollCursors1Test.assertEquals((String)"m", (String)resultSet.getString(1).trim());
        ScrollCursors1Test.assertEquals((int)13, (int)resultSet.getInt(2));
        resultSet.first();
        ScrollCursors1Test.assertEquals((String)"b", (String)resultSet.getString(1).trim());
        ScrollCursors1Test.assertEquals((int)2, (int)resultSet.getInt(2));
        resultSet.next();
        ScrollCursors1Test.assertEquals((String)"c", (String)resultSet.getString(1).trim());
        ScrollCursors1Test.assertEquals((int)3, (int)resultSet.getInt(2));
        resultSet.close();
        resultSet2 = statement.executeQuery("values SYSCS_UTIL.SYSCS_GET_RUNTIMESTATISTICS()");
        resultSet2.next();
        if (ScrollCursors1Test.usingEmbedded()) {
            RuntimeStatisticsParser runtimeStatisticsParser = new RuntimeStatisticsParser(resultSet2.getString(1));
            resultSet2.close();
            ScrollCursors1Test.assertEquals((int)2, (int)runtimeStatisticsParser.getIsolationLevel());
            ScrollCursors1Test.assertTrue((boolean)runtimeStatisticsParser.usedTableScan());
            ScrollCursors1Test.assertTrue((boolean)runtimeStatisticsParser.isScrollInsensitive());
        }
        resultSet.close();
        preparedStatement.close();
    }

    public void testNoHoldScrollableResults() throws SQLException {
        Connection connection = this.getConnection();
        connection.setHoldability(2);
        Statement statement = this.createStatement();
        statement.executeUpdate("create table big(a int generated always as identity (start with 1, increment by 1))");
        for (int i = 0; i < 10; ++i) {
            statement.executeUpdate("insert into big values(default)");
        }
        PreparedStatement preparedStatement = connection.prepareStatement("select * from big b1 left outer join  big b2 on b1.a = b2.a left outer join  big b3 on b2.a = b3.a left outer join big b4 on b3.a = b4.a left outer join (big b5 left outer join (big b6 left outer join (big b7 left outer join big b8 on b7.a = b8.a) on b6.a=b7.a) on b5.a = b6.a) on b4.a = b5.a");
        ResultSet resultSet = preparedStatement.executeQuery();
        statement.executeUpdate("drop table big");
    }

    public void testSimpleScrollCursors() throws SQLException {
        Connection connection = this.getConnection();
        Statement statement = connection.createStatement();
        statement.executeUpdate("create table t (a int)");
        PreparedStatement preparedStatement = connection.prepareStatement("insert into t values (?)");
        for (int i = 1; i <= 5; ++i) {
            preparedStatement.setInt(1, i);
            preparedStatement.executeUpdate();
        }
        preparedStatement.close();
        PreparedStatement preparedStatement2 = connection.prepareStatement("select * from t", 1004, 1007);
        ResultSet resultSet = preparedStatement2.executeQuery();
        resultSet.first();
        ScrollCursors1Test.assertEquals((int)1, (int)resultSet.getInt(1));
        resultSet.next();
        ScrollCursors1Test.assertEquals((int)2, (int)resultSet.getInt(1));
        resultSet.previous();
        ScrollCursors1Test.assertEquals((int)1, (int)resultSet.getInt(1));
        resultSet.last();
        ScrollCursors1Test.assertEquals((int)5, (int)resultSet.getInt(1));
        resultSet.absolute(2);
        ScrollCursors1Test.assertEquals((int)2, (int)resultSet.getInt(1));
        resultSet.relative(2);
        ScrollCursors1Test.assertEquals((int)4, (int)resultSet.getInt(1));
        resultSet.close();
        resultSet = preparedStatement2.executeQuery();
        resultSet.next();
        ScrollCursors1Test.assertEquals((int)1, (int)resultSet.getInt(1));
        resultSet.close();
        resultSet = preparedStatement2.executeQuery();
        resultSet.last();
        ScrollCursors1Test.assertEquals((int)5, (int)resultSet.getInt(1));
        resultSet.close();
        resultSet = preparedStatement2.executeQuery();
        resultSet.absolute(3);
        ScrollCursors1Test.assertEquals((int)3, (int)resultSet.getInt(1));
        resultSet.next();
        ScrollCursors1Test.assertEquals((int)4, (int)resultSet.getInt(1));
        resultSet.close();
        preparedStatement2.close();
        statement.executeUpdate("create table tab1 (a int)");
        PreparedStatement preparedStatement3 = connection.prepareStatement("insert into tab1 values (?)");
        for (int i = 1; i <= 70; ++i) {
            preparedStatement3.setInt(1, i);
            preparedStatement3.executeUpdate();
        }
        preparedStatement2 = connection.prepareStatement("select * from tab1", 1004, 1007);
        resultSet = preparedStatement2.executeQuery();
        resultSet.first();
        ScrollCursors1Test.assertEquals((int)1, (int)resultSet.getInt(1));
        resultSet.last();
        ScrollCursors1Test.assertEquals((int)70, (int)resultSet.getInt(1));
        resultSet.absolute(65);
        ScrollCursors1Test.assertEquals((int)65, (int)resultSet.getInt(1));
        resultSet.absolute(-1);
        ScrollCursors1Test.assertEquals((int)70, (int)resultSet.getInt(1));
        resultSet.close();
        preparedStatement2.close();
        preparedStatement2 = connection.prepareStatement("select * from t1", 1005, 1007);
        resultSet = preparedStatement2.executeQuery();
        resultSet.close();
        preparedStatement2.close();
        preparedStatement2 = connection.prepareStatement("select * from t1 for update", 1005, 1008);
        resultSet.close();
        statement.executeUpdate("drop table tab1");
        statement.executeUpdate("create table tab1(i1 bigint not null, c1 varchar(64) not null)");
        statement.executeUpdate("create table tab2 (i2 bigint not null, c2 varchar(64) not null)");
        statement.executeUpdate("insert into tab1 values (1, 'String 1')");
        statement.executeUpdate("insert into tab1 values (2, 'String 2')");
        statement.executeUpdate("insert into tab2 values (1, 'String 1')");
        statement.executeUpdate("insert into tab2 values (3, 'String 3')");
        resultSet = statement.executeQuery("select c1 from tab1 right outer join tab2 on (i1=i2)");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"String 1"}, {null}});
        resultSet = statement.executeQuery("select c2 from tab1 right outer join tab2 on (i1=i2)");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"String 1"}, {"String 3"}});
        resultSet = statement.executeQuery("select c1 from tab1 left outer join tab2 on (i1=i2)");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"String 1"}, {"String 2"}});
        resultSet = statement.executeQuery("select c2 from tab1 left outer join tab2 on (i1=i2)");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"String 1"}, {null}});
        statement.executeUpdate("drop table t");
        statement.executeUpdate("drop table tab1");
        statement.executeUpdate("drop table tab2");
    }

    public void testScrollCursors3() throws SQLException {
        Connection connection = this.getConnection();
        Connection connection2 = this.openDefaultConnection();
        Statement statement = connection.createStatement();
        statement.executeUpdate("create table u1.t1(c1 int, c2 int)");
        statement.executeUpdate("insert into u1.t1 values (1, 2), (3, 4), (5, 6), (7, 8), (9, 10)");
        PreparedStatement preparedStatement = connection.prepareStatement("select * from u1.t1", 1004, 1007);
        ResultSet resultSet = preparedStatement.executeQuery();
        PreparedStatement preparedStatement2 = connection2.prepareStatement("select * from u1.t1", 1004, 1007);
        ResultSet resultSet2 = preparedStatement2.executeQuery();
        resultSet.next();
        ScrollCursors1Test.assertEquals((int)1, (int)resultSet.getInt(1));
        ScrollCursors1Test.assertEquals((int)2, (int)resultSet.getInt(2));
        resultSet2.next();
        ScrollCursors1Test.assertEquals((int)1, (int)resultSet.getInt(1));
        ScrollCursors1Test.assertEquals((int)2, (int)resultSet.getInt(2));
        resultSet.last();
        ScrollCursors1Test.assertEquals((int)9, (int)resultSet.getInt(1));
        ScrollCursors1Test.assertEquals((int)10, (int)resultSet.getInt(2));
        resultSet2.last();
        ScrollCursors1Test.assertEquals((int)9, (int)resultSet.getInt(1));
        ScrollCursors1Test.assertEquals((int)10, (int)resultSet.getInt(2));
        resultSet.previous();
        ScrollCursors1Test.assertEquals((int)7, (int)resultSet.getInt(1));
        ScrollCursors1Test.assertEquals((int)8, (int)resultSet.getInt(2));
        resultSet2.close();
        resultSet.first();
        ScrollCursors1Test.assertEquals((int)1, (int)resultSet.getInt(1));
        ScrollCursors1Test.assertEquals((int)2, (int)resultSet.getInt(2));
        resultSet.close();
        statement.executeUpdate("drop table u1.t1");
    }

    private void assertNoCurrentRow(ResultSet resultSet) throws SQLException {
        try {
            resultSet.getString(1);
            ScrollCursors1Test.fail((String)"getString not allowed after beforeFirst()");
        }
        catch (SQLException sQLException) {
            if (ScrollCursors1Test.usingEmbedded()) {
                ScrollCursors1Test.assertSQLState("24000", sQLException);
            }
            ScrollCursors1Test.assertSQLState("XJ121", sQLException);
        }
        ScrollCursors1Test.assertEquals((int)0, (int)resultSet.getRow());
    }

    public static Test baseSuite(String string) {
        BaseTestSuite baseTestSuite = new BaseTestSuite(string);
        baseTestSuite.addTestSuite(ScrollCursors1Test.class);
        return new CleanDatabaseTestSetup((Test)baseTestSuite){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                statement.executeUpdate("create table t1(c50 char(50), i int)");
                statement.executeUpdate(" create table t2(c50 char(50), i int)");
                statement.executeUpdate("insert into t1 values ('b', 2), ('c', 3), ('d', 4), ('e', 5),                   ('f', 6), ('g', 7), ('h', 8), ('i', 9),                   ('j', 10), ('k', 11), ('l', 12), ('m', 13)");
            }
        };
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("ScrollCursors1");
        baseTestSuite.addTest(ScrollCursors1Test.baseSuite("ScrollCursors1:embedded"));
        baseTestSuite.addTest(TestConfiguration.clientServerDecorator(ScrollCursors1Test.baseSuite("ScrollCursors1:client")));
        return baseTestSuite;
    }
}

