/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.lang.GeneratedColumnsHelper;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class UserLobTest
extends GeneratedColumnsHelper {
    public UserLobTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = (BaseTestSuite)TestConfiguration.embeddedSuite(UserLobTest.class);
        CleanDatabaseTestSetup cleanDatabaseTestSetup = new CleanDatabaseTestSetup((Test)baseTestSuite);
        return cleanDatabaseTestSetup;
    }

    public void test_001_casts() throws Exception {
        Connection connection = this.getConnection();
        this.goodStatement(connection, "create function f_2201_blob_1\n(\n\ta_0 varchar( 10 )\n)\nreturns blob\nlanguage java\nparameter style java\nno sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.AnsiSignatures.blob_Blob_String'\n");
        this.goodStatement(connection, "create function f_2201_clob_1\n(\n\ta_0 varchar( 10 )\n)\nreturns clob\nlanguage java\nparameter style java\nno sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.AnsiSignatures.clob_Clob_String'\n");
        this.goodStatement(connection, "create table t_2201_clob_blob_1( a clob, b blob )\n");
        this.goodStatement(connection, "create table t_2201_chartypes_1( a char( 10 ), b varchar( 10 ), c long varchar )\n");
        this.goodStatement(connection, "insert into t_2201_clob_blob_1( a, b ) values( f_2201_clob_1( 'abc' ), f_2201_blob_1( 'abc' ) )\n");
        this.goodStatement(connection, "insert into t_2201_chartypes_1( a, b, c )\nvalues\n(\n  cast( f_2201_clob_1( 'abc' ) as char( 10)),\n  cast( f_2201_clob_1( 'def' ) as varchar( 10)),\n  cast( f_2201_clob_1( 'ghi' ) as long varchar )\n)\n");
        this.assertResults(connection, "select * from t_2201_clob_blob_1", new String[][]{{"abc", "616263"}}, false);
        this.assertResults(connection, "select * from t_2201_chartypes_1", new String[][]{{"abc       ", "def", "ghi"}}, false);
        this.assertResults(connection, "select length( a ), length( b ), length( c ) from t_2201_chartypes_1", new String[][]{{"10", "3", "3"}}, false);
        this.assertResults(connection, "values\n(\n  length( cast( f_2201_clob_1( 'abc' ) as char( 10)) ),\n  length( cast( f_2201_clob_1( 'defg' ) as varchar( 10)) ),\n  length( cast( f_2201_clob_1( 'hijkl' ) as long varchar ) ),\n  length( f_2201_clob_1( 'mnopqr' ) )\n)\n", new String[][]{{"10", "4", "5", "6"}}, false);
        this.assertResults(connection, "select length( a ), length( b ) from t_2201_clob_blob_1", new String[][]{{"3", "3"}}, false);
        this.assertResults(connection, "values ( varchar( f_2201_clob_1( 'abc' ) ) )", new String[][]{{"abc"}}, false);
        this.assertResults(connection, "values ( substr( f_2201_clob_1( 'abc' ), 2, 2 ), upper( f_2201_clob_1( 'defg' ) ) )", new String[][]{{"bc", "DEFG"}}, false);
    }
}

