/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.largedata;

import java.io.InputStream;
import java.io.Reader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.tools.ImportExportBaseTest;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetReader;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetStream;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.SupportFilesSetup;

public class Derby6884Test
extends ImportExportBaseTest {
    String fileName6884 = SupportFilesSetup.getReadWrite("table-data").getPath();
    String lobFile6884 = SupportFilesSetup.getReadWrite("lob-data").getPath();

    public Derby6884Test(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("Derby6884Test");
        baseTestSuite.addTest(Derby6884Test.baseSuite("Derby6884Test:embedded"));
        return baseTestSuite;
    }

    public void testDerby6884ImportLargeExtfileClob() throws SQLException {
        LoopingAlphabetReader loopingAlphabetReader;
        Statement statement = this.createStatement();
        PreparedStatement preparedStatement = this.prepareStatement("insert into DERBY_6884_TESTCLOB values(? , ?)");
        int n = 1;
        int n2 = 0;
        for (long i = 0L; i < Integer.MAX_VALUE; i += (long)n2) {
            preparedStatement.setInt(1, n++);
            n2 = 10240000 + 1024 * n;
            loopingAlphabetReader = new LoopingAlphabetReader(n2);
            preparedStatement.setCharacterStream(2, (Reader)loopingAlphabetReader, n2);
            preparedStatement.executeUpdate();
        }
        preparedStatement.setInt(1, n++);
        loopingAlphabetReader = new LoopingAlphabetReader(n2);
        preparedStatement.setCharacterStream(2, (Reader)loopingAlphabetReader, n2);
        preparedStatement.executeUpdate();
        this.commit();
        this.doExportTableLobsToExtFile("APP", "DERBY_6884_TESTCLOB", this.fileName6884, null, null, null, this.lobFile6884);
        statement.execute("TRUNCATE TABLE DERBY_6884_TESTCLOB");
        this.doImportTableLobsFromExtFile("APP", "DERBY_6884_TESTCLOB", this.fileName6884, null, null, null, 0);
        SupportFilesSetup.deleteFile(this.fileName6884);
        SupportFilesSetup.deleteFile(this.lobFile6884);
    }

    public void testDerby6884ImportLargeExtfileBlob() throws SQLException {
        LoopingAlphabetStream loopingAlphabetStream;
        Statement statement = this.createStatement();
        PreparedStatement preparedStatement = this.prepareStatement("insert into DERBY_6884_TESTBLOB values(? , ?)");
        int n = 1;
        int n2 = 0;
        for (long i = 0L; i < Integer.MAX_VALUE; i += (long)n2) {
            preparedStatement.setInt(1, n++);
            n2 = 51200000 + 1024 * n;
            loopingAlphabetStream = new LoopingAlphabetStream(n2);
            preparedStatement.setBinaryStream(2, (InputStream)loopingAlphabetStream, n2);
            preparedStatement.executeUpdate();
        }
        preparedStatement.setInt(1, n++);
        loopingAlphabetStream = new LoopingAlphabetStream(n2);
        preparedStatement.setBinaryStream(2, (InputStream)loopingAlphabetStream, n2);
        preparedStatement.executeUpdate();
        this.commit();
        this.doExportTableLobsToExtFile("APP", "DERBY_6884_TESTBLOB", this.fileName6884, null, null, null, this.lobFile6884);
        statement.execute("TRUNCATE TABLE DERBY_6884_TESTBLOB");
        this.doImportTableLobsFromExtFile("APP", "DERBY_6884_TESTBLOB", this.fileName6884, null, null, null, 0);
        SupportFilesSetup.deleteFile(this.fileName6884);
        SupportFilesSetup.deleteFile(this.lobFile6884);
    }

    protected static Test baseSuite(String string) {
        BaseTestSuite baseTestSuite = new BaseTestSuite(string);
        baseTestSuite.addTestSuite(Derby6884Test.class);
        Object object = baseTestSuite;
        object = new SupportFilesSetup((Test)object);
        return new CleanDatabaseTestSetup((Test)object){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                Connection connection = statement.getConnection();
                statement.execute("CREATE TABLE DERBY_6884_TESTBLOB(id BIGINT, content BLOB)");
                statement.execute("CREATE TABLE DERBY_6884_TESTCLOB(id BIGINT, content CLOB)");
                connection.commit();
            }
        };
    }
}

