/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.memorydb;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;

public class MemoryDbManager {
    private static final String ATTR_CREATE = ";create=true";
    private static final String JDBC_PREFIX = "jdbc:derby:memory:";
    private static final MemoryDbManager DBM = new MemoryDbManager();
    private final ArrayList<Statement> STATEMENTS = new ArrayList();
    private final ArrayList<Connection> CONNECTIONS = new ArrayList();
    private final ArrayList<String> DATABASES = new ArrayList();

    public static MemoryDbManager getSharedInstance() {
        return DBM;
    }

    public Connection getConnection(String string) throws SQLException {
        String string2 = JDBC_PREFIX + string;
        try {
            DriverManager.getDriver(string2);
        }
        catch (SQLException sQLException) {
            new BaseJDBCTestCase("dummy"){}.getConnection();
        }
        Connection connection = DriverManager.getConnection(string2);
        if (!this.CONNECTIONS.contains(connection)) {
            this.CONNECTIONS.add(connection);
        }
        return connection;
    }

    public Statement createStatement(Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        this.STATEMENTS.add(statement);
        if (!this.CONNECTIONS.contains(connection)) {
            this.CONNECTIONS.add(connection);
        }
        return statement;
    }

    public PreparedStatement prepareStatement(Connection connection, String string) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        this.STATEMENTS.add(preparedStatement);
        if (!this.CONNECTIONS.contains(connection)) {
            this.CONNECTIONS.add(connection);
        }
        return preparedStatement;
    }

    public void dropDatabase(String string) throws SQLException {
        block2: {
            String string2 = JDBC_PREFIX + string + ";drop=true";
            try {
                DriverManager.getConnection(string2);
                BaseJDBCTestCase.fail((String)"Dropping database should raise exception.");
            }
            catch (SQLException sQLException) {
                if (sQLException.getSQLState().equals("08006") || sQLException.getSQLState().equals("XJ004")) break block2;
                BaseJDBCTestCase.assertSQLState("Dropping database failed: (" + sQLException.getSQLState() + ") " + sQLException.getMessage(), "08006", sQLException);
            }
        }
    }

    public Connection createDatabase(String string) throws SQLException {
        return this.createDatabase(string, null, null, null);
    }

    public Connection createDatabase(String string, String string2, String string3, String string4) throws SQLException {
        Connection connection;
        Object object = "";
        if (string3 != null) {
            object = ";user=" + string3;
        }
        if (string4 != null) {
            object = (String)object + ";password=" + string4;
        }
        Object object2 = string;
        if (string2 != null) {
            object2 = (String)object2 + ";" + string2;
        }
        if (!((String)object).equals("")) {
            object2 = (String)object2 + (String)object;
        }
        if (((String)object2).indexOf(ATTR_CREATE) == -1) {
            object2 = (String)object2 + ATTR_CREATE;
        }
        if ((connection = this.getConnection((String)object2)).getWarnings() != null) {
            SQLWarning sQLWarning = connection.getWarnings();
            Object object3 = sQLWarning.getMessage();
            while ((sQLWarning = sQLWarning.getNextWarning()) != null) {
                object3 = (String)object3 + " || " + sQLWarning.getMessage();
            }
            BaseJDBCTestCase.fail((String)("Warning(s) when creating database: " + (String)object3));
        }
        this.DATABASES.add(string + (String)object);
        return connection;
    }

    public void cleanUp() throws SQLException {
        AutoCloseable autoCloseable;
        int n;
        for (n = this.STATEMENTS.size() - 1; n >= 0; --n) {
            autoCloseable = this.STATEMENTS.remove(n);
            autoCloseable.close();
        }
        for (n = this.CONNECTIONS.size() - 1; n >= 0; --n) {
            autoCloseable = this.CONNECTIONS.remove(n);
            try {
                autoCloseable.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            autoCloseable.close();
        }
        for (n = this.DATABASES.size() - 1; n >= 0; --n) {
            this.dropDatabase(this.DATABASES.remove(n));
        }
    }
}

