/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.memorydb;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Random;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.memorydb.ClusMog;
import org.apache.derbyTesting.functionTests.tests.memorydb.ClusMogSQL;
import org.apache.derbyTesting.functionTests.tests.memorydb.GenMog;
import org.apache.derbyTesting.functionTests.tests.memorydb.SampMog;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.TestConfiguration;

public class MogTest
extends BaseJDBCTestCase {
    public MogTest(String string) {
        super(string);
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(MogTest.class);
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testClusMogOnDisk() throws SQLException {
        long l = System.currentTimeMillis();
        this.doTestClusMog(this.getConnection());
        MogTest.println("duration-on-disk: " + (System.currentTimeMillis() - l));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testClusMogInMemory() throws SQLException {
        long l = System.currentTimeMillis();
        Connection connection = this.obtainConnection();
        try {
            this.doTestClusMog(connection);
        }
        finally {
            try {
                connection.rollback();
                connection.close();
            }
            catch (SQLException sQLException) {}
            this.dropInMemoryDb();
        }
        MogTest.println("duration-in-memory: " + (System.currentTimeMillis() - l));
    }

    public void doTestClusMog(Connection connection) throws SQLException {
        Random random = new Random(1241411544935L);
        GenMog genMog = new GenMog(random);
        SampMog sampMog = new SampMog(random);
        ClusMog clusMog = new ClusMog();
        ClusMogSQL clusMogSQL = new ClusMogSQL(connection);
        clusMogSQL.setUnique(random.nextInt());
        MogTest.println(this.getName() + " using random seed: 1241411544935");
        double[] dArray = new double[1920];
        double[] dArray2 = new double[6];
        for (int i = 1; i > 0; --i) {
            genMog.generate();
            int n = 32 * genMog.n;
            int n2 = n + random.nextInt(1920 - n);
            MogTest.println("ns = " + n2);
            sampMog.set(genMog.n, genMog.weight, genMog.mean, genMog.var);
            sampMog.generate(n2, dArray);
            ClusMog.uniform(genMog.n, dArray2, n2, dArray);
            clusMog.cluster(genMog.n, dArray2, n2, dArray);
            clusMogSQL.clusterSQL(genMog.n, dArray2, n2, dArray);
            MogTest.assertEquals((String)"MOG configurations differ, seed=1241411544935", (int)clusMog.n, (int)clusMogSQL.n);
            this.compare(clusMog.n, clusMog.weight, clusMogSQL.weight, 1241411544935L);
            this.compare(clusMog.n, clusMog.mean, clusMogSQL.mean, 1241411544935L);
            this.compare(clusMog.n, clusMog.var, clusMogSQL.var, 1241411544935L);
            ClusMog.random(genMog.n, dArray2, n2, dArray, random);
            clusMog.cluster(genMog.n, dArray2, n2, dArray);
            clusMogSQL.clusterSQL(genMog.n, dArray2, n2, dArray);
            MogTest.assertEquals((String)"MOG configurations differ, seed=1241411544935", (int)clusMog.n, (int)clusMogSQL.n);
            this.compare(clusMog.n, clusMog.weight, clusMogSQL.weight, 1241411544935L);
            this.compare(clusMog.n, clusMog.mean, clusMogSQL.mean, 1241411544935L);
            this.compare(clusMog.n, clusMog.var, clusMogSQL.var, 1241411544935L);
        }
    }

    private void compare(int n, double[] dArray, double[] dArray2, long l) {
        for (int i = 0; i < n; ++i) {
            double d = dArray[i];
            double d2 = dArray2[i];
            double d3 = Math.abs(d - d2);
            double d4 = d3 / (1.0 + Math.abs(d));
            if (!(d4 >= 1.0E-6)) continue;
            MogTest.fail((String)("Error too big;" + d4 + " >= 1.0E-6, seed=" + l));
        }
    }

    private Connection obtainConnection() throws SQLException {
        try {
            if (MogTest.usingDerbyNetClient()) {
                Class.forName("org.apache.derby.jdbc.ClientDriver");
            } else {
                Class.forName("org.apache.derby.jdbc.EmbeddedDriver");
            }
        }
        catch (Exception exception) {
            SQLException sQLException = new SQLException(exception.getMessage());
            sQLException.initCause(exception);
            throw sQLException;
        }
        StringBuffer stringBuffer = this.constructUrl().append(";create=true");
        return DriverManager.getConnection(stringBuffer.toString());
    }

    private void dropInMemoryDb() throws SQLException {
        StringBuffer stringBuffer = this.constructUrl().append(";drop=true");
        try {
            DriverManager.getConnection(stringBuffer.toString());
            MogTest.fail((String)"Dropping database should have raised exception.");
        }
        catch (SQLException sQLException) {
            MogTest.assertSQLState("08006", sQLException);
        }
    }

    private StringBuffer constructUrl() {
        StringBuffer stringBuffer = new StringBuffer("jdbc:derby:");
        if (MogTest.usingEmbedded()) {
            stringBuffer.append("memory:");
        } else {
            stringBuffer.append("//");
            stringBuffer.append(TestConfiguration.getCurrent().getHostName());
            stringBuffer.append(':');
            stringBuffer.append(TestConfiguration.getCurrent().getPort());
            stringBuffer.append('/');
            stringBuffer.append("memory:");
        }
        stringBuffer.append("MogTestDb");
        return stringBuffer;
    }
}

