/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.replicationTests;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.replicationTests.ReplicationRun_Local_3;
import org.apache.derbyTesting.junit.BaseTestSuite;

public class ReplicationRun_Local_3_p5
extends ReplicationRun_Local_3 {
    public ReplicationRun_Local_3_p5(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("ReplicationRun_Local_3_p5 Suite");
        baseTestSuite.addTestSuite(ReplicationRun_Local_3_p5.class);
        return baseTestSuite;
    }

    public void testReplication_Local_3_p5_DERBY_3878() throws Exception {
        this.makeReadyForReplication();
        replicationTest = "org.apache.derbyTesting.functionTests.tests.replicationTests.ReplicationTestRun";
        this.util.DEBUG("replicationTest: " + replicationTest);
        replicationVerify = "org.apache.derbyTesting.functionTests.tests.replicationTests.ReplicationTestRun_Verify";
        this.util.DEBUG("replicationVerify: " + replicationVerify);
        this.runTest(replicationTest, jvmVersion, testClientHost, masterServerHost, masterServerPort, replicatedDb);
        this._killMasterServer();
        this.stopSlave(slaveServerHost, slaveServerPort, slaveDatabasePath, replicatedDb, false);
        this.startServer(masterJvmVersion, derbyMasterVersion, masterServerHost, "0.0.0.0", masterServerPort, masterDbSubPath);
        if (masterServerHost.equalsIgnoreCase("localhost") || localEnv) {
            String string = this.masterURL(replicatedDb);
            Class.forName("org.apache.derby.jdbc.ClientDriver");
            this.util.DEBUG("bootMasterDatabase getConnection(" + string + ")");
            Connection connection = DriverManager.getConnection(string);
            Statement statement = connection.createStatement();
            statement.execute("call syscs_util.syscs_freeze_database()");
            connection.close();
        } else {
            this.runTest(freezeDB, jvmVersion, testClientHost, masterServerHost, masterServerPort, replicatedDb);
        }
        this.initSlave(slaveServerHost, jvmVersion, replicatedDb);
        this.startSlave(jvmVersion, replicatedDb, slaveServerHost, slaveServerPort, slaveServerHost, slaveReplPort, testClientHost);
        this.startMaster(jvmVersion, replicatedDb, masterServerHost, masterServerPort, masterServerHost, slaveServerPort, slaveServerHost, slaveReplPort);
        this.assertSqlStateSlaveConn("XRE08");
        this.failOver(jvmVersion, masterDatabasePath, masterDbSubPath, replicatedDb, masterServerHost, masterServerPort, testClientHost);
        this.connectPing(slaveDatabasePath + FS + slaveDbSubPath + FS + replicatedDb, slaveServerHost, slaveServerPort, testClientHost);
        this.verifySlave();
        this.verifyMaster();
        this.stopServer(jvmVersion, derbyVersion, slaveServerHost, slaveServerPort);
        this.stopServer(jvmVersion, derbyVersion, masterServerHost, masterServerPort);
    }

    private void _killMasterServer() throws ClassNotFoundException, SQLException {
        String string = this.masterURL(replicatedDb);
        Class.forName("org.apache.derby.jdbc.ClientDriver");
        Connection connection = DriverManager.getConnection(string);
        Statement statement = connection.createStatement();
        connection.setAutoCommit(false);
        statement.execute("create procedure kill(in p integer) parameter style java no sql language java external name'java.lang.System.exit'");
        try {
            statement.execute("call kill(0)");
        }
        catch (SQLException sQLException) {
            int n = sQLException.getErrorCode();
            Object object = sQLException.getMessage();
            String string2 = sQLException.getSQLState();
            String string3 = "08006";
            object = n + " " + string2 + " " + (String)object + ". Expected: " + string3;
            if (n == 40000 && string2.equalsIgnoreCase(string3)) {
                this.util.DEBUG("As expected. " + (String)object);
            }
            ReplicationRun_Local_3_p5.assertTrue((String)("kill() failed. " + (String)object), (boolean)false);
        }
    }
}

