/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.tools;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.tools.ImportExportBaseTest;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ImportExportBinaryDataTest
extends ImportExportBaseTest {
    String fileName = SupportFilesSetup.getReadWrite("bin_tab.del").getPath();

    public ImportExportBinaryDataTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite(ImportExportBinaryDataTest.class);
        baseTestSuite.addTest(TestConfiguration.clientServerSuite(ImportExportBinaryDataTest.class));
        Object object = baseTestSuite;
        object = new SupportFilesSetup((Test)object);
        return new CleanDatabaseTestSetup((Test)object){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                statement.execute("CREATE TABLE BIN_TAB (id int,C_BD CHAR(4) FOR BIT DATA,C_VBD VARCHAR(10) FOR BIT DATA, C_LVBD LONG VARCHAR FOR BIT DATA)");
                ImportExportBinaryDataTest.loadData(statement);
                statement.execute("CREATE TABLE BIN_TAB_IMP(id int,C_BD CHAR(4) FOR BIT DATA,C_VBD VARCHAR(10) FOR BIT DATA, C_LVBD LONG VARCHAR FOR BIT DATA)");
                statement.execute("CREATE TABLE hex_tab(id int,C1 varchar(20),C2 varchar(20),C3 varchar(20))");
                statement.execute("create table derby_2925_tab(a varchar( 50 ),b varchar( 50 ))");
            }
        };
    }

    protected void setUp() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("DELETE FROM BIN_TAB_IMP");
        statement.close();
    }

    @Override
    protected void tearDown() throws Exception {
        SupportFilesSetup.deleteFile(this.fileName);
        super.tearDown();
    }

    public void testImportTableExportTable() throws SQLException, IOException {
        this.doExportTable("APP", "BIN_TAB", this.fileName, null, null, null);
        this.doImportTable("APP", "BIN_TAB_IMP", this.fileName, null, null, null, 0);
        this.verifyData(" * ");
    }

    public void testDerby4677BulkInsertIntoEmptyTable() throws SQLException {
        Connection connection = this.getConnection();
        Statement statement = connection.createStatement();
        statement.executeUpdate("CREATE TABLE TABLE1(NAME1 INT UNIQUE, name2 int unique not null, name3 int primary key)");
        statement.executeUpdate("INSERT INTO TABLE1 VALUES(1,11,111)");
        String string = SupportFilesSetup.getReadWrite("data_file.dat").getPath();
        this.doExportTable("APP", "TABLE1", string, null, null, "UTF-16");
        statement.executeUpdate("DELETE FROM TABLE1");
        this.commit();
        this.doImportTable("APP", "TABLE1", string, null, null, "UTF-16", 0);
        ImportExportBinaryDataTest.assertStatementError("23505", statement, "INSERT INTO TABLE1 VALUES(1,22,222)");
        ImportExportBinaryDataTest.assertStatementError("23505", statement, "INSERT INTO TABLE1 VALUES(3,11,333)");
        ImportExportBinaryDataTest.assertStatementError("23505", statement, "INSERT INTO TABLE1 VALUES(4,44,111)");
        statement.executeUpdate("DROP TABLE TABLE1");
        SupportFilesSetup.deleteFile(string);
    }

    public void testDerby4677BulkInsertWithReplace() throws SQLException {
        Connection connection = this.getConnection();
        Statement statement = connection.createStatement();
        statement.executeUpdate("CREATE TABLE TABLE1(NAME1 INT UNIQUE, name2 int unique not null, name3 int primary key)");
        String string = SupportFilesSetup.getReadWrite("empty_file.dat").getPath();
        this.doExportTable("APP", "TABLE1", string, null, null, "UTF-16");
        this.commit();
        this.doImportTable("APP", "TABLE1", string, null, null, "UTF-16", 1);
        statement.executeUpdate("INSERT INTO TABLE1 VALUES(1,11,111)");
        ImportExportBinaryDataTest.assertStatementError("23505", statement, "INSERT INTO TABLE1 VALUES(1,22,222)");
        ImportExportBinaryDataTest.assertStatementError("23505", statement, "INSERT INTO TABLE1 VALUES(3,11,333)");
        ImportExportBinaryDataTest.assertStatementError("23505", statement, "INSERT INTO TABLE1 VALUES(4,44,111)");
        statement.executeUpdate("DROP TABLE TABLE1");
        SupportFilesSetup.deleteFile(string);
    }

    public void testImportDataExportQuery() throws SQLException, IOException {
        this.doExportQuery("select * from BIN_TAB", this.fileName, null, null, null);
        this.doImportData(null, "BIN_TAB_IMP", null, null, this.fileName, null, null, null, 0);
        this.verifyData(" * ");
        this.doImportData(null, "BIN_TAB_IMP", "C_LVBD, C_VBD, C_BD, ID", "4, 3, 2, 1", this.fileName, null, null, null, 1);
        this.verifyData("C_LVBD, C_VBD, C_BD, ID");
        SupportFilesSetup.deleteFile(this.fileName);
        this.doExportQuery("select * from BIN_TAB", this.fileName, ";", "%", null);
        this.doImportData(null, "BIN_TAB_IMP", null, null, this.fileName, ";", "%", null, 1);
    }

    public void testImportDataExportQueryWithFewColumns() throws SQLException, IOException {
        this.doExportQuery("select id, c_bd, c_vbd, c_lvbd from BIN_TAB", this.fileName, null, null, null);
        this.doImportData(null, "BIN_TAB_IMP", "ID,C_LVBD", "1 , 4", this.fileName, null, null, null, 0);
        this.verifyData("ID,C_LVBD");
        this.doImportData(null, "BIN_TAB_IMP", "ID, C_LVBD, C_BD", "1, 4, 2", this.fileName, null, null, null, 1);
        this.verifyData("ID, C_LVBD, C_BD");
        this.doImportData(null, "BIN_TAB_IMP", "ID, C_VBD, C_BD", "1, 3, 2", this.fileName, null, null, null, 1);
        this.verifyData("ID, C_VBD, C_BD");
        SupportFilesSetup.deleteFile(this.fileName);
        this.doExportQuery("select id, c_bd, c_vbd, c_lvbd from BIN_TAB", this.fileName, "$", "!", null);
        this.doImportData(null, "BIN_TAB_IMP", "ID,C_LVBD", "1 , 4", this.fileName, "$", "!", null, 0);
    }

    public void testImportExportInvalideDelimiters() throws SQLException, IOException {
        try {
            this.doExportTable("APP", "BIN_TAB", this.fileName, null, "9", null);
            ImportExportBinaryDataTest.fail();
        }
        catch (SQLException sQLException) {
            ImportExportBinaryDataTest.assertSQLState("XIE0J", sQLException);
        }
        SupportFilesSetup.deleteFile(this.fileName);
        try {
            this.doExportQuery("select * from BIN_TAB", this.fileName, "|", "f", null);
            ImportExportBinaryDataTest.fail();
        }
        catch (SQLException sQLException) {
            ImportExportBinaryDataTest.assertSQLState("XIE0J", sQLException);
        }
        SupportFilesSetup.deleteFile(this.fileName);
        try {
            this.doExportTable("APP", "BIN_TAB", this.fileName, "B", null, null);
            ImportExportBinaryDataTest.fail();
        }
        catch (SQLException sQLException) {
            ImportExportBinaryDataTest.assertSQLState("XIE0J", sQLException);
        }
        SupportFilesSetup.deleteFile(this.fileName);
        this.doExportTable("APP", "BIN_TAB", this.fileName, null, null, null);
        try {
            this.doImportTable("APP", "BIN_TAB_IMP", this.fileName, "2", null, null, 0);
            ImportExportBinaryDataTest.fail();
        }
        catch (SQLException sQLException) {
            ImportExportBinaryDataTest.assertSQLState("XIE0J", sQLException);
        }
        try {
            this.doImportData(null, "BIN_TAB_IMP", null, null, this.fileName, null, "c", null, 1);
            ImportExportBinaryDataTest.fail();
        }
        catch (SQLException sQLException) {
            ImportExportBinaryDataTest.assertSQLState("XIE0J", sQLException);
        }
    }

    public void testImportWitgInvalidHexStrings() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("insert into hex_tab values(1, 'A121', '3122A1F20B', 'B1C201DA')");
        statement.executeUpdate("insert into hex_tab values(2, 'A121', '3122A1F20B', 'B1C201A')");
        statement.executeUpdate("insert into hex_tab values(3, '', '3122A1F20Z', 'B1C201DA')");
        statement.executeUpdate("insert into hex_tab values(3, 'A1\"21', '3122A1F20Z', 'B1C201DA')");
        statement.close();
        this.doExportTable("APP", "HEX_TAB", this.fileName, null, null, null);
        try {
            this.doImportTable("APP", "BIN_TAB_IMP", this.fileName, null, null, null, 0);
            ImportExportBinaryDataTest.fail((String)"import did not fail on data with invalid hex string");
        }
        catch (SQLException sQLException) {
            ImportExportBinaryDataTest.assertSQLState("XIE0N", sQLException);
        }
        try {
            this.doImportData(null, "BIN_TAB_IMP", "ID, C_VBD", "1,3", this.fileName, null, null, null, 1);
            ImportExportBinaryDataTest.fail((String)"import did not fail on data with invalid hex strings");
        }
        catch (SQLException sQLException) {
            ImportExportBinaryDataTest.assertSQLState("XIE0N", sQLException);
        }
        try {
            this.doImportData(null, "BIN_TAB_IMP", "ID, C_VBD", "1,2", this.fileName, null, null, null, 1);
            ImportExportBinaryDataTest.fail((String)"import did not fail on data with invalid hex strings");
        }
        catch (SQLException sQLException) {
            ImportExportBinaryDataTest.assertSQLState("XIE0N", sQLException);
        }
    }

    public void testDerby2925ExportTable() throws SQLException {
        this.doExportTable("APP", "DERBY_2925_TAB", this.fileName, null, null, null);
        try {
            this.doExportTable("APP", "DERBY_2925_TAB", this.fileName, null, null, null);
            ImportExportBinaryDataTest.fail((String)"export should have failed on existing data file.");
        }
        catch (SQLException sQLException) {
            ImportExportBinaryDataTest.assertSQLState("XIE0S", sQLException);
        }
        try {
            this.doExportTable("APP", "DERBY_2925_TAB", "file:" + this.fileName, null, null, null);
            ImportExportBinaryDataTest.fail((String)"export should have failed on existing data file.");
        }
        catch (SQLException sQLException) {
            ImportExportBinaryDataTest.assertSQLState("XIE0S", sQLException);
        }
    }

    public void testDerby2925ExportQuery() throws SQLException {
        this.doExportQuery("select * from DERBY_2925_TAB", this.fileName, null, null, null);
        try {
            this.doExportQuery("select * from DERBY_2925_TAB", this.fileName, null, null, null);
            ImportExportBinaryDataTest.fail((String)"exportQuery should have failed on existing data file.");
        }
        catch (SQLException sQLException) {
            ImportExportBinaryDataTest.assertSQLState("XIE0S", sQLException);
        }
    }

    private void verifyData(String string) throws SQLException, IOException {
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT " + string + " FROM BIN_TAB order by id");
        Statement statement2 = this.createStatement();
        ResultSet resultSet2 = statement2.executeQuery("SELECT " + string + " FROM BIN_TAB_IMP order by id");
        JDBC.assertSameContents(resultSet, resultSet2);
        statement.close();
        statement2.close();
    }

    private static void loadData(Statement statement) throws SQLException {
        statement.executeUpdate("insert into bin_tab values (1, X'31', X'3241510B',  X'3743640ADE12337610')");
        statement.executeUpdate("insert into bin_tab values (2, X'33', X'3341610B',  X'3843640ADE12337610')");
        statement.executeUpdate("insert into bin_tab values (4, X'41', X'42',  X'')");
        statement.executeUpdate("insert into bin_tab values (5, X'41', X'', X'42')");
        statement.executeUpdate("insert into bin_tab values (6, X'', X'42',  X'3233445578990122558820')");
        statement.executeUpdate("insert into bin_tab values (7, null, X'3341610B',  X'3843640ADE12337610')");
        statement.executeUpdate("insert into bin_tab values (8,  X'3341610B', null,  X'3843640ADE12337610')");
        statement.executeUpdate("insert into bin_tab values (9,  X'3341610B',  X'3843640ADE' , null)");
        statement.executeUpdate("insert into bin_tab values (10, X'', null,  X'3843640ADE12')");
        statement.executeUpdate("insert into bin_tab values (11, X'66', null,  X'')");
        statement.executeUpdate("insert into bin_tab values (12, X'2C313B09', X'224122',  X'222C23B90A')");
        statement.executeUpdate("insert into bin_tab values (13, X'212C3B24', X'2422412221',   X'212421222C23B90A2124')");
    }
}

