/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.util;

import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import org.apache.derbyTesting.functionTests.util.Formatters;
import org.apache.derbyTesting.functionTests.util.SimpleProcedureTest;

public abstract class ProcedureTest
extends SimpleProcedureTest
implements ResultSet {
    public static void zeroArg() {
        System.out.println("zeroArg() called");
    }

    public static void insertRow(int n) throws SQLException {
        ProcedureTest.insertRow(n, "int");
    }

    public static void insertRow(int n, String string) throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        PreparedStatement preparedStatement = connection.prepareStatement("insert into t1 values (?, ?)");
        preparedStatement.setInt(1, n);
        preparedStatement.setString(2, string);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        connection.close();
    }

    public static void updateRow(int n) throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        PreparedStatement preparedStatement = connection.prepareStatement("update t1 set i=i+?");
        preparedStatement.setInt(1, n);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        connection.close();
    }

    public static void deleteRow(int n) throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        PreparedStatement preparedStatement = connection.prepareStatement("delete from t1 where i=?");
        preparedStatement.setInt(1, n);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        connection.close();
    }

    public static void alterTable() throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        PreparedStatement preparedStatement = connection.prepareStatement("alter table t1 add column test integer");
        preparedStatement.execute();
        preparedStatement.close();
        connection.close();
    }

    public static void dropTable() throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        PreparedStatement preparedStatement = connection.prepareStatement("drop table t1");
        preparedStatement.execute();
        preparedStatement.close();
        connection.close();
    }

    public static void createIndex() throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        PreparedStatement preparedStatement = connection.prepareStatement("create index ix on t1(i,b)");
        preparedStatement.execute();
        preparedStatement.close();
        connection.close();
    }

    public static void dropIndex() throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        PreparedStatement preparedStatement = connection.prepareStatement("drop index ix");
        preparedStatement.execute();
        preparedStatement.close();
        connection.close();
    }

    public static void createTrigger() throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        PreparedStatement preparedStatement = connection.prepareStatement("create trigger test_trig AFTER delete on t1 for each STATEMENT insert into t1 values(20, 'twenty')");
        preparedStatement.execute();
        preparedStatement.close();
        connection.close();
    }

    public static void dropTrigger() throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        PreparedStatement preparedStatement = connection.prepareStatement("drop trigger test_trig");
        preparedStatement.execute();
        preparedStatement.close();
        connection.close();
    }

    public static int selectFromSpecificSchema(int n) throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        PreparedStatement preparedStatement = connection.prepareStatement("select * from mamta1.t12RoutineTest");
        preparedStatement.executeQuery();
        preparedStatement.close();
        connection.close();
        return 1;
    }

    private static void insertInBig(Connection connection, String string, String string2, String string3, String string4) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement("insert into big values (?, ?, ?, ?)");
        preparedStatement.setString(1, string);
        preparedStatement.setString(2, string2);
        preparedStatement.setString(3, string3);
        preparedStatement.setString(4, string4);
        preparedStatement.executeUpdate();
        preparedStatement.close();
    }

    public static void bigTestData(int n) throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        switch (n) {
            case 1: {
                String string = new String(Formatters.repeatChar("a", 10000));
                String string2 = new String(Formatters.repeatChar("b", 10000));
                String string3 = new String(Formatters.repeatChar("c", 10000));
                String string4 = new String(Formatters.repeatChar("d", 10000));
                ProcedureTest.insertInBig(connection, string, string2, string3, string4);
                break;
            }
            case 2: {
                String string = new String(Formatters.repeatChar("e", 10000));
                String string5 = new String(Formatters.repeatChar("f", 10000));
                String string6 = new String(Formatters.repeatChar("g", 10000));
                String string7 = new String(Formatters.repeatChar("h", 10000));
                ProcedureTest.insertInBig(connection, string, string5, string6, string7);
                break;
            }
            case 3: {
                String string = new String(Formatters.repeatChar("i", 10000));
                String string8 = new String(Formatters.repeatChar("j", 10000));
                String string9 = new String(Formatters.repeatChar("k", 10000));
                String string10 = new String(Formatters.repeatChar("l", 10000));
                ProcedureTest.insertInBig(connection, string, string8, string9, string10);
                break;
            }
            case 4: {
                String string = new String(Formatters.repeatChar("m", 10000));
                String string11 = new String(Formatters.repeatChar("n", 10000));
                String string12 = new String(Formatters.repeatChar("o", 10000));
                String string13 = new String(Formatters.repeatChar("p", 10000));
                ProcedureTest.insertInBig(connection, string, string11, string12, string13);
                break;
            }
            case 5: {
                String string = new String(Formatters.repeatChar("a", 30000));
                String string14 = new String(Formatters.repeatChar("b", 2752));
                PreparedStatement preparedStatement = connection.prepareStatement("insert into big values (?, ?)");
                preparedStatement.setString(1, string);
                preparedStatement.setString(2, string14);
                preparedStatement.executeUpdate();
                preparedStatement.close();
                break;
            }
            case 6: {
                String string = new String(Formatters.repeatChar("a", 30000));
                String string15 = new String(Formatters.repeatChar("b", 2750));
                PreparedStatement preparedStatement = connection.prepareStatement("insert into big values (?, ?)");
                preparedStatement.setString(1, string);
                preparedStatement.setString(2, string15);
                preparedStatement.executeUpdate();
                preparedStatement.close();
                break;
            }
            case 7: {
                String string = new String(Formatters.repeatChar("a", 40000));
                PreparedStatement preparedStatement = connection.prepareStatement("insert into big values (?)");
                preparedStatement.setString(1, string);
                preparedStatement.executeUpdate();
                preparedStatement.close();
                break;
            }
            case 8: {
                String string = new String(Formatters.repeatChar("a", 40000));
                String string16 = new String(Formatters.repeatChar("b", 40000));
                String string17 = new String(Formatters.repeatChar("c", 40000));
                PreparedStatement preparedStatement = connection.prepareStatement("insert into big values (?, ?, ?)");
                preparedStatement.setString(1, string);
                preparedStatement.setString(2, string16);
                preparedStatement.setString(3, string17);
                preparedStatement.executeUpdate();
                string = new String(Formatters.repeatChar("d", 40000));
                string16 = new String(Formatters.repeatChar("e", 40000));
                string17 = new String(Formatters.repeatChar("f", 40000));
                preparedStatement.setString(1, string);
                preparedStatement.setString(2, string16);
                preparedStatement.setString(3, string17);
                preparedStatement.executeUpdate();
                preparedStatement.close();
                break;
            }
            case 9: {
                String string = new String(Formatters.repeatChar("a", 32672));
                String string18 = new String(Formatters.repeatChar("b", 32672));
                String string19 = new String(Formatters.repeatChar("c", 32672));
                String string20 = new String(Formatters.repeatChar("d", 32672));
                ProcedureTest.insertInBig(connection, string, string18, string19, string20);
            }
        }
        connection.close();
    }

    public static void selectRows(int n, ResultSet[] resultSetArray) throws SQLException {
        System.out.println("selectRows - 1 arg - 1 rs");
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        PreparedStatement preparedStatement = connection.prepareStatement("select * from t1 where i = ?");
        preparedStatement.setInt(1, n);
        resultSetArray[0] = preparedStatement.executeQuery();
        connection.close();
    }

    public static void selectRows(int n, int n2, ResultSet[] resultSetArray, ResultSet[] resultSetArray2) throws SQLException {
        System.out.println("selectRows - 2 arg - 2 rs");
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        PreparedStatement preparedStatement = connection.prepareStatement("select * from t1 where i = ?");
        preparedStatement.setInt(1, n);
        resultSetArray[0] = preparedStatement.executeQuery();
        preparedStatement = connection.prepareStatement("select * from t1 where i >= ?");
        preparedStatement.setInt(1, n2);
        resultSetArray2[0] = preparedStatement.executeQuery();
        if (n2 == 99) {
            resultSetArray2[0].close();
        }
        if (n2 == 199) {
            resultSetArray[0].close();
            resultSetArray[0] = null;
            resultSetArray2[0].close();
            resultSetArray2[0] = null;
        }
        if (n2 == 299) {
            ResultSet resultSet = resultSetArray[0];
            resultSetArray[0] = resultSetArray2[0];
            resultSetArray2[0] = resultSet;
        }
        connection.close();
    }

    public static void selectRows(String string, ResultSet[] resultSetArray) throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        Statement statement = connection.createStatement();
        resultSetArray[0] = statement.executeQuery("SELECT * FROM " + string);
        connection.close();
    }

    public static void fivejp(ResultSet[] resultSetArray, ResultSet[] resultSetArray2, ResultSet[] resultSetArray3, ResultSet[] resultSetArray4, ResultSet[] resultSetArray5) throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        PreparedStatement preparedStatement = connection.prepareStatement("select * from MRS.FIVERS where i > ?");
        preparedStatement.setInt(1, 1);
        resultSetArray[0] = preparedStatement.executeQuery();
        PreparedStatement preparedStatement2 = connection.prepareStatement("select * from MRS.FIVERS  where i > ?");
        preparedStatement2.setInt(1, 2);
        resultSetArray2[0] = preparedStatement2.executeQuery();
        PreparedStatement preparedStatement3 = connection.prepareStatement("select * from MRS.FIVERS  where i > ?");
        preparedStatement3.setInt(1, 3);
        resultSetArray3[0] = preparedStatement3.executeQuery();
        PreparedStatement preparedStatement4 = connection.prepareStatement("select * from MRS.FIVERS  where i > ?");
        preparedStatement4.setInt(1, 4);
        resultSetArray4[0] = preparedStatement4.executeQuery();
        PreparedStatement preparedStatement5 = connection.prepareStatement("select * from MRS.FIVERS  where i > ?");
        preparedStatement5.setInt(1, 5);
        resultSetArray5[0] = preparedStatement5.executeQuery();
        connection.close();
    }

    public static void parameter1(int n, String string, String string2, ResultSet[] resultSetArray) throws SQLException {
        System.out.print("PT1 a=" + n);
        if (string == null) {
            System.out.println(" b = null");
        } else {
            System.out.print(" b=<" + string + ">(" + string.length() + ")");
        }
        if (string2 == null) {
            System.out.println(" c = null");
        } else {
            System.out.print(" c=<" + string2 + ">(" + string2.length() + ")");
        }
        System.out.println("");
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        PreparedStatement preparedStatement = connection.prepareStatement("insert into PT1 values (?, ?, ?)");
        preparedStatement.setInt(1, n);
        preparedStatement.setString(2, string);
        preparedStatement.setString(3, string2);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        preparedStatement = connection.prepareStatement("select a,b, length(b), c, length(c) from PT1 where a = ?");
        preparedStatement.setInt(1, n);
        resultSetArray[0] = preparedStatement.executeQuery();
        connection.close();
    }

    public static void parameter2(int n, BigDecimal bigDecimal, BigDecimal bigDecimal2, ResultSet[] resultSetArray) throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        PreparedStatement preparedStatement = connection.prepareStatement("insert into PT1 values (?, ?, ?)");
        preparedStatement.setInt(1, n);
        preparedStatement.setString(2, bigDecimal.toString());
        preparedStatement.setString(3, bigDecimal2.toString());
        preparedStatement.executeUpdate();
        preparedStatement.close();
        preparedStatement = connection.prepareStatement("select a,b,c from PT1 where a = ?");
        preparedStatement.setInt(1, n);
        resultSetArray[0] = preparedStatement.executeQuery();
        connection.close();
    }

    public static void outparams1(int[] nArray, int n) {
        nArray[0] = n * 2;
    }

    public static void clobselect(ResultSet[] resultSetArray, ResultSet[] resultSetArray2, ResultSet[] resultSetArray3) throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        PreparedStatement preparedStatement = connection.prepareStatement("select * from lobCheckOne");
        resultSetArray[0] = preparedStatement.executeQuery();
        PreparedStatement preparedStatement2 = connection.prepareStatement("select count(*) from lobCheckOne");
        resultSetArray2[0] = preparedStatement2.executeQuery();
        PreparedStatement preparedStatement3 = connection.prepareStatement("select * from lobCheckOne");
        resultSetArray3[0] = preparedStatement3.executeQuery();
        connection.close();
    }

    public static void blobselect(ResultSet[] resultSetArray) throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        PreparedStatement preparedStatement = connection.prepareStatement("select * from lobCheckTwo");
        resultSetArray[0] = preparedStatement.executeQuery();
        connection.close();
    }

    public static void inoutparams2(int[] nArray, int n) {
        nArray[0] = nArray[0] + n * 2;
    }

    public static void inoutparams3(String[] stringArray, int n) {
        if (stringArray[0] == null) {
            System.out.println("p1 is NULL");
        } else {
            System.out.println("p1= >" + stringArray[0] + "< length " + stringArray[0].length());
        }
        if (n == 8) {
            stringArray[0] = "nad";
        } else if (n == 9) {
            stringArray[0] = null;
        } else if (n == 10) {
            stringArray[0] = "abcdefghijklmnopqrstuvwzyz";
        }
    }

    public static void inoutparams4(BigDecimal[] bigDecimalArray, String string) {
        bigDecimalArray[0] = string == null ? null : (bigDecimalArray[0] == null ? new BigDecimal(string).add(new BigDecimal("17")) : new BigDecimal(string).add(bigDecimalArray[0]));
    }

    public static void ambigious1(int n, String string, ResultSet[] resultSetArray, ResultSet[] resultSetArray2) {
    }

    public static void ambigious1(int n, String string, ResultSet[] resultSetArray) {
    }

    public static void ambigious2(int n, Integer n2) {
        System.out.println("ambigious2(int,Integer) called");
    }

    public static void ambigious2(Integer n, int n2) {
        System.out.println("ambigious2(Integer,int) called");
    }

    public static void missingDynamicParameter(int n) {
    }

    public static void missingDynamicParameter(int n, Object object) {
    }

    public static void badDynamicParameter(int n, ProcedureTest[] procedureTestArray) {
    }

    public static void zeroArgDynamicResult(ResultSet[] resultSetArray, ResultSet[] resultSetArray2, ResultSet[] resultSetArray3, ResultSet[] resultSetArray4) {
        System.out.println("zeroArgDynamicResult called");
    }

    public static void sqlControl(String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, String[] stringArray5, String[] stringArray6, String[] stringArray7) throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        Statement statement = connection.createStatement();
        ProcedureTest.executeStatement(statement, "CREATE TABLE SQLCONTROL_DDL (I INT)", stringArray);
        ProcedureTest.executeStatement(statement, "ALTER TABLE SQLC.SQLCONTROL_DML ADD COLUMN B INT DEFAULT NULL", stringArray2);
        ProcedureTest.executeStatement(statement, "INSERT INTO SQLC.SQLCONTROL_DML(I) VALUES (1)", stringArray3);
        ProcedureTest.executeStatement(statement, "UPDATE SQLC.SQLCONTROL_DML SET I = I + 11", stringArray4);
        ProcedureTest.executeStatement(statement, "SELECT * FROM SQLC.SQLCONTROL_DML", stringArray5);
        ProcedureTest.executeStatement(statement, "DELETE FROM SQLC.SQLCONTROL_DML", stringArray6);
        ProcedureTest.executeStatement(statement, "DROP TABLE SQLC.SQLCONTROL_DML", stringArray7);
        connection.close();
    }

    public static void sqlControl2(String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, String[] stringArray5, String[] stringArray6, String[] stringArray7) throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        Statement statement = connection.createStatement();
        ProcedureTest.executeStatement(statement, "CREATE VIEW SQLCONTROL_VIEW AS SELECT * FROM SQLC.SQLCONTROL_DML", stringArray);
        ProcedureTest.executeStatement(statement, "DROP VIEW SQLCONTROL_VIEW", stringArray2);
        ProcedureTest.executeStatement(statement, "LOCK TABLE SQLC.SQLCONTROL_DML IN EXCLUSIVE MODE", stringArray3);
        ProcedureTest.executeStatement(statement, "VALUES 1,2,3", stringArray4);
        ProcedureTest.executeStatement(statement, "SET SCHEMA SQLC", stringArray5);
        ProcedureTest.executeStatement(statement, "CREATE SCHEMA SQLC_M", stringArray6);
        ProcedureTest.executeStatement(statement, "DROP SCHEMA SQLC_M RESTRICT", stringArray7);
        connection.close();
    }

    public static void sqlControl3(String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, String[] stringArray5, String[] stringArray6, String[] stringArray7) throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        Statement statement = connection.createStatement();
        stringArray[0] = "IBM CS FEATURE";
        stringArray2[0] = "IBM CS FEATURE";
        ProcedureTest.executeStatement(statement, "SET ISOLATION CS", stringArray3);
        ProcedureTest.executeStatement(statement, "SET RUNTIMESTATISTICS OFF", stringArray4);
        ProcedureTest.executeStatement(statement, "SET STATISTICS TIMING OFF", stringArray5);
        ProcedureTest.executeStatement(statement, "VALUES 1", stringArray6);
        ProcedureTest.executeStatement(statement, "VALUES 1", stringArray7);
        connection.close();
    }

    public static void sqlControl4(int n, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, String[] stringArray5, String[] stringArray6, String[] stringArray7, String[] stringArray8) throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        Statement statement = connection.createStatement();
        String string = "CALL SQLC.SQLCONTROL2_" + n + " (?, ?, ?, ?, ?, ?, ?) ";
        stringArray[0] = string;
        CallableStatement callableStatement = connection.prepareCall(string);
        try {
            for (int i = 1; i <= 7; ++i) {
                callableStatement.registerOutParameter(i, 12);
            }
            callableStatement.execute();
            stringArray2[0] = callableStatement.getString(1);
            stringArray3[0] = callableStatement.getString(2);
            stringArray4[0] = callableStatement.getString(3);
            stringArray5[0] = callableStatement.getString(4);
            stringArray6[0] = callableStatement.getString(5);
            stringArray7[0] = callableStatement.getString(6);
            stringArray8[0] = callableStatement.getString(7);
        }
        catch (SQLException sQLException) {
            SQLException sQLException2;
            StringBuffer stringBuffer = new StringBuffer(128);
            stringBuffer.append("STATE");
            do {
                stringBuffer.append("-");
                String string2 = sQLException2.getSQLState();
                if (string2 == null) {
                    string2 = "?????";
                }
                stringBuffer.append(string2);
            } while ((sQLException2 = sQLException2.getNextException()) != null);
            stringArray2[0] = stringBuffer.toString();
        }
        callableStatement.close();
        connection.close();
    }

    private static void executeStatement(Statement statement, String string, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer(128);
        int n = string.length();
        if (n > 15) {
            n = 15;
        }
        stringBuffer.append(string.substring(0, n));
        try {
            if (statement.execute(string)) {
                ResultSet resultSet = statement.getResultSet();
                while (resultSet.next()) {
                    stringBuffer.append("- ROW(" + resultSet.getString(1) + ")");
                }
                resultSet.close();
            } else {
                stringBuffer.append("-UPDATE " + statement.getUpdateCount());
            }
            stringBuffer.append("-EXECUTE OK");
        }
        catch (SQLException sQLException) {
            SQLException sQLException2;
            do {
                stringBuffer.append("-");
                String string2 = sQLException2.getSQLState();
                if (string2 == null) {
                    string2 = "?????";
                }
                stringBuffer.append(string2);
            } while ((sQLException2 = sQLException2.getNextException()) != null);
        }
        stringArray[0] = stringBuffer.toString();
    }

    public static void oBOOLEAN(Boolean bl, Boolean[] booleanArray, Boolean[] booleanArray2) throws SQLException {
        if (booleanArray2[0] != null) {
            throw new SQLException("oBOOLEAN expected out[] to be null");
        }
        booleanArray2[0] = bl;
        booleanArray[0] = bl == null ? null : Boolean.valueOf(booleanArray[0] != false && bl != false);
    }

    public static void pBOOLEAN(boolean bl, boolean[] blArray, boolean[] blArray2) throws SQLException {
        if (blArray2[0]) {
            throw new SQLException("pBOOLEAN expected out[] to be null");
        }
        blArray2[0] = bl;
        blArray[0] = blArray[0] && bl;
    }

    public static void oALLINT(Integer n, Integer[] integerArray, Integer[] integerArray2) throws SQLException {
        if (integerArray2[0] != null) {
            throw new SQLException("oALLINT expected out[] to be null");
        }
        integerArray2[0] = n;
        if (n != null) {
            integerArray[0] = integerArray[0] == null ? Integer.valueOf(3 * n) : Integer.valueOf(integerArray[0] + n);
        }
    }

    public static void pTINYINT(byte by, byte[] byArray, byte[] byArray2) throws SQLException {
        byArray2[0] = by;
        byArray[0] = (byte)(byArray[0] + by);
    }

    public static void pSMALLINT(short s, short[] sArray, short[] sArray2) throws SQLException {
        sArray2[0] = s;
        sArray[0] = (short)(sArray[0] + s);
    }

    public static void literalTest(int n, String[] stringArray) {
        stringArray[0] = ">" + Integer.toString(n) + "<";
    }

    public static void literalTest(long l, String[] stringArray) {
        stringArray[0] = ">" + Long.toString(l) + "<";
    }

    public static void literalTest(float f, String[] stringArray) {
        stringArray[0] = ">" + Float.toString(f) + "<";
    }

    public static void literalTest(double d, String[] stringArray) {
        stringArray[0] = ">" + Double.toString(d) + "<";
    }

    public static void literalTest(BigDecimal bigDecimal, String[] stringArray) {
        String string = bigDecimal == null ? "NULL" : bigDecimal.toString();
        stringArray[0] = ">" + string + "<";
    }

    public static void literalTest(String string, String[] stringArray) {
        String string2 = string == null ? "NULL" : string.toString();
        stringArray[0] = ">" + string2 + "<";
    }

    public static void literalTest(Date date, String[] stringArray) {
        String string = date == null ? "NULL" : date.toString();
        stringArray[0] = ">" + string + "<";
    }

    public static void literalTest(Time time, String[] stringArray) {
        String string = time == null ? "NULL" : time.toString();
        stringArray[0] = ">" + string + "<";
    }

    public static void literalTest(Timestamp timestamp, String[] stringArray) {
        String string = timestamp == null ? "NULL" : timestamp.toString();
        stringArray[0] = ">" + string + "<";
    }

    public static void pmap(BigDecimal bigDecimal, BigDecimal[] bigDecimalArray, BigDecimal[] bigDecimalArray2) {
        bigDecimalArray[0] = bigDecimalArray[0].add(new BigDecimal(2.3));
        bigDecimalArray2[0] = new BigDecimal(84.1);
    }

    public static int countRows(String string, String string2) throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT COUNT(*) FROM " + string + "." + string2);
        resultSet.next();
        int n = resultSet.getInt(1);
        resultSet.close();
        statement.close();
        connection.close();
        return n;
    }

    public static void multiResult(int n, int n2, ResultSet[] resultSetArray, ResultSet[] resultSetArray2) throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        PreparedStatement preparedStatement = connection.prepareStatement("select * from AutoCommitTable where num = ?");
        preparedStatement.setInt(1, n);
        resultSetArray[0] = preparedStatement.executeQuery();
        preparedStatement = connection.prepareStatement("select * from AutoCommitTable where num = ?");
        preparedStatement.setInt(1, n2);
        resultSetArray2[0] = preparedStatement.executeQuery();
        connection.close();
    }

    public static void BIG_COL_491(int n, ResultSet[] resultSetArray, ResultSet[] resultSetArray2) throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        Statement statement = connection.createStatement();
        resultSetArray[0] = statement.executeQuery("select int1, varchar32k from jira491 where int1 < " + n + " order by 1");
        Statement statement2 = connection.createStatement();
        resultSetArray2[0] = statement2.executeQuery("select int1, varchar32k from jira491 where int1 > " + n + " order by 1");
    }

    public static void LOTS_O_COLS_492(ResultSet[] resultSetArray) throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        Statement statement = connection.createStatement();
        StringBuffer stringBuffer = new StringBuffer("SELECT ");
        for (int i = 0; i < 100; ++i) {
            int n = 1000 + i * 10;
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("id AS col").append(n).append(", nsi as col").append(n + 1).append(", ni AS col").append(n + 2).append(", nbi AS col").append(n + 3).append(", nd AS col").append(n + 4).append(", nr AS col").append(n + 5).append(", ndo AS col").append(n + 6).append(" ");
        }
        stringBuffer.append("FROM jira492 a WHERE a.id = 0");
        resultSetArray[0] = statement.executeQuery(stringBuffer.toString());
    }

    public static void grantSelect() throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        PreparedStatement preparedStatement = connection.prepareStatement("grant select on t1 to user2");
        preparedStatement.execute();
        preparedStatement.close();
        connection.close();
    }

    public static void revokeSelect() throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        PreparedStatement preparedStatement = connection.prepareStatement("revoke select on t1 from user2");
        preparedStatement.execute();
        preparedStatement.close();
        connection.close();
    }

    public static void noname(int n, String string) {
        System.out.println("noname(int,String) called");
    }

    public static void noname2(Timestamp timestamp, String string) {
        System.out.println("noname(Timestamp,String) called");
    }
}

