/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.system.mailjdbc.tasks;

import java.sql.Connection;
import org.apache.derbyTesting.system.mailjdbc.MailJdbc;
import org.apache.derbyTesting.system.mailjdbc.tasks.Refresh;
import org.apache.derbyTesting.system.mailjdbc.utils.DbTasks;
import org.apache.derbyTesting.system.mailjdbc.utils.LogFile;
import org.apache.derbyTesting.system.mailjdbc.utils.ThreadUtils;

public class Browse
extends Thread {
    private DbTasks dbtasks = new DbTasks();
    private Connection conn = null;

    public Browse(String string) throws Exception {
        this.setName(string);
        this.conn = DbTasks.getConnection("BROWSE", "Browse");
    }

    @Override
    public void run() {
        try {
            while (true) {
                this.readInbox(this.conn, this.getName());
                this.deleteMailByUser(this.conn, this.getName());
                this.moveToFolders(this.conn, this.getName());
                Thread.sleep(100000L);
                if (ThreadUtils.isThreadRunning("Refresh Thread")) {
                    MailJdbc.logAct.logMsg("******** Refresh is running");
                    continue;
                }
                Refresh refresh = (Refresh)ThreadUtils.getThread("Refresh Thread");
                refresh.interrupt();
            }
        }
        catch (Exception exception) {
            MailJdbc.logAct.logMsg(LogFile.ERROR + "Error while sleeping the thread in Browse: " + exception.getMessage());
            exception.printStackTrace();
            return;
        }
    }

    public void readInbox(Connection connection, String string) throws Exception {
        this.dbtasks.readMail(connection, string);
        this.dbtasks.totals(string);
    }

    public void deleteMailByUser(Connection connection, String string) throws Exception {
        this.dbtasks.deleteMailByUser(connection, string);
    }

    public void moveToFolders(Connection connection, String string) throws Exception {
        this.dbtasks.moveToFolders(connection, string);
    }
}

