/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.system.nstest;

import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import org.apache.derbyTesting.system.nstest.NsTestError;
import org.apache.derbyTesting.system.nstest.NsTestPrintStream;
import org.apache.derbyTesting.system.nstest.TimerThread;
import org.apache.derbyTesting.system.nstest.init.DbSetup;
import org.apache.derbyTesting.system.nstest.init.Initializer;
import org.apache.derbyTesting.system.nstest.init.NWServerThread;
import org.apache.derbyTesting.system.nstest.tester.BackupRestoreReEncryptTester;
import org.apache.derbyTesting.system.nstest.tester.Tester1;
import org.apache.derbyTesting.system.nstest.tester.Tester2;
import org.apache.derbyTesting.system.nstest.tester.Tester3;
import org.apache.derbyTesting.system.nstest.utils.MemCheck;
import org.apache.derbyTesting.system.nstest.utils.SequenceReader;

public class NsTest
extends Thread {
    private static final String BACKUP_FLAG = "derby.nstest.backupRestore";
    private static final String OUTPUT_FILE = "derby.nstest.outputFile";
    private static final String JUST_COUNT_ERRORS = "derby.nstest.justCountErrors";
    private static final String QUIET = "derby.nstest.quiet";
    private static final String DURATION = "derby.nstest.durationInMinutes";
    private static final long MILLIS_PER_MINUTE = 60000L;
    private static final String USAGE = "Usage:\n\n    java org.apache.derbyTesting.system.nstest.NsTest [ DerbyClient | Embedded [ small ] ]\n\nIf no arguments are specified, the test defaults to a client/server configuration (DerbyClient)\n\nThe following flags can be set:\n\n    -Dderby.nstest.backupRestore=false    Turns off backup, restore, and re-encryption.\n\n    -Dderby.nstest.outputFile=fileName    Redirects output and errors to a file.\n\n    -Dderby.nstest.justCountErrors=true    Makes the test run quietly at steady-state, counting errors, and printing a summary at the end.\n\n    -Dderby.nstest.durationInMinutes=$number    Run for this number of minutes.\n";
    private static final String ERROR_BANNER1 = "//////////////////////////////////////////////////////////////\n";
    private static final String ERROR_BANNER2 = "//    ";
    public static final String DEAD_CONNECTION = "08003";
    public static final String dbName = "nstestdb";
    public static final String user = "nstest";
    public static final String password = "nstest";
    public static final String clientURL = "jdbc:derby://localhost:1900/";
    public static final String embedURL = "jdbc:derby:";
    public static final String dataEncypt = "dataEncryption=true";
    public static final String bootPwd = "bootPassword=12345678";
    public static final String clientDbURL = new String("jdbc:derby://localhost:1900/nstestdb;create=true");
    public static final String retrieveMessagePart = "retrieveMessagesFromServerOnGetMessage=true;";
    public static final String embedDbURL = new String("jdbc:derby:nstestdb;create=true");
    public static boolean embeddedMode = false;
    public static final String driver = new String("org.apache.derby.jdbc.ClientDriver");
    public static final String embedDriver = new String("org.apache.derby.jdbc.EmbeddedDriver");
    private static PrintStream statisticsLogger;
    public static NsTestPrintStream logger;
    public static Properties prop;
    public static int INIT;
    public static int TESTER1;
    public static int TESTER2;
    public static int TESTER3;
    public static int BACKUP;
    public static String BACKUPDIR;
    public static String RESTOREDIR;
    public static boolean START_SERVER_IN_SAME_VM;
    public static boolean AUTO_COMMIT_OFF;
    public static boolean CREATE_DATABASE_ONLY;
    public static boolean schemaCreated;
    public static int INIT_THREADS;
    public static int MAX_INITIAL_ROWS;
    public static int MAX_ITERATIONS;
    public static int MAX_LOW_STRESS_ROWS;
    public static int MAX_OPERATIONS_PER_CONN;
    public static int NUMTESTER1;
    public static int NUMTESTER2;
    public static int NUMTESTER3;
    public static int NUM_HIGH_STRESS_ROWS;
    public static int NUM_UNTOUCHED_ROWS;
    public static int numInserts;
    public static int numUpdates;
    public static int numDeletes;
    public static int numSelects;
    public static int numFailedInserts;
    public static int numFailedUpdates;
    public static int numFailedDeletes;
    public static int numFailedSelects;
    public static int numConnections;
    public static int INSERT;
    public static int UPDATE;
    public static int DELETE;
    public static int SELECT;
    public static int FAILED_INSERT;
    public static int FAILED_UPDATE;
    public static int FAILED_DELETE;
    public static int FAILED_SELECT;
    public static int CONNECTIONS_MADE;
    public static final String SUCCESS = " *** SUCCESS *** ";
    public static String driver_type;
    private int type;
    private static NsTest[] testThreads;
    private static boolean _justCountErrors;
    private static HashMap<String, NsTestError> _errors;
    private static long _duration;
    private static boolean _statisticsAlreadyPrinted;
    private static long _maxSequenceCounter;
    private static long _startTimestamp;
    private static long _endTimestamp;
    private static long _totalMemory;
    private static long _freeMemory;
    private static Date _lastMemoryCheckTime;

    public static int numActiveTestThreads() {
        int n = 0;
        if (testThreads != null) {
            for (int i = 0; i < testThreads.length; ++i) {
                if (testThreads[i] == null || !testThreads[i].isAlive()) continue;
                ++n;
            }
        }
        return n;
    }

    public static void updateMemoryTracker(long l, long l2, Date date) {
        _totalMemory = l;
        _freeMemory = l2;
        _lastMemoryCheckTime = date;
    }

    public static void updateSequenceTracker(long l) {
        _maxSequenceCounter = l;
    }

    public static boolean justCountErrors() {
        return _justCountErrors;
    }

    public static synchronized void addError(Throwable throwable) {
        String string = NsTest.getStackTrace(throwable);
        NsTestError nsTestError = _errors.get(string);
        if (nsTestError != null) {
            nsTestError.increment();
        } else {
            nsTestError = new NsTestError(throwable);
            _errors.put(string, nsTestError);
        }
    }

    private static String getStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        printWriter.flush();
        stringWriter.flush();
        return stringWriter.toString();
    }

    public static synchronized void addStats(int n, int n2) {
        switch (n) {
            case 0: {
                numInserts += n2;
                break;
            }
            case 1: {
                numUpdates += n2;
                break;
            }
            case 2: {
                numDeletes += n2;
                break;
            }
            case 3: {
                numSelects += n2;
                break;
            }
            case 4: {
                numFailedInserts += n2;
                break;
            }
            case 5: {
                numFailedUpdates += n2;
                break;
            }
            case 6: {
                numFailedDeletes += n2;
                break;
            }
            case 7: {
                numFailedSelects += n2;
                break;
            }
            case 8: {
                numConnections += n2;
            }
        }
    }

    NsTest(int n, int n2) throws Exception {
        this.type = n;
        if (n == INIT) {
            this.setName("InitThread " + n2);
        } else if (n == TESTER1 || n == TESTER2 || n == TESTER3) {
            this.setName("Thread " + n2);
        }
    }

    private static void setSmallConfig() {
        INIT_THREADS = 3;
        MAX_INITIAL_ROWS = 150;
        MAX_ITERATIONS = 50;
        MAX_LOW_STRESS_ROWS = 10;
        MAX_OPERATIONS_PER_CONN = 10;
        NUMTESTER1 = 3;
        NUMTESTER2 = 4;
        NUMTESTER3 = 3;
        NUM_HIGH_STRESS_ROWS = 20;
        NUM_UNTOUCHED_ROWS = 50;
    }

    public static void main(String[] stringArray) throws SQLException, IOException, InterruptedException, Exception, Throwable {
        int n;
        Object object;
        String string;
        _startTimestamp = System.currentTimeMillis();
        String string2 = System.getProperty(OUTPUT_FILE);
        statisticsLogger = System.out;
        if (string2 != null) {
            statisticsLogger = new PrintStream(string2);
        }
        if ((string = System.getProperty(DURATION)) != null) {
            _duration = Long.parseLong(string) * 60000L;
        }
        logger = new NsTestPrintStream(statisticsLogger, !(_justCountErrors = Boolean.getBoolean(JUST_COUNT_ERRORS)));
        Runtime.getRuntime().addShutdownHook(new Thread(new ShutdownHook()));
        Connection connection = null;
        if (stringArray.length >= 1) {
            driver_type = stringArray[0];
            if (!driver_type.equalsIgnoreCase("DerbyClient") && !driver_type.equalsIgnoreCase("Embedded")) {
                NsTest.printUsage();
                return;
            }
            logger.println("Test nstest starting....., using driver: " + driver_type);
        } else {
            driver_type = "DerbyClient";
        }
        if (stringArray.length >= 2 && ((String)(object = stringArray[1])).equalsIgnoreCase("small")) {
            logger.println("using small config");
            NsTest.setSmallConfig();
        }
        object = null;
        if (_duration > 0L) {
            object = new TimerThread(_duration);
            ((Thread)object).start();
        }
        Object object2 = "";
        try {
            if (driver_type.equalsIgnoreCase("Embedded")) {
                logger.println("Loading the embedded driver...");
                var6_6 = Class.forName(embedDriver);
                var6_6.getConstructor(new Class[0]).newInstance(new Object[0]);
                object2 = embedDbURL + ";dataEncryption=true;bootPassword=12345678";
                embeddedMode = true;
            } else {
                logger.println("Driver type : " + driver_type);
                logger.println("Loading the Derby Client driver..." + driver);
                var6_6 = Class.forName(driver);
                var6_6.getConstructor(new Class[0]).newInstance(new Object[0]);
                logger.println("Client Driver loaded");
                object2 = clientDbURL + ";dataEncryption=true;bootPassword=12345678";
            }
            if (!embeddedMode && START_SERVER_IN_SAME_VM) {
                NsTest.startNetworkServer();
            }
            prop.setProperty("user", "nstest");
            prop.setProperty("password", "nstest");
            logger.println("Getting a connection using the url: " + (String)object2);
            logger.println("JDBC url= " + (String)object2);
            connection = DriverManager.getConnection((String)object2, prop);
        }
        catch (SQLException sQLException) {
            logger.println("\n\n " + sQLException + sQLException.getErrorCode() + " " + sQLException.getSQLState());
            if (sQLException.getErrorCode() == 40000 || sQLException.getSQLState().equalsIgnoreCase("08001")) {
                logger.println("\n Unable to connect, test cannot proceed. Please verify if the Network Server is started on port 1900.");
                return;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.println("Driver not found: " + classNotFoundException.getMessage());
            classNotFoundException.printStackTrace(logger);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace(logger);
            logger.println("Unexpected Failure");
            NsTest.printException("nstest.main() method ==> ", exception);
        }
        if (!DbSetup.doIt(connection)) {
            logger.println("Error in dbSetup, test will exit");
            System.exit(1);
        }
        try {
            connection.close();
        }
        catch (Exception exception) {
            logger.println("FAIL - Error closing the connection in nstest.main():");
            NsTest.printException("Closing connection in nstest.main()", exception);
        }
        logger.println("Starting memory checker thread");
        MemCheck memCheck = new MemCheck(200000);
        memCheck.start();
        if (!schemaCreated) {
            logger.println("Kicking off initialization threads that will populate the test table");
            NsTest[] nsTestArray = new NsTest[INIT_THREADS];
            for (n = 0; n < INIT_THREADS; ++n) {
                nsTestArray[n] = new NsTest(INIT, n);
                nsTestArray[n].start();
                NsTest.sleep(3000L);
            }
            for (n = 0; n < INIT_THREADS; ++n) {
                nsTestArray[n].join();
            }
        }
        if (schemaCreated) {
            logger.println("Schema has already been created by another process!");
        }
        if (CREATE_DATABASE_ONLY) {
            logger.println("Finished creating the database, TEST THREADS WILL NOT RUN!!");
            memCheck.stopNow = true;
            memCheck.join();
            return;
        }
        logger.println("Kicking off test threads that will work over the test table");
        int n2 = 0;
        n = 0;
        String string3 = System.getProperty(BACKUP_FLAG);
        n = string3 != null && string3.equalsIgnoreCase("false") ? NUMTESTER1 + NUMTESTER2 + NUMTESTER3 : 1 + NUMTESTER1 + NUMTESTER2 + NUMTESTER3;
        testThreads = new NsTest[n];
        while (n2 < n) {
            int n3;
            if (string3 != null && string3.equalsIgnoreCase("false")) {
                logger.println("BackupRestore Thread not started...");
            } else {
                NsTest.testThreads[n2] = new NsTest(BACKUP, n2);
                testThreads[n2].start();
                ++n2;
            }
            for (n3 = 0; n3 < NUMTESTER1; ++n3) {
                NsTest.testThreads[n2] = new NsTest(TESTER1, n2);
                testThreads[n2].start();
                NsTest.sleep(3000L);
                ++n2;
            }
            for (n3 = 0; n3 < NUMTESTER2; ++n3) {
                NsTest.testThreads[n2] = new NsTest(TESTER2, n2);
                testThreads[n2].start();
                NsTest.sleep(3000L);
                ++n2;
            }
            for (n3 = 0; n3 < NUMTESTER3; ++n3) {
                NsTest.testThreads[n2] = new NsTest(TESTER3, n2);
                testThreads[n2].start();
                NsTest.sleep(3000L);
                ++n2;
            }
        }
        logger.println("Starting sequence reader thread");
        SequenceReader sequenceReader = new SequenceReader(DriverManager.getConnection((String)object2, prop), 60000);
        sequenceReader.start();
        for (int i = 0; i < n; ++i) {
            logger.println("Waiting for thread " + i + " to join back/finish");
            testThreads[i].join();
        }
        if (object != null) {
            ((TimerThread)object).stopNow();
            ((Thread)object).interrupt();
            ((Thread)object).join();
        }
        sequenceReader.stopNow = true;
        sequenceReader.interrupt();
        sequenceReader.join();
        NsTest.printStatistics();
        memCheck.stopNow = true;
        memCheck.join();
        logger.println("End of test nstest! Look for 'FAIL' messages in the output and derby.log");
    }

    public static void printStatistics() {
        if (_statisticsAlreadyPrinted) {
            return;
        }
        _statisticsAlreadyPrinted = true;
        _endTimestamp = System.currentTimeMillis();
        statisticsLogger.println("");
        statisticsLogger.println("STATISTICS OF OPERATIONS DONE");
        statisticsLogger.println("-----------------------------");
        statisticsLogger.println("\n\n");
        statisticsLogger.println("Start time = " + new Timestamp(_startTimestamp).toString());
        statisticsLogger.println("End time = " + new Timestamp(_endTimestamp).toString());
        statisticsLogger.println("Duration = " + (_endTimestamp - _startTimestamp) / 60000L + " minutes");
        statisticsLogger.println("\n\n");
        statisticsLogger.println("SUCCESSFUL: ");
        statisticsLogger.println("\tNumber of INSERTS = " + numInserts);
        statisticsLogger.println("\tNumber of UPDATES = " + numUpdates);
        statisticsLogger.println("\tNumber of DELETES = " + numDeletes);
        statisticsLogger.println("\tNumber of SELECTS = " + numSelects);
        statisticsLogger.println("");
        statisticsLogger.println("FAILED: ");
        statisticsLogger.println("\tNumber of failed INSERTS = " + numFailedInserts);
        statisticsLogger.println("\tNumber of failed UPDATES = " + numFailedUpdates);
        statisticsLogger.println("\tNumber of failed DELETES = " + numFailedDeletes);
        statisticsLogger.println("\tNumber of failed SELECTS = " + numFailedSelects);
        statisticsLogger.println("");
        statisticsLogger.println("  Note that this may not be the same as the server side connections made\n   to the database especially if connection pooling is employed");
        statisticsLogger.println("");
        statisticsLogger.println("NOTE: Failing operations could be because of locking issue that are\ndirectly related to the application logic.  They are not necessarily bugs.");
        statisticsLogger.println("\nMax sequence counter peeked at = " + _maxSequenceCounter + "\n");
        statisticsLogger.println("\nLast total memory = " + _totalMemory + ", last free memory = " + _freeMemory + " as measured at " + _lastMemoryCheckTime + "\n");
        if (_errors.size() > 0) {
            Object[] objectArray = new NsTestError[_errors.size()];
            _errors.values().toArray(objectArray);
            Arrays.sort(objectArray);
            NsTest.countAndPrintSQLStates();
            for (Object object : objectArray) {
                NsTest.printError((NsTestError)object);
            }
        }
    }

    private static void countAndPrintSQLStates() {
        HashMap<String, int[]> hashMap = new HashMap<String, int[]>();
        for (String string : _errors.keySet()) {
            SQLException sQLException;
            String string2;
            NsTestError nsTestError = _errors.get(string);
            int n = nsTestError.count();
            Throwable throwable = nsTestError.throwable();
            if (!(throwable instanceof SQLException) || (string2 = (sQLException = (SQLException)throwable).getSQLState()) == null) continue;
            int[] nArray = (int[])hashMap.get(string2);
            if (nArray == null) {
                nArray = new int[]{n};
                hashMap.put(string2, nArray);
                continue;
            }
            nArray[0] = nArray[0] + n;
        }
        statisticsLogger.println("\n");
        for (String string : hashMap.keySet()) {
            statisticsLogger.println("\tNumber of " + string + " = " + ((int[])hashMap.get(string))[0]);
        }
        statisticsLogger.println("\n");
    }

    private static void printError(NsTestError nsTestError) {
        Throwable throwable = nsTestError.throwable();
        String string = NsTest.getStackTrace(throwable);
        int n = nsTestError.count();
        Timestamp timestamp = new Timestamp(nsTestError.getFirstOccurrenceTime());
        Timestamp timestamp2 = new Timestamp(nsTestError.getLastOccurrenceTime());
        String string2 = throwable instanceof SQLException ? ((SQLException)throwable).getSQLState() : null;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(ERROR_BANNER1);
        stringBuilder.append(ERROR_BANNER2);
        stringBuilder.append("\n");
        stringBuilder.append(ERROR_BANNER2);
        stringBuilder.append("Count = " + n);
        if (string2 != null) {
            stringBuilder.append(", SQLState = " + string2);
        }
        stringBuilder.append(", Message = " + throwable.getMessage());
        stringBuilder.append("\n");
        stringBuilder.append(ERROR_BANNER2);
        stringBuilder.append("\n");
        stringBuilder.append(ERROR_BANNER2);
        stringBuilder.append("First occurrence at " + timestamp);
        stringBuilder.append(", last occurrence at " + timestamp2);
        stringBuilder.append("\n");
        stringBuilder.append(ERROR_BANNER2);
        stringBuilder.append("\n");
        stringBuilder.append(ERROR_BANNER1);
        stringBuilder.append("\n");
        stringBuilder.append(string);
        stringBuilder.append("\n");
        statisticsLogger.println(stringBuilder.toString());
    }

    @Override
    public void run() {
        logger.println(this.getName() + " is now running");
        if (this.type == INIT) {
            Initializer initializer = new Initializer(this.getName());
            initializer.startInserts();
        } else if (this.type == TESTER1) {
            Tester1 tester1 = new Tester1("Tester1" + this.getName());
            tester1.startTesting();
        } else if (this.type == TESTER2) {
            Tester2 tester2 = new Tester2("Tester2" + this.getName());
            tester2.startTesting();
        } else if (this.type == TESTER3) {
            Tester3 tester3 = new Tester3("Tester3" + this.getName());
            tester3.startTesting();
        } else if (this.type == BACKUP) {
            BackupRestoreReEncryptTester backupRestoreReEncryptTester = null;
            try {
                backupRestoreReEncryptTester = new BackupRestoreReEncryptTester("BackupRestoreReEncrypt" + this.getName());
            }
            catch (IOException iOException) {
                logger.println(iOException + "=====> Unable to create backup log file, test cannot proceed ");
                iOException.printStackTrace(logger);
                return;
            }
            backupRestoreReEncryptTester.startTesting();
        } else {
            logger.println("FAIL: Invalid thread type, should be INIT or TESTERx or BACKUP");
            logger.println("You should check the code and restart");
            return;
        }
        logger.println(this.getName() + " finished and is now exiting");
    }

    public static synchronized void printException(String string, Exception exception) {
        if (NsTest.justCountErrors()) {
            NsTest.addError(exception);
            NsTest.vetError(exception);
            return;
        }
        if (exception instanceof SQLException) {
            SQLException sQLException = (SQLException)exception;
            if (sQLException.getSQLState() != null) {
                if (sQLException.getSQLState().equals("40001")) {
                    logger.println("deadlocked detected");
                }
                if (sQLException.getSQLState().equals("40XL1")) {
                    logger.println(" lock timeout exception");
                }
                if (sQLException.getSQLState().equals("23500")) {
                    logger.println(" duplicate key violation");
                }
            }
            if (sQLException.getNextException() != null) {
                String string2 = sQLException.getNextException().getSQLState();
                logger.println(sQLException.getNextException().getMessage() + " SQLSTATE: " + string2);
            }
        }
        if (exception.getMessage() == null) {
            logger.println("NULL error message detected");
            logger.println("Here is the NULL exection - " + exception.toString());
            logger.println("Stack trace of the NULL exception - ");
            exception.printStackTrace(logger);
        }
        logger.println("At this point - " + string + ", exception thrown was : " + exception.getMessage());
        NsTest.vetError(exception);
    }

    private static void vetError(Throwable throwable) {
        if (throwable == null) {
            return;
        }
        if (throwable instanceof OutOfMemoryError) {
            NsTest.printStatistics();
            Runtime.getRuntime().halt(0);
        }
        NsTest.vetError(throwable.getCause());
        if (throwable instanceof SQLException) {
            SQLException sQLException = (SQLException)throwable;
            NsTest.vetError(sQLException.getNextException());
        }
    }

    public static String getDriverURL() {
        if (driver_type.equalsIgnoreCase("DerbyClient")) {
            return clientURL;
        }
        return embedURL;
    }

    public static void startNetworkServer() throws Exception {
        try {
            NWServerThread nWServerThread = new NWServerThread("localhost", 1900);
            nWServerThread.start();
            Thread.sleep(10000L);
        }
        catch (Exception exception) {
            exception.printStackTrace(logger);
            throw exception;
        }
    }

    public static boolean deadConnection(Throwable throwable) {
        SQLException sQLException;
        return throwable instanceof SQLException && DEAD_CONNECTION.equals((sQLException = (SQLException)throwable).getSQLState());
    }

    public static void printUsage() {
        _statisticsAlreadyPrinted = true;
        System.out.println(USAGE);
    }

    static {
        prop = new Properties();
        INIT = 0;
        TESTER1 = 1;
        TESTER2 = 2;
        TESTER3 = 3;
        BACKUP = 4;
        BACKUPDIR = "backupdir";
        RESTOREDIR = "restoredir";
        START_SERVER_IN_SAME_VM = false;
        AUTO_COMMIT_OFF = false;
        CREATE_DATABASE_ONLY = false;
        schemaCreated = false;
        INIT_THREADS = 6;
        MAX_INITIAL_ROWS = 6000;
        MAX_ITERATIONS = 2000;
        MAX_LOW_STRESS_ROWS = 30;
        MAX_OPERATIONS_PER_CONN = 25;
        NUMTESTER1 = 15;
        NUMTESTER2 = 45;
        NUMTESTER3 = 10;
        NUM_HIGH_STRESS_ROWS = 25000;
        NUM_UNTOUCHED_ROWS = 6000;
        numInserts = 0;
        numUpdates = 0;
        numDeletes = 0;
        numSelects = 0;
        numFailedInserts = 0;
        numFailedUpdates = 0;
        numFailedDeletes = 0;
        numFailedSelects = 0;
        numConnections = 0;
        INSERT = 0;
        UPDATE = 1;
        DELETE = 2;
        SELECT = 3;
        FAILED_INSERT = 4;
        FAILED_UPDATE = 5;
        FAILED_DELETE = 6;
        FAILED_SELECT = 7;
        CONNECTIONS_MADE = 8;
        driver_type = null;
        testThreads = null;
        _errors = new HashMap();
        _statisticsAlreadyPrinted = false;
    }

    public static class ShutdownHook
    implements Runnable {
        @Override
        public void run() {
            NsTest.printStatistics();
        }
    }
}

