/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.junit;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import junit.framework.TestCase;
import org.apache.derby.iapi.services.io.ArrayInputStream;
import org.apache.derby.iapi.services.io.ArrayOutputStream;
import org.apache.derby.iapi.services.io.CompressedNumber;

public class CompressedNumberTest
extends TestCase {
    private static byte[] holder = new byte[8];
    private static ArrayOutputStream aos = new ArrayOutputStream(holder);
    private static DataOutput out = new DataOutputStream((OutputStream)aos);
    private static ArrayInputStream ais = new ArrayInputStream(holder);
    private static DataInput in = new DataInputStream((InputStream)ais);
    private static InputStream in_stream = ais;

    public CompressedNumberTest(String string) {
        super(string);
    }

    public void testLong() throws IOException {
        long[] lArray = new long[]{0L, 1L, 2L, 16381L, 16382L, 16383L, 16384L, 16385L, 0x3FFFFFFBL, 0x3FFFFFFCL, 0x3FFFFFFDL, 0x3FFFFFFEL, 0x3FFFFFFFL, 0x40000000L, 0x40000001L, 0x40000002L, 0x40000003L, 0x6FFFFFFEL, 0x6FFFFFFFL, 0x70000000L, 0x70000001L, 0x70000002L, 0x7FFFFFFFFFFFFFFDL, 0x7FFFFFFFFFFFFFFEL, Long.MAX_VALUE};
        int[] nArray = new int[]{2, 2, 2, 2, 2, 2, 4, 4, 4, 4, 4, 4, 4, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8};
        for (int i = 0; i < lArray.length; ++i) {
            this.checkLong(lArray[i], nArray[i]);
        }
    }

    public void testLongWidely() throws IOException {
        for (long i = 0L; i < 983040L; ++i) {
            if (i <= 16383L) {
                this.checkLong(i, 2);
                continue;
            }
            if (i <= 0x3FFFFFFFL) {
                this.checkLong(i, 4);
                continue;
            }
            this.checkLong(i, 8);
        }
    }

    public void testInt() throws IOException {
        int[] nArray = new int[]{0, 1, 2, 59, 60, 61, 62, 63, 64, 65, 66, 67, 16252, 16253, 16254, 16255, 16256, 16257, 16258, 16259, 16260, 16379, 16380, 16381, 16382, 16383, 16384, 16385, 16386, 16387, 0x7FFFFFFB, 0x7FFFFFFC, 0x7FFFFFFD, 0x7FFFFFFE, Integer.MAX_VALUE};
        int[] nArray2 = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 4, 4, 4, 4, 4, 4, 4, 4};
        for (int i = 0; i < nArray.length; ++i) {
            this.checkInt(nArray[i], nArray2[i]);
        }
    }

    public void testIntWidely() throws IOException {
        for (int i = 0; i < 983040; ++i) {
            if (i <= 63) {
                this.checkInt(i, 1);
                continue;
            }
            if (i <= 16383) {
                this.checkInt(i, 2);
                continue;
            }
            this.checkInt(i, 4);
        }
    }

    private void checkInt(int n, int n2) throws IOException {
        aos.setPosition(0);
        int n3 = CompressedNumber.writeInt((DataOutput)out, (int)n);
        CompressedNumberTest.assertEquals((String)"Invalid length after compressed", (int)n2, (int)n3);
        CompressedNumberTest.assertEquals((String)"MISMATCH written bytes", (int)n3, (int)aos.getPosition());
        CompressedNumberTest.assertEquals((String)"MISMATCH sizeInt() bytes", (int)n3, (int)CompressedNumber.sizeInt((int)n));
        ais.setPosition(0);
        CompressedNumberTest.assertEquals((String)"MISMATCH value readInt(DataInput)", (int)n, (int)CompressedNumber.readInt((DataInput)in));
        ais.setPosition(0);
        CompressedNumberTest.assertEquals((String)"MISMATCH value readInt(DataInput)", (int)n, (int)ais.readCompressedInt());
        ais.setPosition(0);
        CompressedNumberTest.assertEquals((String)"MISMATCH value in readInt(InputStream)", (int)n, (int)CompressedNumber.readInt((InputStream)in_stream));
        CompressedNumberTest.assertEquals((String)"MISMATCH frome readInt(byte[], offset)", (int)n, (int)CompressedNumber.readInt((byte[])holder, (int)0));
    }

    private void checkLong(long l, int n) throws IOException {
        aos.setPosition(0);
        int n2 = CompressedNumber.writeLong((DataOutput)out, (long)l);
        CompressedNumberTest.assertEquals((String)"Invalid length after compressed", (int)n, (int)n2);
        CompressedNumberTest.assertEquals((String)"MISMATCH written bytes", (int)n2, (int)aos.getPosition());
        CompressedNumberTest.assertEquals((String)"MISMATCH sizeLong() bytes", (int)n2, (int)CompressedNumber.sizeLong((long)l));
        CompressedNumberTest.assertEquals((String)"MISMATCH in readLong(byte[], offset) value", (long)l, (long)CompressedNumber.readLong((byte[])holder, (int)0));
        ais.setPosition(0);
        CompressedNumberTest.assertEquals((String)"MISMATCH value in readLong(InputStream)", (long)l, (long)CompressedNumber.readLong((InputStream)in_stream));
        ais.setPosition(0);
        CompressedNumberTest.assertEquals((String)"MISMATCH value in readLong(InputStream)", (long)l, (long)ais.readCompressedLong());
        ais.setPosition(0);
        CompressedNumberTest.assertEquals((String)"MISMATCH value in readLong(DataInput)", (long)l, (long)CompressedNumber.readLong((DataInput)in));
    }
}

